/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;

public class SourceFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_source";
    public static final String RECOVERY_SOURCE_NAME = "_recovery_source";
    public static final String CONTENT_TYPE = "_source";
    private final Function<Map<String, ?>, Map<String, Object>> filter;
    private static final SourceFieldMapper DEFAULT = new SourceFieldMapper(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.ConfigurableTypeParser(c -> DEFAULT, c -> new Builder());
    private final boolean enabled;
    private final boolean complete;
    private final String[] includes;
    private final String[] excludes;

    private static SourceFieldMapper toType(FieldMapper in) {
        return (SourceFieldMapper)in;
    }

    private SourceFieldMapper(boolean enabled, String[] includes, String[] excludes) {
        super(new SourceFieldType(enabled));
        this.enabled = enabled;
        this.includes = includes;
        this.excludes = excludes;
        boolean filtered = !CollectionUtils.isEmpty(includes) || !CollectionUtils.isEmpty(excludes);
        this.filter = enabled && filtered ? XContentMapValues.filter(includes, excludes) : null;
        this.complete = enabled && CollectionUtils.isEmpty(includes) && CollectionUtils.isEmpty(excludes);
    }

    public boolean enabled() {
        return this.enabled;
    }

    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public void preParse(DocumentParserContext context) throws IOException {
        BytesRef ref;
        XContentType contentType;
        BytesReference originalSource = context.sourceToParse().source();
        BytesReference adaptedSource = this.applyFilters(originalSource, contentType = context.sourceToParse().getXContentType());
        if (adaptedSource != null) {
            ref = adaptedSource.toBytesRef();
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), ref.bytes, ref.offset, ref.length));
        }
        if (originalSource != null && adaptedSource != originalSource) {
            ref = originalSource.toBytesRef();
            context.doc().add((IndexableField)new StoredField(RECOVERY_SOURCE_NAME, ref.bytes, ref.offset, ref.length));
            context.doc().add((IndexableField)new NumericDocValuesField(RECOVERY_SOURCE_NAME, 1L));
        }
    }

    @Nullable
    public BytesReference applyFilters(@Nullable BytesReference originalSource, @Nullable XContentType contentType) throws IOException {
        if (this.enabled && originalSource != null) {
            if (this.filter != null) {
                Tuple<XContentType, Map<String, Object>> mapTuple = XContentHelper.convertToMap(originalSource, true, contentType);
                Map<String, Object> filteredSource = this.filter.apply((Map)mapTuple.v2());
                BytesStreamOutput bStream = new BytesStreamOutput();
                XContentType actualContentType = (XContentType)mapTuple.v1();
                XContentBuilder builder = XContentFactory.contentBuilder((XContentType)actualContentType, (OutputStream)bStream).map(filteredSource);
                builder.close();
                return bStream.bytes();
            }
            return originalSource;
        }
        return null;
    }

    @Override
    protected String contentType() {
        return "_source";
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder().init(this);
    }

    static final class SourceFieldType
    extends MappedFieldType {
        private SourceFieldType(boolean enabled) {
            super("_source", false, enabled, false, TextSearchInfo.NONE, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return "_source";
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for internal field [" + this.name() + "].");
        }

        @Override
        public Query existsQuery(SearchExecutionContext context) {
            throw new QueryShardException(context, "The _source field is not searchable", new Object[0]);
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new QueryShardException(context, "The _source field is not searchable", new Object[0]);
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> enabled = FieldMapper.Parameter.boolParam("enabled", false, m -> SourceFieldMapper.toType((FieldMapper)m).enabled, true);
        private final FieldMapper.Parameter<List<String>> includes = FieldMapper.Parameter.stringArrayParam("includes", false, m -> Arrays.asList(SourceFieldMapper.toType((FieldMapper)m).includes), Collections.emptyList());
        private final FieldMapper.Parameter<List<String>> excludes = FieldMapper.Parameter.stringArrayParam("excludes", false, m -> Arrays.asList(SourceFieldMapper.toType((FieldMapper)m).excludes), Collections.emptyList());

        public Builder() {
            super("_source");
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return List.of(this.enabled, this.includes, this.excludes);
        }

        @Override
        public SourceFieldMapper build() {
            if (this.enabled.getValue().booleanValue() && this.includes.getValue().isEmpty() && this.excludes.getValue().isEmpty()) {
                return DEFAULT;
            }
            return new SourceFieldMapper(this.enabled.getValue(), (String[])this.includes.getValue().toArray(String[]::new), (String[])this.excludes.getValue().toArray(String[]::new));
        }
    }

    public static class Defaults {
        public static final String NAME = "_source";
        public static final boolean ENABLED = true;
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

