/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.snapshots.blobstore;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class BlobStoreIndexShardSnapshot
implements ToXContentFragment {
    private final String snapshot;
    private final long indexVersion;
    private final long startTime;
    private final long time;
    private final int incrementalFileCount;
    private final long incrementalSize;
    private final List<FileInfo> indexFiles;
    private static final String NAME = "name";
    private static final String INDEX_VERSION = "index_version";
    private static final String START_TIME = "start_time";
    private static final String TIME = "time";
    private static final String FILES = "files";
    private static final String INCREMENTAL_FILE_COUNT = "number_of_files";
    private static final String INCREMENTAL_SIZE = "total_size";
    private static final ParseField PARSE_NAME = new ParseField("name", new String[0]);
    private static final ParseField PARSE_INDEX_VERSION = new ParseField("index_version", new String[]{"index-version"});
    private static final ParseField PARSE_START_TIME = new ParseField("start_time", new String[0]);
    private static final ParseField PARSE_TIME = new ParseField("time", new String[0]);
    private static final ParseField PARSE_INCREMENTAL_FILE_COUNT = new ParseField("number_of_files", new String[0]);
    private static final ParseField PARSE_INCREMENTAL_SIZE = new ParseField("total_size", new String[0]);
    private static final ParseField PARSE_FILES = new ParseField("files", new String[0]);

    public BlobStoreIndexShardSnapshot(String snapshot, long indexVersion, List<FileInfo> indexFiles, long startTime, long time, int incrementalFileCount, long incrementalSize) {
        assert (snapshot != null);
        assert (indexVersion >= 0L);
        this.snapshot = snapshot;
        this.indexVersion = indexVersion;
        this.indexFiles = List.copyOf(indexFiles);
        this.startTime = startTime;
        this.time = time;
        this.incrementalFileCount = incrementalFileCount;
        this.incrementalSize = incrementalSize;
    }

    public BlobStoreIndexShardSnapshot asClone(String targetSnapshotName, long startTime, long time) {
        return new BlobStoreIndexShardSnapshot(targetSnapshotName, this.indexVersion, this.indexFiles, startTime, time, 0, 0L);
    }

    public String snapshot() {
        return this.snapshot;
    }

    public List<FileInfo> indexFiles() {
        return this.indexFiles;
    }

    public long startTime() {
        return this.startTime;
    }

    public long time() {
        return this.time;
    }

    public int incrementalFileCount() {
        return this.incrementalFileCount;
    }

    public int totalFileCount() {
        return this.indexFiles.size();
    }

    public long incrementalSize() {
        return this.incrementalSize;
    }

    public long totalSize() {
        return BlobStoreIndexShardSnapshot.totalSize(this.indexFiles);
    }

    public static long totalSize(List<FileInfo> indexFiles) {
        return indexFiles.stream().mapToLong(fi -> fi.metadata().length()).sum();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(NAME, this.snapshot);
        builder.field(INDEX_VERSION, this.indexVersion);
        builder.field(START_TIME, this.startTime);
        builder.field(TIME, this.time);
        builder.field(INCREMENTAL_FILE_COUNT, this.incrementalFileCount);
        builder.field(INCREMENTAL_SIZE, this.incrementalSize);
        builder.startArray(FILES);
        for (FileInfo fileInfo : this.indexFiles) {
            FileInfo.toXContent(fileInfo, builder, params);
        }
        builder.endArray();
        return builder;
    }

    public static BlobStoreIndexShardSnapshot fromXContent(XContentParser parser) throws IOException {
        String snapshot = null;
        long indexVersion = -1L;
        long startTime = 0L;
        long time = 0L;
        int incrementalFileCount = 0;
        long incrementalSize = 0L;
        List indexFiles = null;
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
            String currentFieldName = parser.currentName();
            token = parser.nextToken();
            if (token.isValue()) {
                if (PARSE_NAME.match(currentFieldName, parser.getDeprecationHandler())) {
                    snapshot = parser.text();
                    continue;
                }
                if (PARSE_INDEX_VERSION.match(currentFieldName, parser.getDeprecationHandler())) {
                    indexVersion = parser.longValue();
                    continue;
                }
                if (PARSE_START_TIME.match(currentFieldName, parser.getDeprecationHandler())) {
                    startTime = parser.longValue();
                    continue;
                }
                if (PARSE_TIME.match(currentFieldName, parser.getDeprecationHandler())) {
                    time = parser.longValue();
                    continue;
                }
                if (PARSE_INCREMENTAL_FILE_COUNT.match(currentFieldName, parser.getDeprecationHandler())) {
                    incrementalFileCount = parser.intValue();
                    continue;
                }
                if (PARSE_INCREMENTAL_SIZE.match(currentFieldName, parser.getDeprecationHandler())) {
                    incrementalSize = parser.longValue();
                    continue;
                }
                XContentParserUtils.throwUnknownField(currentFieldName, parser.getTokenLocation());
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (PARSE_FILES.match(currentFieldName, parser.getDeprecationHandler())) {
                    indexFiles = XContentParserUtils.parseList(parser, FileInfo::fromXContent);
                    continue;
                }
                XContentParserUtils.throwUnknownField(currentFieldName, parser.getTokenLocation());
                continue;
            }
            XContentParserUtils.throwUnknownToken(token, parser.getTokenLocation());
        }
        return new BlobStoreIndexShardSnapshot(snapshot, indexVersion, indexFiles == null ? List.of() : indexFiles, startTime, time, incrementalFileCount, incrementalSize);
    }

    public static class FileInfo
    implements Writeable {
        public static final String SERIALIZE_WRITER_UUID = "serialize_writer_uuid";
        private final String name;
        private final ByteSizeValue partSize;
        private final long partBytes;
        private final int numberOfParts;
        private final StoreFileMetadata metadata;
        static final String NAME = "name";
        static final String PHYSICAL_NAME = "physical_name";
        static final String LENGTH = "length";
        static final String CHECKSUM = "checksum";
        static final String PART_SIZE = "part_size";
        static final String WRITTEN_BY = "written_by";
        static final String META_HASH = "meta_hash";
        static final String WRITER_UUID = "writer_uuid";

        public FileInfo(String name, StoreFileMetadata metadata, ByteSizeValue partSize) {
            this.name = Objects.requireNonNull(name);
            this.metadata = metadata;
            long partBytes = Long.MAX_VALUE;
            if (partSize != null && partSize.getBytes() > 0L) {
                partBytes = partSize.getBytes();
            }
            if (metadata.length() == 0L) {
                this.numberOfParts = 1;
            } else {
                long longNumberOfParts = 1L + (metadata.length() - 1L) / partBytes;
                this.numberOfParts = (int)longNumberOfParts;
                if ((long)this.numberOfParts != longNumberOfParts) {
                    throw new IllegalArgumentException("part size [" + partSize + "] too small for file [" + metadata + "]");
                }
            }
            this.partSize = partSize;
            this.partBytes = partBytes;
            assert (IntStream.range(0, this.numberOfParts).mapToLong(this::partBytes).sum() == metadata.length());
        }

        public FileInfo(StreamInput in) throws IOException {
            this(in.readString(), new StoreFileMetadata(in), in.readOptionalWriteable(ByteSizeValue::new));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            this.metadata.writeTo(out);
            out.writeOptionalWriteable(this.partSize);
        }

        public String name() {
            return this.name;
        }

        public String partName(int part) {
            if (this.numberOfParts > 1) {
                return this.name + ".part" + part;
            }
            return this.name;
        }

        public static String canonicalName(String blobName) {
            if (blobName.contains(".part")) {
                return blobName.substring(0, blobName.indexOf(".part"));
            }
            return blobName;
        }

        public String physicalName() {
            return this.metadata.name();
        }

        public long length() {
            return this.metadata.length();
        }

        public ByteSizeValue partSize() {
            return this.partSize;
        }

        public long partBytes(int part) {
            assert (0 <= part && part < this.numberOfParts) : part + " vs " + this.numberOfParts;
            if (this.numberOfParts == 1) {
                return this.length();
            }
            if (part < this.numberOfParts - 1) {
                return this.partBytes;
            }
            long lastPartBytes = this.length() - this.partBytes * (long)(this.numberOfParts - 1);
            assert (0L < lastPartBytes && lastPartBytes <= this.partBytes) : lastPartBytes + " vs " + this.partBytes;
            return lastPartBytes;
        }

        public int numberOfParts() {
            return this.numberOfParts;
        }

        public String checksum() {
            return this.metadata.checksum();
        }

        public StoreFileMetadata metadata() {
            return this.metadata;
        }

        public boolean isSame(StoreFileMetadata md) {
            return this.metadata.isSame(md);
        }

        public boolean isSame(FileInfo fileInfo) {
            if (this.numberOfParts != fileInfo.numberOfParts) {
                return false;
            }
            if (this.partBytes != fileInfo.partBytes) {
                return false;
            }
            if (!this.name.equals(fileInfo.name)) {
                return false;
            }
            if (this.partSize != null ? !this.partSize.equals(fileInfo.partSize) : fileInfo.partSize != null) {
                return false;
            }
            return this.metadata.isSame(fileInfo.metadata);
        }

        public static void toXContent(FileInfo file, XContentBuilder builder, ToXContent.Params params) throws IOException {
            BytesRef hash;
            builder.startObject();
            builder.field("name", file.name);
            builder.field(PHYSICAL_NAME, file.metadata.name());
            builder.field(LENGTH, file.metadata.length());
            builder.field(CHECKSUM, file.metadata.checksum());
            if (file.partSize != null) {
                builder.field(PART_SIZE, file.partSize.getBytes());
            }
            if (file.metadata.writtenBy() != null) {
                builder.field(WRITTEN_BY, file.metadata.writtenBy());
            }
            if ((hash = file.metadata.hash()) != null && hash.length > 0) {
                builder.field(META_HASH, hash.bytes, hash.offset, hash.length);
            }
            BytesRef writerUuid = file.metadata.writerUuid();
            if (writerUuid.length > 0 && params.paramAsBoolean(SERIALIZE_WRITER_UUID, true)) {
                builder.field(WRITER_UUID, writerUuid.bytes, writerUuid.offset, writerUuid.length);
            }
            builder.endObject();
        }

        public static FileInfo fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.currentToken();
            String name = null;
            String physicalName = null;
            long length = -1L;
            String checksum = null;
            ByteSizeValue partSize = null;
            String writtenBy = null;
            BytesRef metaHash = new BytesRef();
            BytesRef writerUuid = StoreFileMetadata.UNAVAILABLE_WRITER_UUID;
            XContentParserUtils.ensureExpectedToken(token, XContentParser.Token.START_OBJECT, parser);
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    String currentFieldName = parser.currentName();
                    token = parser.nextToken();
                    if (token.isValue()) {
                        if ("name".equals(currentFieldName)) {
                            name = parser.text();
                            continue;
                        }
                        if (PHYSICAL_NAME.equals(currentFieldName)) {
                            physicalName = parser.text();
                            continue;
                        }
                        if (LENGTH.equals(currentFieldName)) {
                            length = parser.longValue();
                            continue;
                        }
                        if (CHECKSUM.equals(currentFieldName)) {
                            checksum = parser.text();
                            continue;
                        }
                        if (PART_SIZE.equals(currentFieldName)) {
                            partSize = new ByteSizeValue(parser.longValue());
                            continue;
                        }
                        if (WRITTEN_BY.equals(currentFieldName)) {
                            writtenBy = parser.text();
                            continue;
                        }
                        if (META_HASH.equals(currentFieldName)) {
                            metaHash.bytes = parser.binaryValue();
                            metaHash.offset = 0;
                            metaHash.length = metaHash.bytes.length;
                            continue;
                        }
                        if (WRITER_UUID.equals(currentFieldName)) {
                            writerUuid = new BytesRef(parser.binaryValue());
                            assert (writerUuid.length > 0);
                            continue;
                        }
                        XContentParserUtils.throwUnknownField(currentFieldName, parser.getTokenLocation());
                        continue;
                    }
                    XContentParserUtils.throwUnknownToken(token, parser.getTokenLocation());
                    continue;
                }
                XContentParserUtils.throwUnknownToken(token, parser.getTokenLocation());
            }
            if (name == null || !Strings.validFileName(name)) {
                throw new ElasticsearchParseException("missing or invalid file name [" + name + "]", new Object[0]);
            }
            if (physicalName == null || !Strings.validFileName(physicalName)) {
                throw new ElasticsearchParseException("missing or invalid physical file name [" + physicalName + "]", new Object[0]);
            }
            if (length < 0L) {
                throw new ElasticsearchParseException("missing or invalid file length", new Object[0]);
            }
            if (writtenBy == null) {
                throw new ElasticsearchParseException("missing or invalid written_by [" + writtenBy + "]", new Object[0]);
            }
            if (checksum == null) {
                throw new ElasticsearchParseException("missing checksum for name [" + name + "]", new Object[0]);
            }
            return new FileInfo(name, new StoreFileMetadata(physicalName, length, checksum, writtenBy, metaHash, writerUuid), partSize);
        }

        public String toString() {
            return "[name: " + this.name + ", numberOfParts: " + this.numberOfParts + ", partSize: " + this.partSize + ", partBytes: " + this.partBytes + ", metadata: " + this.metadata + "]";
        }
    }
}

