/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.xcontent.MediaType;
import org.elasticsearch.xcontent.MediaTypeRegistry;
import org.elasticsearch.xcontent.XContentType;

@FunctionalInterface
public interface RestHandler {
    public void handleRequest(RestRequest var1, RestChannel var2, NodeClient var3) throws Exception;

    default public boolean canTripCircuitBreaker() {
        return true;
    }

    default public boolean supportsContentStream() {
        return false;
    }

    default public boolean allowsUnsafeBuffers() {
        return false;
    }

    default public List<Route> routes() {
        return Collections.emptyList();
    }

    default public boolean allowSystemIndexAccessByDefault() {
        return false;
    }

    default public MediaTypeRegistry<? extends MediaType> validAcceptMediaTypes() {
        return XContentType.MEDIA_TYPE_REGISTRY;
    }

    public static class Route {
        private final RestRequest.Method method;
        private final String path;
        private final RestApiVersion restApiVersion;
        private final String deprecationMessage;
        private final Route replacedRoute;

        private Route(RestRequest.Method method, String path, RestApiVersion restApiVersion, String deprecationMessage, Route replacedRoute) {
            this.method = Objects.requireNonNull(method);
            this.path = Objects.requireNonNull(path);
            this.restApiVersion = Objects.requireNonNull(restApiVersion);
            this.deprecationMessage = deprecationMessage;
            this.replacedRoute = replacedRoute;
        }

        public Route(RestRequest.Method method, String path) {
            this(method, path, RestApiVersion.current(), null, null);
        }

        public static RouteBuilder builder(RestRequest.Method method, String path) {
            return new RouteBuilder(method, path);
        }

        public String getPath() {
            return this.path;
        }

        public RestRequest.Method getMethod() {
            return this.method;
        }

        public RestApiVersion getRestApiVersion() {
            return this.restApiVersion;
        }

        public String getDeprecationMessage() {
            return this.deprecationMessage;
        }

        public boolean isDeprecated() {
            return this.deprecationMessage != null;
        }

        public Route getReplacedRoute() {
            return this.replacedRoute;
        }

        public boolean isReplacement() {
            return this.replacedRoute != null;
        }

        public static class RouteBuilder {
            private final RestRequest.Method method;
            private final String path;
            private RestApiVersion restApiVersion;
            private String deprecationMessage;
            private Route replacedRoute;

            private RouteBuilder(RestRequest.Method method, String path) {
                this.method = Objects.requireNonNull(method);
                this.path = Objects.requireNonNull(path);
                this.restApiVersion = RestApiVersion.current();
            }

            public RouteBuilder deprecated(String deprecationMessage, RestApiVersion deprecatedInVersion) {
                assert (this.replacedRoute == null);
                this.restApiVersion = Objects.requireNonNull(deprecatedInVersion);
                this.deprecationMessage = Objects.requireNonNull(deprecationMessage);
                return this;
            }

            public RouteBuilder replaces(RestRequest.Method method, String path, RestApiVersion replacedInVersion) {
                assert (this.deprecationMessage == null);
                this.replacedRoute = new Route(method, path, replacedInVersion, null, null);
                return this;
            }

            public Route build() {
                if (this.replacedRoute != null) {
                    return new Route(this.method, this.path, this.restApiVersion, null, this.replacedRoute);
                }
                if (this.deprecationMessage != null) {
                    return new Route(this.method, this.path, this.restApiVersion, this.deprecationMessage, null);
                }
                return new Route(this.method, this.path, this.restApiVersion, null, null);
            }
        }
    }
}

