/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;

public class RestPutMappingAction
extends BaseRestHandler {
    public static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Specifying types in put mapping request is deprecated. Use typeless api instead";
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestPutMappingAction.class);

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_mapping/"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_mapping/"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_mappings/"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_mappings/"), RestHandler.Route.builder(RestRequest.Method.POST, "/{index}/{type}/_mapping").deprecated(TYPES_DEPRECATION_MESSAGE, RestApiVersion.V_7).build(), RestHandler.Route.builder(RestRequest.Method.PUT, "/{index}/{type}/_mapping").deprecated(TYPES_DEPRECATION_MESSAGE, RestApiVersion.V_7).build(), RestHandler.Route.builder(RestRequest.Method.POST, "/{index}/_mapping/{type}").deprecated(TYPES_DEPRECATION_MESSAGE, RestApiVersion.V_7).build(), RestHandler.Route.builder(RestRequest.Method.PUT, "/{index}/_mapping/{type}").deprecated(TYPES_DEPRECATION_MESSAGE, RestApiVersion.V_7).build(), RestHandler.Route.builder(RestRequest.Method.POST, "/_mapping/{type}").deprecated(TYPES_DEPRECATION_MESSAGE, RestApiVersion.V_7).build(), RestHandler.Route.builder(RestRequest.Method.PUT, "/_mapping/{type}").deprecated(TYPES_DEPRECATION_MESSAGE, RestApiVersion.V_7).build(), RestHandler.Route.builder(RestRequest.Method.POST, "/{index}/{type}/_mappings").deprecated(TYPES_DEPRECATION_MESSAGE, RestApiVersion.V_7).build(), RestHandler.Route.builder(RestRequest.Method.PUT, "/{index}/{type}/_mappings").deprecated(TYPES_DEPRECATION_MESSAGE, RestApiVersion.V_7).build(), RestHandler.Route.builder(RestRequest.Method.POST, "/{index}/_mappings/{type}").deprecated(TYPES_DEPRECATION_MESSAGE, RestApiVersion.V_7).build(), RestHandler.Route.builder(RestRequest.Method.PUT, "/{index}/_mappings/{type}").deprecated(TYPES_DEPRECATION_MESSAGE, RestApiVersion.V_7).build(), RestHandler.Route.builder(RestRequest.Method.POST, "/_mappings/{type}").deprecated(TYPES_DEPRECATION_MESSAGE, RestApiVersion.V_7).build(), RestHandler.Route.builder(RestRequest.Method.PUT, "/_mappings/{type}").deprecated(TYPES_DEPRECATION_MESSAGE, RestApiVersion.V_7).build());
    }

    @Override
    public String getName() {
        return "put_mapping_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        PutMappingRequest putMappingRequest = Requests.putMappingRequest(Strings.splitStringByCommaToArray(request.param("index")));
        Map sourceAsMap = (Map)XContentHelper.convertToMap(request.requiredContent(), false, request.getXContentType()).v2();
        if (request.getRestApiVersion() == RestApiVersion.V_7) {
            boolean includeTypeName = request.paramAsBoolean("include_type_name", false);
            if (request.hasParam("include_type_name")) {
                deprecationLogger.compatibleCritical("put_mapping_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
            }
            String type = request.param("type");
            if (!includeTypeName && (type != null || MapperService.isMappingSourceTyped("_doc", sourceAsMap))) {
                throw new IllegalArgumentException("Types cannot be provided in put mapping requests, unless the include_type_name parameter is set to true.");
            }
            Map<String, Object> mappingSource = this.prepareV7Mappings(includeTypeName, sourceAsMap);
            putMappingRequest.source(mappingSource);
        } else {
            if (MapperService.isMappingSourceTyped("_doc", sourceAsMap)) {
                throw new IllegalArgumentException("Types cannot be provided in put mapping requests");
            }
            putMappingRequest.source(sourceAsMap);
        }
        putMappingRequest.timeout(request.paramAsTime("timeout", putMappingRequest.timeout()));
        putMappingRequest.masterNodeTimeout(request.paramAsTime("master_timeout", putMappingRequest.masterNodeTimeout()));
        putMappingRequest.indicesOptions(IndicesOptions.fromRequest(request, putMappingRequest.indicesOptions()));
        putMappingRequest.writeIndexOnly(request.paramAsBoolean("write_index_only", false));
        return channel -> client.admin().indices().putMapping(putMappingRequest, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel));
    }

    private Map<String, Object> prepareV7Mappings(boolean includeTypeName, Map<String, Object> mappings) {
        if (includeTypeName && mappings != null && mappings.size() == 1) {
            String typeName = mappings.keySet().iterator().next();
            if (!Strings.hasText(typeName)) {
                throw new IllegalArgumentException("name cannot be empty string");
            }
            Map typelessMappings = (Map)mappings.get(typeName);
            return typelessMappings;
        }
        return mappings;
    }
}

