/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.document;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestResponseListener;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.xcontent.XContentBuilder;

public class RestGetSourceAction
extends BaseRestHandler {
    private final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestGetSourceAction.class);
    static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Specifying types in get_source and exist_source requests is deprecated.";

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/{index}/_source/{id}"), new RestHandler.Route(RestRequest.Method.HEAD, "/{index}/_source/{id}"), RestHandler.Route.builder(RestRequest.Method.GET, "/{index}/{type}/{id}/_source").deprecated(TYPES_DEPRECATION_MESSAGE, RestApiVersion.V_7).build(), RestHandler.Route.builder(RestRequest.Method.HEAD, "/{index}/{type}/{id}/_source").deprecated(TYPES_DEPRECATION_MESSAGE, RestApiVersion.V_7).build());
    }

    @Override
    public String getName() {
        return "document_get_source_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (request.getRestApiVersion() == RestApiVersion.V_7 && request.hasParam("type")) {
            request.param("type");
            this.deprecationLogger.compatibleCritical("get_source_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
        }
        GetRequest getRequest = new GetRequest(request.param("index"), request.param("id"));
        getRequest.refresh(request.paramAsBoolean("refresh", getRequest.refresh()));
        getRequest.routing(request.param("routing"));
        getRequest.preference(request.param("preference"));
        getRequest.realtime(request.paramAsBoolean("realtime", getRequest.realtime()));
        getRequest.fetchSourceContext(FetchSourceContext.parseFromRestRequest(request));
        return channel -> {
            if (getRequest.fetchSourceContext() != null && !getRequest.fetchSourceContext().fetchSource()) {
                ActionRequestValidationException validationError = new ActionRequestValidationException();
                validationError.addValidationError("fetching source can not be disabled");
                channel.sendResponse(new BytesRestResponse((RestChannel)channel, validationError));
            } else {
                client.get(getRequest, new RestGetSourceResponseListener((RestChannel)channel, request));
            }
        };
    }

    static class RestGetSourceResponseListener
    extends RestResponseListener<GetResponse> {
        private final RestRequest request;

        RestGetSourceResponseListener(RestChannel channel, RestRequest request) {
            super(channel);
            this.request = request;
        }

        @Override
        public RestResponse buildResponse(GetResponse response) throws Exception {
            this.checkResource(response);
            XContentBuilder builder = this.channel.newBuilder(this.request.getXContentType(), false);
            BytesReference source = response.getSourceInternal();
            try (StreamInput stream = source.streamInput();){
                builder.rawValue((InputStream)stream, XContentHelper.xContentType(source));
            }
            return new BytesRestResponse(RestStatus.OK, builder);
        }

        private void checkResource(GetResponse response) {
            String index = response.getIndex();
            String id = response.getId();
            if (!response.isExists()) {
                throw new ResourceNotFoundException("Document not found [" + index + "]/[" + id + "]", new Object[0]);
            }
            if (response.isSourceEmpty()) {
                throw new ResourceNotFoundException("Source not found [" + index + "]/[" + id + "]", new Object[0]);
            }
        }
    }
}

