/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline;

import java.util.List;
import java.util.Map;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.SiblingPipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationPath;

public abstract class BucketMetricsPipelineAggregator
extends SiblingPipelineAggregator {
    protected final DocValueFormat format;
    protected final BucketHelpers.GapPolicy gapPolicy;

    BucketMetricsPipelineAggregator(String name, String[] bucketsPaths, BucketHelpers.GapPolicy gapPolicy, DocValueFormat format, Map<String, Object> metadata) {
        super(name, bucketsPaths, metadata);
        this.gapPolicy = gapPolicy;
        this.format = format;
    }

    @Override
    public final InternalAggregation doReduce(Aggregations aggregations, InternalAggregation.ReduceContext context) {
        this.preCollection();
        List<String> bucketsPath = AggregationPath.parse(this.bucketsPaths()[0]).getPathElementsAsStringList();
        for (Aggregation aggregation : aggregations) {
            if (!aggregation.getName().equals(bucketsPath.get(0))) continue;
            List<String> sublistedPath = bucketsPath.subList(1, bucketsPath.size());
            InternalMultiBucketAggregation multiBucketsAgg = (InternalMultiBucketAggregation)aggregation;
            List buckets = multiBucketsAgg.getBuckets();
            for (InternalMultiBucketAggregation.InternalBucket bucket : buckets) {
                Double bucketValue = BucketHelpers.resolveBucketValue((MultiBucketsAggregation)multiBucketsAgg, bucket, sublistedPath, this.gapPolicy);
                if (bucketValue == null || Double.isNaN(bucketValue)) continue;
                this.collectBucketValue(bucket.getKeyAsString(), bucketValue);
            }
        }
        return this.buildAggregation(this.metadata());
    }

    protected void preCollection() {
    }

    protected abstract InternalAggregation buildAggregation(Map<String, Object> var1);

    protected abstract void collectBucketValue(String var1, Double var2);
}

