/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.storage;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.DiskUsage;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamMetadata;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeFilters;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.cluster.routing.allocation.decider.DiskThresholdDecider;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.snapshots.SnapshotShardSizeInfo;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingCapacity;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderContext;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderResult;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderService;
import org.elasticsearch.xpack.cluster.routing.allocation.DataTierAllocationDecider;

public class ReactiveStorageDeciderService
implements AutoscalingDeciderService {
    public static final String NAME = "reactive_storage";
    private final DiskThresholdSettings diskThresholdSettings;
    private final DataTierAllocationDecider dataTierAllocationDecider;
    private final AllocationDeciders allocationDeciders;

    public ReactiveStorageDeciderService(Settings settings, ClusterSettings clusterSettings, AllocationDeciders allocationDeciders) {
        this.diskThresholdSettings = new DiskThresholdSettings(settings, clusterSettings);
        this.dataTierAllocationDecider = new DataTierAllocationDecider();
        this.allocationDeciders = allocationDeciders;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public List<Setting<?>> deciderSettings() {
        return List.of();
    }

    @Override
    public List<DiscoveryNodeRole> roles() {
        return List.of(DiscoveryNodeRole.DATA_ROLE, DiscoveryNodeRole.DATA_CONTENT_NODE_ROLE, DiscoveryNodeRole.DATA_HOT_NODE_ROLE, DiscoveryNodeRole.DATA_WARM_NODE_ROLE, DiscoveryNodeRole.DATA_COLD_NODE_ROLE);
    }

    @Override
    public AutoscalingDeciderResult scale(Settings configuration, AutoscalingDeciderContext context) {
        AutoscalingCapacity autoscalingCapacity = context.currentCapacity();
        if (autoscalingCapacity == null || autoscalingCapacity.total().storage() == null) {
            return new AutoscalingDeciderResult(null, new ReactiveReason("current capacity not available", -1L, -1L));
        }
        AllocationState allocationState = new AllocationState(context, this.diskThresholdSettings, this.allocationDeciders, this.dataTierAllocationDecider);
        long unassignedBytes = allocationState.storagePreventsAllocation();
        long assignedBytes = allocationState.storagePreventsRemainOrMove();
        long maxShardSize = allocationState.maxShardSize();
        assert (assignedBytes >= 0L);
        assert (unassignedBytes >= 0L);
        assert (maxShardSize >= 0L);
        String message = ReactiveStorageDeciderService.message(unassignedBytes, assignedBytes);
        AutoscalingCapacity requiredCapacity = AutoscalingCapacity.builder().total(autoscalingCapacity.total().storage().getBytes() + unassignedBytes + assignedBytes, null).node(maxShardSize, null).build();
        return new AutoscalingDeciderResult(requiredCapacity, new ReactiveReason(message, unassignedBytes, assignedBytes));
    }

    static String message(long unassignedBytes, long assignedBytes) {
        return unassignedBytes > 0L || assignedBytes > 0L ? "not enough storage available, needs " + new ByteSizeValue(unassignedBytes + assignedBytes) : "storage ok";
    }

    static boolean isDiskOnlyNoDecision(Decision decision) {
        return ReactiveStorageDeciderService.singleNoDecision(decision, single -> true).map("disk_threshold"::equals).orElse(false);
    }

    static boolean isFilterTierOnlyDecision(Decision decision, IndexMetadata indexMetadata) {
        return ReactiveStorageDeciderService.singleNoDecision(decision, single -> !"same_shard".equals(single.label())).filter("filter"::equals).map(d -> ReactiveStorageDeciderService.filterLooksLikeTier(indexMetadata)).orElse(false);
    }

    static boolean filterLooksLikeTier(IndexMetadata indexMetadata) {
        return ReactiveStorageDeciderService.isOnlyAttributeValueFilter(indexMetadata.requireFilters()) && ReactiveStorageDeciderService.isOnlyAttributeValueFilter(indexMetadata.includeFilters()) && ReactiveStorageDeciderService.isOnlyAttributeValueFilter(indexMetadata.excludeFilters());
    }

    private static boolean isOnlyAttributeValueFilter(DiscoveryNodeFilters filters) {
        if (filters == null) {
            return true;
        }
        return DiscoveryNodeFilters.trimTier((DiscoveryNodeFilters)filters).isOnlyAttributeValueFilter();
    }

    static Optional<String> singleNoDecision(Decision decision, Predicate<Decision> predicate) {
        List nos = decision.getDecisions().stream().filter(single -> single.type() == Decision.Type.NO).filter(predicate).collect(Collectors.toList());
        if (nos.size() == 1) {
            return Optional.ofNullable(((Decision)nos.get(0)).label());
        }
        return Optional.empty();
    }

    public static class ReactiveReason
    implements AutoscalingDeciderResult.Reason {
        private final String reason;
        private final long unassigned;
        private final long assigned;

        public ReactiveReason(String reason, long unassigned, long assigned) {
            this.reason = reason;
            this.unassigned = unassigned;
            this.assigned = assigned;
        }

        public ReactiveReason(StreamInput in) throws IOException {
            this.reason = in.readString();
            this.unassigned = in.readLong();
            this.assigned = in.readLong();
        }

        @Override
        public String summary() {
            return this.reason;
        }

        public long unassigned() {
            return this.unassigned;
        }

        public long assigned() {
            return this.assigned;
        }

        public String getWriteableName() {
            return ReactiveStorageDeciderService.NAME;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.reason);
            out.writeLong(this.unassigned);
            out.writeLong(this.assigned);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("reason", this.reason);
            builder.field("unassigned", this.unassigned);
            builder.field("assigned", this.assigned);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReactiveReason that = (ReactiveReason)o;
            return this.unassigned == that.unassigned && this.assigned == that.assigned && this.reason.equals(that.reason);
        }

        public int hashCode() {
            return Objects.hash(this.reason, this.unassigned, this.assigned);
        }
    }

    public static class AllocationState {
        private final ClusterState state;
        private final AllocationDeciders allocationDeciders;
        private final DataTierAllocationDecider dataTierAllocationDecider;
        private final DiskThresholdSettings diskThresholdSettings;
        private final ClusterInfo info;
        private final SnapshotShardSizeInfo shardSizeInfo;
        private final Predicate<DiscoveryNode> nodeTierPredicate;
        private final Set<DiscoveryNode> nodes;
        private final Set<String> nodeIds;
        private final Set<DiscoveryNodeRole> roles;

        AllocationState(AutoscalingDeciderContext context, DiskThresholdSettings diskThresholdSettings, AllocationDeciders allocationDeciders, DataTierAllocationDecider dataTierAllocationDecider) {
            this(context.state(), allocationDeciders, dataTierAllocationDecider, diskThresholdSettings, context.info(), context.snapshotShardSizeInfo(), context.nodes(), context.roles());
        }

        AllocationState(ClusterState state, AllocationDeciders allocationDeciders, DataTierAllocationDecider dataTierAllocationDecider, DiskThresholdSettings diskThresholdSettings, ClusterInfo info, SnapshotShardSizeInfo shardSizeInfo, Set<DiscoveryNode> nodes, Set<DiscoveryNodeRole> roles) {
            this.state = state;
            this.allocationDeciders = allocationDeciders;
            this.dataTierAllocationDecider = dataTierAllocationDecider;
            this.diskThresholdSettings = diskThresholdSettings;
            this.info = info;
            this.shardSizeInfo = shardSizeInfo;
            this.nodes = nodes;
            this.nodeIds = nodes.stream().map(DiscoveryNode::getId).collect(Collectors.toSet());
            this.nodeTierPredicate = nodes::contains;
            this.roles = roles;
        }

        public long storagePreventsAllocation() {
            RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, this.state.getRoutingNodes(), this.state, this.info, this.shardSizeInfo, System.nanoTime());
            return StreamSupport.stream(this.state.getRoutingNodes().unassigned().spliterator(), false).filter(shard -> !this.canAllocate((ShardRouting)shard, allocation)).filter(shard -> this.cannotAllocateDueToStorage((ShardRouting)shard, allocation)).mapToLong(this::sizeOf).sum();
        }

        public long storagePreventsRemainOrMove() {
            RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, this.state.getRoutingNodes(), this.state, this.info, this.shardSizeInfo, System.nanoTime());
            LinkedList<ShardRouting> candidates = new LinkedList<ShardRouting>();
            for (RoutingNode routingNode : this.state.getRoutingNodes()) {
                for (ShardRouting shard : routingNode) {
                    if (!shard.started() || this.canRemainOnlyHighestTierPreference(shard, allocation) || this.canAllocate(shard, allocation)) continue;
                    candidates.add(shard);
                }
            }
            Set unmovableShards = candidates.stream().filter(s -> this.allocatedToTier((ShardRouting)s, allocation)).filter(s -> this.cannotRemainDueToStorage((ShardRouting)s, allocation)).collect(Collectors.toSet());
            long unmovableBytes = unmovableShards.stream().collect(Collectors.groupingBy(ShardRouting::currentNodeId)).entrySet().stream().mapToLong(e -> this.unmovableSize((String)e.getKey(), (Collection)e.getValue())).sum();
            long unallocatableBytes = candidates.stream().filter(Predicate.not(unmovableShards::contains)).filter(s1 -> this.cannotAllocateDueToStorage((ShardRouting)s1, allocation)).mapToLong(this::sizeOf).sum();
            return unallocatableBytes + unmovableBytes;
        }

        public boolean canRemainOnlyHighestTierPreference(ShardRouting shard, RoutingAllocation allocation) {
            boolean result;
            boolean bl = result = this.allocationDeciders.canRemain(shard, allocation.routingNodes().node(shard.currentNodeId()), allocation) != Decision.NO;
            if (result && this.nodes.isEmpty() && Strings.hasText((String)((String)DataTier.TIER_PREFERENCE_SETTING.get(this.indexMetadata(shard, allocation).getSettings())))) {
                return !this.isAssignedToTier(shard, allocation);
            }
            return result;
        }

        private boolean allocatedToTier(ShardRouting s, RoutingAllocation allocation) {
            return this.nodeTierPredicate.test(allocation.routingNodes().node(s.currentNodeId()).node());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean cannotAllocateDueToStorage(ShardRouting shard, RoutingAllocation allocation) {
            if (this.nodeIds.isEmpty() && this.needsThisTier(shard, allocation)) {
                return true;
            }
            assert (!allocation.debugDecision());
            allocation.debugDecision(true);
            try {
                boolean bl = this.nodesInTier(allocation.routingNodes()).map(node -> this.allocationDeciders.canAllocate(shard, node, allocation)).anyMatch(ReactiveStorageDeciderService::isDiskOnlyNoDecision);
                return bl;
            }
            finally {
                allocation.debugDecision(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean cannotRemainDueToStorage(ShardRouting shard, RoutingAllocation allocation) {
            assert (!allocation.debugDecision());
            allocation.debugDecision(true);
            try {
                boolean bl = ReactiveStorageDeciderService.isDiskOnlyNoDecision(this.allocationDeciders.canRemain(shard, allocation.routingNodes().node(shard.currentNodeId()), allocation));
                return bl;
            }
            finally {
                allocation.debugDecision(false);
            }
        }

        private boolean canAllocate(ShardRouting shard, RoutingAllocation allocation) {
            return this.nodesInTier(allocation.routingNodes()).anyMatch(node -> this.allocationDeciders.canAllocate(shard, node, allocation) != Decision.NO);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean needsThisTier(ShardRouting shard, RoutingAllocation allocation) {
            if (!this.isAssignedToTier(shard, allocation)) {
                return false;
            }
            IndexMetadata indexMetadata = this.indexMetadata(shard, allocation);
            Set decisionTypes = StreamSupport.stream(allocation.routingNodes().spliterator(), false).map(node -> this.dataTierAllocationDecider.shouldFilter(indexMetadata, node.node().getRoles(), this::highestPreferenceTier, allocation)).map(Decision::type).collect(Collectors.toSet());
            if (decisionTypes.contains(Decision.Type.NO)) {
                return decisionTypes.size() == 1;
            }
            if (!shard.primary()) {
                return false;
            }
            assert (!allocation.debugDecision());
            allocation.debugDecision(true);
            try {
                boolean bl = StreamSupport.stream(allocation.routingNodes().spliterator(), false).anyMatch(node -> ReactiveStorageDeciderService.isFilterTierOnlyDecision(this.allocationDeciders.canAllocate(shard, node, allocation), indexMetadata));
                return bl;
            }
            finally {
                allocation.debugDecision(false);
            }
        }

        private boolean isAssignedToTier(ShardRouting shard, RoutingAllocation allocation) {
            IndexMetadata indexMetadata = this.indexMetadata(shard, allocation);
            return this.dataTierAllocationDecider.shouldFilter(indexMetadata, this.roles, this::highestPreferenceTier, allocation) != Decision.NO;
        }

        private IndexMetadata indexMetadata(ShardRouting shard, RoutingAllocation allocation) {
            return allocation.metadata().getIndexSafe(shard.index());
        }

        private Optional<String> highestPreferenceTier(List<String> preferredTiers, DiscoveryNodes nodes) {
            assert (!preferredTiers.isEmpty());
            return Optional.of(preferredTiers.get(0));
        }

        public long maxShardSize() {
            return this.nodesInTier(this.state.getRoutingNodes()).flatMap(rn -> StreamSupport.stream(rn.spliterator(), false)).mapToLong(this::sizeOf).max().orElse(0L);
        }

        long sizeOf(ShardRouting shard) {
            ShardRouting primary;
            long expectedShardSize = this.getExpectedShardSize(shard);
            if (expectedShardSize == 0L && !shard.primary() && (primary = this.state.getRoutingNodes().activePrimary(shard.shardId())) != null) {
                expectedShardSize = this.getExpectedShardSize(primary);
            }
            assert (expectedShardSize >= 0L);
            return expectedShardSize == 0L ? ByteSizeUnit.KB.toBytes(1L) : expectedShardSize;
        }

        private long getExpectedShardSize(ShardRouting shard) {
            return DiskThresholdDecider.getExpectedShardSize((ShardRouting)shard, (long)0L, (ClusterInfo)this.info, (SnapshotShardSizeInfo)this.shardSizeInfo, (Metadata)this.state.metadata(), (RoutingTable)this.state.routingTable());
        }

        long unmovableSize(String nodeId, Collection<ShardRouting> shards) {
            ClusterInfo info = this.info;
            DiskUsage diskUsage = (DiskUsage)info.getNodeMostAvailableDiskUsages().get((Object)nodeId);
            if (diskUsage == null) {
                return 0L;
            }
            long threshold = Math.max(this.diskThresholdSettings.getFreeBytesThresholdHigh().getBytes(), this.thresholdFromPercentage(this.diskThresholdSettings.getFreeDiskThresholdHigh(), diskUsage));
            long missing = threshold - diskUsage.getFreeBytes();
            return Math.max(missing, shards.stream().mapToLong(this::sizeOf).min().orElseThrow());
        }

        private long thresholdFromPercentage(Double percentage, DiskUsage diskUsage) {
            if (percentage == null) {
                return 0L;
            }
            return (long)Math.ceil((double)diskUsage.getTotalBytes() * percentage / 100.0);
        }

        Stream<RoutingNode> nodesInTier(RoutingNodes routingNodes) {
            return this.nodeIds.stream().map(n -> routingNodes.node(n));
        }

        public AllocationState forecast(long forecastWindow, long now) {
            if (forecastWindow == 0L) {
                return this;
            }
            DataStreamMetadata dataStreamMetadata = (DataStreamMetadata)this.state.metadata().custom("data_stream");
            if (dataStreamMetadata == null) {
                return this;
            }
            List<SingleForecast> singleForecasts = dataStreamMetadata.dataStreams().keySet().stream().map(this.state.metadata().getIndicesLookup()::get).map(IndexAbstraction.DataStream.class::cast).map(ds -> this.forecast(this.state.metadata(), (IndexAbstraction.DataStream)ds, forecastWindow, now)).filter(Objects::nonNull).collect(Collectors.toList());
            if (singleForecasts.isEmpty()) {
                return this;
            }
            Metadata.Builder metadataBuilder = Metadata.builder((Metadata)this.state.metadata());
            RoutingTable.Builder routingTableBuilder = RoutingTable.builder((RoutingTable)this.state.routingTable());
            ImmutableOpenMap.Builder sizeBuilder = ImmutableOpenMap.builder();
            singleForecasts.forEach(p -> p.applyMetadata(metadataBuilder));
            singleForecasts.forEach(p -> p.applyRouting(routingTableBuilder));
            RoutingTable routingTable = routingTableBuilder.build();
            singleForecasts.forEach(p -> p.applySize((ImmutableOpenMap.Builder<String, Long>)sizeBuilder, routingTable));
            ClusterState forecastClusterState = ClusterState.builder((ClusterState)this.state).metadata(metadataBuilder).routingTable(routingTable).build();
            ExtendedClusterInfo forecastInfo = new ExtendedClusterInfo((ImmutableOpenMap<String, Long>)sizeBuilder.build(), this.info);
            return new AllocationState(forecastClusterState, this.allocationDeciders, this.dataTierAllocationDecider, this.diskThresholdSettings, forecastInfo, this.shardSizeInfo, this.nodes, this.roles);
        }

        private SingleForecast forecast(Metadata metadata, IndexAbstraction.DataStream stream, long forecastWindow, long now) {
            int numberNewIndices;
            long scaledTotalSize;
            List indices = stream.getIndices();
            if (!this.dataStreamAllocatedToNodes(metadata, indices)) {
                return null;
            }
            long minCreationDate = Long.MAX_VALUE;
            long totalSize = 0L;
            int count = 0;
            while (count < indices.size()) {
                IndexMetadata indexMetadata = metadata.index((Index)indices.get(indices.size() - ++count));
                long creationDate = indexMetadata.getCreationDate();
                if (creationDate < 0L) {
                    return null;
                }
                minCreationDate = Math.min(minCreationDate, creationDate);
                totalSize += this.state.getRoutingTable().allShards(indexMetadata.getIndex().getName()).stream().mapToLong(this::sizeOf).sum();
                if (creationDate > now - forecastWindow) continue;
                break;
            }
            if (totalSize == 0L) {
                return null;
            }
            long avgSizeCeil = (totalSize - 1L) / (long)count + 1L;
            long actualWindow = now - minCreationDate;
            if (actualWindow == 0L) {
                return null;
            }
            if (actualWindow > forecastWindow) {
                scaledTotalSize = BigInteger.valueOf(totalSize).multiply(BigInteger.valueOf(forecastWindow)).divide(BigInteger.valueOf(actualWindow)).longValueExact();
                numberNewIndices = (int)Math.min((scaledTotalSize - 1L) / avgSizeCeil + 1L, (long)indices.size());
                if (scaledTotalSize == 0L) {
                    return null;
                }
            } else {
                numberNewIndices = count;
                scaledTotalSize = totalSize;
            }
            IndexMetadata writeIndex = metadata.index(stream.getWriteIndex());
            HashMap<IndexMetadata, Long> newIndices = new HashMap<IndexMetadata, Long>();
            DataStream dataStream = stream.getDataStream();
            for (int i = 0; i < numberNewIndices; ++i) {
                String uuid = UUIDs.randomBase64UUID();
                Tuple dummyRolledDatastream = dataStream.nextWriteIndexAndGeneration(this.state.metadata());
                dataStream = dataStream.rollover(new Index((String)dummyRolledDatastream.v1(), uuid), ((Long)dummyRolledDatastream.v2()).longValue());
                IndexMetadata newIndex = IndexMetadata.builder((IndexMetadata)writeIndex).index(dataStream.getWriteIndex().getName()).settings(Settings.builder().put(writeIndex.getSettings()).put("index.uuid", uuid)).build();
                long size = Math.min(avgSizeCeil, scaledTotalSize - avgSizeCeil * (long)i);
                assert (size > 0L);
                newIndices.put(newIndex, size);
            }
            return new SingleForecast(newIndices, dataStream);
        }

        private boolean dataStreamAllocatedToNodes(Metadata metadata, List<Index> indices) {
            for (int i = 0; i < indices.size(); ++i) {
                IndexMetadata indexMetadata = metadata.index(indices.get(indices.size() - i - 1));
                Set inNodes = this.state.getRoutingTable().allShards(indexMetadata.getIndex().getName()).stream().map(ShardRouting::currentNodeId).filter(Objects::nonNull).map(this.nodeIds::contains).collect(Collectors.toSet());
                if (inNodes.contains(false)) {
                    return false;
                }
                if (!inNodes.contains(true)) continue;
                return true;
            }
            return false;
        }

        ClusterState state() {
            return this.state;
        }

        ClusterInfo info() {
            return this.info;
        }

        private static class ExtendedClusterInfo
        extends ClusterInfo {
            private final ClusterInfo delegate;

            private ExtendedClusterInfo(ImmutableOpenMap<String, Long> extraShardSizes, ClusterInfo info) {
                super(info.getNodeLeastAvailableDiskUsages(), info.getNodeMostAvailableDiskUsages(), extraShardSizes, ImmutableOpenMap.of(), null, null);
                this.delegate = info;
            }

            public Long getShardSize(ShardRouting shardRouting) {
                Long shardSize = super.getShardSize(shardRouting);
                if (shardSize != null) {
                    return shardSize;
                }
                return this.delegate.getShardSize(shardRouting);
            }

            public long getShardSize(ShardRouting shardRouting, long defaultValue) {
                Long shardSize = super.getShardSize(shardRouting);
                if (shardSize != null) {
                    return shardSize;
                }
                return this.delegate.getShardSize(shardRouting, defaultValue);
            }

            public Optional<Long> getShardDataSetSize(ShardId shardId) {
                return this.delegate.getShardDataSetSize(shardId);
            }

            public String getDataPath(ShardRouting shardRouting) {
                return this.delegate.getDataPath(shardRouting);
            }

            public ClusterInfo.ReservedSpace getReservedSpace(String nodeId, String dataPath) {
                return this.delegate.getReservedSpace(nodeId, dataPath);
            }

            public void writeTo(StreamOutput out) throws IOException {
                throw new UnsupportedOperationException();
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                throw new UnsupportedOperationException();
            }
        }

        private static class SingleForecast {
            private final Map<IndexMetadata, Long> additionalIndices;
            private final DataStream updatedDataStream;

            private SingleForecast(Map<IndexMetadata, Long> additionalIndices, DataStream updatedDataStream) {
                this.additionalIndices = additionalIndices;
                this.updatedDataStream = updatedDataStream;
            }

            public void applyRouting(RoutingTable.Builder routing) {
                this.additionalIndices.keySet().forEach(arg_0 -> ((RoutingTable.Builder)routing).addAsNew(arg_0));
            }

            public void applyMetadata(Metadata.Builder metadataBuilder) {
                this.additionalIndices.keySet().forEach(imd -> metadataBuilder.put(imd, false));
                metadataBuilder.put(this.updatedDataStream);
            }

            public void applySize(ImmutableOpenMap.Builder<String, Long> builder, RoutingTable updatedRoutingTable) {
                for (Map.Entry<IndexMetadata, Long> entry : this.additionalIndices.entrySet()) {
                    List shardRoutings = updatedRoutingTable.allShards(entry.getKey().getIndex().getName());
                    long size = entry.getValue() / (long)shardRoutings.size();
                    shardRoutings.forEach(s -> builder.put((Object)ClusterInfo.shardIdentifierFromRouting((ShardRouting)s), (Object)size));
                }
            }
        }
    }
}

