/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.UpdateTrainedModelAllocationStateAction;
import org.elasticsearch.xpack.ml.inference.allocation.TrainedModelAllocationClusterService;

public class TransportUpdateTrainedModelAllocationStateAction
extends AcknowledgedTransportMasterNodeAction<UpdateTrainedModelAllocationStateAction.Request> {
    private final TrainedModelAllocationClusterService trainedModelAllocationClusterService;

    @Inject
    public TransportUpdateTrainedModelAllocationStateAction(TrainedModelAllocationClusterService trainedModelAllocationClusterService, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:internal/xpack/ml/model_allocation/update", false, transportService, clusterService, threadPool, actionFilters, UpdateTrainedModelAllocationStateAction.Request::new, indexNameExpressionResolver, "same");
        this.trainedModelAllocationClusterService = trainedModelAllocationClusterService;
    }

    protected void masterOperation(Task task, UpdateTrainedModelAllocationStateAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        this.trainedModelAllocationClusterService.updateModelRoutingTable(request, listener);
    }

    protected ClusterBlockException checkBlock(UpdateTrainedModelAllocationStateAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

