/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.UpgradeJobModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;
import org.elasticsearch.xpack.ml.job.snapshot.upgrader.SnapshotUpgradePredicate;
import org.elasticsearch.xpack.ml.job.snapshot.upgrader.SnapshotUpgradeTaskParams;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;

public class TransportUpgradeJobModelSnapshotAction
extends TransportMasterNodeAction<UpgradeJobModelSnapshotAction.Request, UpgradeJobModelSnapshotAction.Response> {
    private static final byte UPGRADE_FROM_MAJOR = Version.CURRENT.major;
    private static final Logger logger = LogManager.getLogger(TransportUpgradeJobModelSnapshotAction.class);
    private final XPackLicenseState licenseState;
    private final PersistentTasksService persistentTasksService;
    private final JobConfigProvider jobConfigProvider;
    private final JobResultsProvider jobResultsProvider;
    private final MlMemoryTracker memoryTracker;
    private final Client client;

    @Inject
    public TransportUpgradeJobModelSnapshotAction(TransportService transportService, ThreadPool threadPool, XPackLicenseState licenseState, ClusterService clusterService, PersistentTasksService persistentTasksService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, JobConfigProvider jobConfigProvider, MlMemoryTracker memoryTracker, JobResultsProvider jobResultsProvider, Client client) {
        super("cluster:admin/xpack/ml/job/model_snapshots/upgrade", transportService, clusterService, threadPool, actionFilters, UpgradeJobModelSnapshotAction.Request::new, indexNameExpressionResolver, UpgradeJobModelSnapshotAction.Response::new, "same");
        this.licenseState = licenseState;
        this.persistentTasksService = persistentTasksService;
        this.jobConfigProvider = jobConfigProvider;
        this.jobResultsProvider = jobResultsProvider;
        this.memoryTracker = memoryTracker;
        this.client = client;
    }

    protected ClusterBlockException checkBlock(UpgradeJobModelSnapshotAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void masterOperation(Task task, UpgradeJobModelSnapshotAction.Request request, ClusterState state, ActionListener<UpgradeJobModelSnapshotAction.Response> listener) {
        if (!MachineLearningField.ML_API_FEATURE.check(this.licenseState)) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
            return;
        }
        if (state.nodes().getMaxNodeVersion().after(state.nodes().getMinNodeVersion())) {
            listener.onFailure((Exception)((Object)ExceptionsHelper.conflictStatusException((String)"Cannot upgrade job [{}] snapshot [{}] as not all nodes are on version {}. All nodes must be the same version", (Object[])new Object[]{request.getJobId(), request.getSnapshotId(), state.nodes().getMaxNodeVersion().toString()})));
            return;
        }
        PersistentTasksCustomMetadata customMetadata = (PersistentTasksCustomMetadata)state.getMetadata().custom("persistent_tasks");
        if (customMetadata != null && !customMetadata.findTasks("xpack/ml/job/snapshot/upgrade", t -> t.getParams() instanceof SnapshotUpgradeTaskParams && ((SnapshotUpgradeTaskParams)t.getParams()).getJobId().equals(request.getJobId())).isEmpty()) {
            listener.onFailure((Exception)((Object)ExceptionsHelper.conflictStatusException((String)"Cannot upgrade job [{}] snapshot [{}] as there is currently a snapshot for this job being upgraded", (Object[])new Object[]{request.getJobId(), request.getSnapshotId()})));
            return;
        }
        SnapshotUpgradeTaskParams params = new SnapshotUpgradeTaskParams(request.getJobId(), request.getSnapshotId());
        ActionListener waitForJobToStart = ActionListener.wrap(persistentTask -> this.waitForJobStarted(persistentTask.getId(), params, request, listener), e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceAlreadyExistsException) {
                e = ExceptionsHelper.conflictStatusException((String)"Cannot upgrade job [{}] snapshot [{}] because upgrade is already in progress", (Throwable)e, (Object[])new Object[]{request.getJobId(), request.getSnapshotId()});
            }
            listener.onFailure((Exception)e);
        });
        ActionListener configIndexMappingUpdaterListener = ActionListener.wrap(_unused -> {
            logger.info("[{}] [{}] sending start upgrade request", (Object)params.getJobId(), (Object)params.getSnapshotId());
            this.persistentTasksService.sendStartRequest(MlTasks.snapshotUpgradeTaskId((String)params.getJobId(), (String)params.getSnapshotId()), "xpack/ml/job/snapshot/upgrade", (PersistentTaskParams)params, waitForJobToStart);
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener memoryRequirementRefreshListener = ActionListener.wrap(mem -> ElasticsearchMappings.addDocMappingIfMissing((String)MlConfigIndex.indexName(), MlConfigIndex::mapping, (Client)this.client, (ClusterState)state, (TimeValue)request.masterNodeTimeout(), (ActionListener)configIndexMappingUpdaterListener), arg_0 -> listener.onFailure(arg_0));
        ActionListener getSnapshotHandler = ActionListener.wrap(response -> {
            if (response == null) {
                listener.onFailure((Exception)((Object)new ResourceNotFoundException(Messages.getMessage((String)"No model snapshot with id [{0}] exists for job [{1}]", (Object[])new Object[]{request.getSnapshotId(), request.getJobId()}), new Object[0])));
                return;
            }
            if (Version.CURRENT.equals((Object)((ModelSnapshot)response.result).getMinVersion())) {
                listener.onFailure((Exception)((Object)ExceptionsHelper.conflictStatusException((String)"Cannot upgrade job [{}] snapshot [{}] as it is already compatible with current version {}", (Object[])new Object[]{request.getJobId(), request.getSnapshotId(), Version.CURRENT})));
                return;
            }
            this.memoryTracker.refreshAnomalyDetectorJobMemoryAndAllOthers(params.getJobId(), (ActionListener<Long>)memoryRequirementRefreshListener);
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener getJobHandler = ActionListener.wrap(job -> {
            if (request.getSnapshotId().equals(job.getModelSnapshotId()) && !JobState.CLOSED.equals((Object)MlTasks.getJobState((String)request.getJobId(), (PersistentTasksCustomMetadata)customMetadata))) {
                listener.onFailure((Exception)((Object)ExceptionsHelper.conflictStatusException((String)"Cannot upgrade snapshot [{}] for job [{}] as it is the current primary job snapshot and the job's state is [{}]", (Object[])new Object[]{request.getSnapshotId(), request.getJobId(), MlTasks.getJobState((String)request.getJobId(), (PersistentTasksCustomMetadata)customMetadata)})));
                return;
            }
            this.jobResultsProvider.getModelSnapshot(request.getJobId(), request.getSnapshotId(), arg_0 -> ((ActionListener)getSnapshotHandler).onResponse(arg_0), arg_0 -> ((ActionListener)getSnapshotHandler).onFailure(arg_0));
        }, arg_0 -> listener.onFailure(arg_0));
        this.jobConfigProvider.getJob(request.getJobId(), (ActionListener<Job.Builder>)ActionListener.wrap(builder -> getJobHandler.onResponse((Object)builder.build()), arg_0 -> listener.onFailure(arg_0)));
    }

    private void waitForJobStarted(String taskId, final SnapshotUpgradeTaskParams params, UpgradeJobModelSnapshotAction.Request request, final ActionListener<UpgradeJobModelSnapshotAction.Response> listener) {
        final SnapshotUpgradePredicate predicate = new SnapshotUpgradePredicate(request.isWaitForCompletion(), logger);
        this.persistentTasksService.waitForPersistentTaskCondition(taskId, (Predicate)predicate, request.getTimeout(), (PersistentTasksService.WaitForPersistentTaskListener)new PersistentTasksService.WaitForPersistentTaskListener<SnapshotUpgradeTaskParams>(){

            public void onResponse(PersistentTasksCustomMetadata.PersistentTask<SnapshotUpgradeTaskParams> persistentTask) {
                if (predicate.getException() != null) {
                    if (predicate.isShouldCancel()) {
                        TransportUpgradeJobModelSnapshotAction.this.cancelJobStart(persistentTask, predicate.getException(), (ActionListener<UpgradeJobModelSnapshotAction.Response>)listener);
                    } else {
                        listener.onFailure(predicate.getException());
                    }
                } else {
                    listener.onResponse((Object)new UpgradeJobModelSnapshotAction.Response(predicate.isCompleted(), predicate.getNode()));
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public void onTimeout(TimeValue timeout) {
                listener.onFailure((Exception)((Object)new ElasticsearchException("snapshot upgrader request [{}] [{}] timed out after [{}]", new Object[]{params.getJobId(), params.getSnapshotId(), timeout})));
            }
        });
    }

    private void cancelJobStart(PersistentTasksCustomMetadata.PersistentTask<SnapshotUpgradeTaskParams> persistentTask, Exception exception, ActionListener<UpgradeJobModelSnapshotAction.Response> listener) {
        this.persistentTasksService.sendRemoveRequest(persistentTask.getId(), ActionListener.wrap(t -> listener.onFailure(exception), e -> {
            logger.error((Message)new ParameterizedMessage("[{}] [{}] Failed to cancel persistent task that could not be assigned due to {}", new Object[]{((SnapshotUpgradeTaskParams)persistentTask.getParams()).getJobId(), ((SnapshotUpgradeTaskParams)persistentTask.getParams()).getSnapshotId(), exception.getMessage()}), (Throwable)e);
            listener.onFailure(exception);
        }));
    }
}

