/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.autoscaling;

import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingCapacity;
import org.elasticsearch.xpack.ml.utils.NativeMemoryCalculator;

public class NativeMemoryCapacity {
    static final NativeMemoryCapacity ZERO = new NativeMemoryCapacity(0L, 0L);
    private long tier;
    private long node;
    private Long jvmSize;

    static NativeMemoryCapacity from(NativeMemoryCapacity capacity) {
        return new NativeMemoryCapacity(capacity.tier, capacity.node, capacity.jvmSize);
    }

    public NativeMemoryCapacity(long tier, long node, Long jvmSize) {
        this.tier = tier;
        this.node = node;
        this.jvmSize = jvmSize;
    }

    NativeMemoryCapacity(long tier, long node) {
        this.tier = tier;
        this.node = node;
    }

    NativeMemoryCapacity merge(NativeMemoryCapacity nativeMemoryCapacity) {
        this.tier += nativeMemoryCapacity.tier;
        if (nativeMemoryCapacity.node > this.node) {
            this.node = nativeMemoryCapacity.node;
            this.jvmSize = null;
        }
        return this;
    }

    public AutoscalingCapacity autoscalingCapacity(int maxMemoryPercent, boolean useAuto) {
        Long jvmSize = useAuto ? Optional.ofNullable(this.jvmSize).orElse(NativeMemoryCalculator.dynamicallyCalculateJvmSizeFromNativeMemorySize(this.node)) : null;
        long actualNodeSize = NativeMemoryCalculator.calculateApproxNecessaryNodeSize(this.node, jvmSize, maxMemoryPercent, useAuto);
        double memoryPercentForMl = NativeMemoryCalculator.modelMemoryPercent(actualNodeSize, jvmSize, maxMemoryPercent, useAuto);
        double inverseScale = memoryPercentForMl <= 0.0 ? 0.0 : 100.0 / memoryPercentForMl;
        long actualTier = Math.round((double)this.tier * inverseScale);
        return new AutoscalingCapacity(new AutoscalingCapacity.AutoscalingResources(null, ByteSizeValue.ofBytes((long)Math.max(actualTier, actualNodeSize))), new AutoscalingCapacity.AutoscalingResources(null, ByteSizeValue.ofBytes((long)actualNodeSize)));
    }

    public long getTier() {
        return this.tier;
    }

    public long getNode() {
        return this.node;
    }

    public Long getJvmSize() {
        return this.jvmSize;
    }

    public String toString() {
        return "NativeMemoryCapacity{total bytes=" + ByteSizeValue.ofBytes((long)this.tier) + ", largest node bytes=" + ByteSizeValue.ofBytes((long)this.node) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NativeMemoryCapacity that = (NativeMemoryCapacity)o;
        return this.tier == that.tier && this.node == that.node && Objects.equals(this.jvmSize, that.jvmSize);
    }

    public int hashCode() {
        return Objects.hash(this.tier, this.node, this.jvmSize);
    }
}

