/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.deployment;

import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.results.InferenceResults;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.inference.allocation.TrainedModelAllocationNodeService;
import org.elasticsearch.xpack.ml.inference.deployment.ModelStats;

public class TrainedModelDeploymentTask
extends CancellableTask
implements StartTrainedModelDeploymentAction.TaskMatcher {
    private static final Logger logger = LogManager.getLogger(TrainedModelDeploymentTask.class);
    private final StartTrainedModelDeploymentAction.TaskParams params;
    private final TrainedModelAllocationNodeService trainedModelAllocationNodeService;
    private volatile boolean stopped;
    private final SetOnce<String> stoppedReason = new SetOnce();
    private final SetOnce<InferenceConfig> inferenceConfig = new SetOnce();
    private final XPackLicenseState licenseState;
    private final LicensedFeature.Persistent licensedFeature;

    public TrainedModelDeploymentTask(long id, String type, String action, TaskId parentTask, Map<String, String> headers, StartTrainedModelDeploymentAction.TaskParams taskParams, TrainedModelAllocationNodeService trainedModelAllocationNodeService, XPackLicenseState licenseState, LicensedFeature.Persistent licensedFeature) {
        super(id, type, action, MlTasks.trainedModelDeploymentTaskId((String)taskParams.getModelId()), parentTask, headers);
        this.params = taskParams;
        this.trainedModelAllocationNodeService = (TrainedModelAllocationNodeService)ExceptionsHelper.requireNonNull((Object)trainedModelAllocationNodeService, (String)"trainedModelAllocationNodeService");
        this.licenseState = licenseState;
        this.licensedFeature = licensedFeature;
    }

    void init(InferenceConfig inferenceConfig) {
        this.inferenceConfig.set((Object)inferenceConfig);
        this.licensedFeature.startTracking(this.licenseState, "model-" + this.params.getModelId());
    }

    public String getModelId() {
        return this.params.getModelId();
    }

    public long estimateMemoryUsageBytes() {
        return this.params.estimateMemoryUsageBytes();
    }

    public StartTrainedModelDeploymentAction.TaskParams getParams() {
        return this.params;
    }

    public void stop(String reason) {
        logger.debug("[{}] Stopping due to reason [{}]", (Object)this.getModelId(), (Object)reason);
        this.licensedFeature.stopTracking(this.licenseState, "model-" + this.params.getModelId());
        this.stopped = true;
        this.stoppedReason.trySet((Object)reason);
        this.trainedModelAllocationNodeService.stopDeploymentAndNotify(this, reason);
    }

    public void stopWithoutNotification(String reason) {
        this.licensedFeature.stopTracking(this.licenseState, "model-" + this.params.getModelId());
        logger.debug("[{}] Stopping due to reason [{}]", (Object)this.getModelId(), (Object)reason);
        this.stoppedReason.trySet((Object)reason);
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public Optional<String> stoppedReason() {
        return Optional.ofNullable((String)this.stoppedReason.get());
    }

    protected void onCancelled() {
        String reason = this.getReasonCancelled();
        this.stop(reason);
    }

    public void infer(Map<String, Object> doc, InferenceConfigUpdate update, TimeValue timeout, ActionListener<InferenceResults> listener) {
        if (this.inferenceConfig.get() == null) {
            listener.onFailure((Exception)((Object)ExceptionsHelper.badRequestException((String)"[{}] inference not possible against uninitialized model", (Object[])new Object[]{this.params.getModelId()})));
            return;
        }
        if (!update.isSupported((InferenceConfig)this.inferenceConfig.get())) {
            listener.onFailure((Exception)((Object)ExceptionsHelper.badRequestException((String)"[{}] inference not possible. Task is configured with [{}] but received update of type [{}]", (Object[])new Object[]{this.params.getModelId(), ((InferenceConfig)this.inferenceConfig.get()).getName(), update.getName()})));
            return;
        }
        this.trainedModelAllocationNodeService.infer(this, update.apply((InferenceConfig)this.inferenceConfig.get()), doc, timeout, listener);
    }

    public Optional<ModelStats> modelStats() {
        return this.trainedModelAllocationNodeService.modelStats(this);
    }

    public void setFailed(String reason) {
        this.trainedModelAllocationNodeService.failAllocation(this, reason);
    }
}

