/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect;

import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ml.calendars.ScheduledEvent;
import org.elasticsearch.xpack.core.ml.job.config.DetectionRule;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;
import org.elasticsearch.xpack.core.ml.job.config.ModelPlotConfig;
import org.elasticsearch.xpack.core.ml.job.config.PerPartitionCategorizationConfig;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.output.FlushAcknowledgement;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.Quantiles;
import org.elasticsearch.xpack.ml.job.persistence.StateStreamer;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcess;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.DataLoadParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.FlushJobParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.ForecastParams;
import org.elasticsearch.xpack.ml.job.results.AutodetectResult;

public class BlackHoleAutodetectProcess
implements AutodetectProcess {
    public static final String MAGIC_FAILURE_VALUE = "253402300799";
    public static final String MAGIC_FAILURE_VALUE_AS_DATE = "9999-12-31 23:59:59";
    private static final String FLUSH_ID = "flush-1";
    private final String jobId;
    private final ZonedDateTime startTime;
    private final BlockingQueue<AutodetectResult> results = new LinkedBlockingDeque<AutodetectResult>();
    private final Consumer<String> onProcessCrash;
    private volatile boolean open = true;

    public BlackHoleAutodetectProcess(String jobId, Consumer<String> onProcessCrash) {
        this.jobId = jobId;
        this.startTime = ZonedDateTime.now();
        this.onProcessCrash = Objects.requireNonNull(onProcessCrash);
    }

    @Override
    public void restoreState(StateStreamer stateStreamer, ModelSnapshot modelSnapshot) {
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public void writeRecord(String[] record) {
        if (Arrays.asList(record).contains(MAGIC_FAILURE_VALUE)) {
            this.open = false;
            this.onProcessCrash.accept("simulated failure");
            AutodetectResult result = new AutodetectResult(null, null, null, null, null, null, null, null, null, null, null, null, null);
            this.results.add(result);
        }
    }

    @Override
    public void writeResetBucketsControlMessage(DataLoadParams params) {
    }

    @Override
    public void writeUpdateModelPlotMessage(ModelPlotConfig modelPlotConfig) {
    }

    @Override
    public void writeUpdatePerPartitionCategorizationMessage(PerPartitionCategorizationConfig perPartitionCategorizationConfig) {
    }

    @Override
    public void writeUpdateDetectorRulesMessage(int detectorIndex, List<DetectionRule> rules) {
    }

    @Override
    public void writeUpdateFiltersMessage(List<MlFilter> filters) {
    }

    @Override
    public void writeUpdateScheduledEventsMessage(List<ScheduledEvent> events, TimeValue bucketSpan) {
    }

    @Override
    public String flushJob(FlushJobParams params) {
        FlushAcknowledgement flushAcknowledgement = new FlushAcknowledgement(FLUSH_ID, Long.valueOf(0L));
        AutodetectResult result = new AutodetectResult(null, null, null, null, null, null, null, null, null, null, null, null, flushAcknowledgement);
        this.results.add(result);
        return FLUSH_ID;
    }

    @Override
    public void persistState() {
    }

    @Override
    public void persistState(long snapshotTimestamp, String snapshotId, String snapshotDescription) {
    }

    @Override
    public void flushStream() {
    }

    @Override
    public void close() {
        if (this.open) {
            Quantiles quantiles = new Quantiles(this.jobId, new Date(), "black hole quantiles");
            AutodetectResult result = new AutodetectResult(null, null, null, quantiles, null, null, null, null, null, null, null, null, null);
            this.results.add(result);
            this.open = false;
        }
    }

    @Override
    public void kill(boolean awaitCompletion) {
        this.open = false;
    }

    @Override
    public Iterator<AutodetectResult> readAutodetectResults() {
        return new Iterator<AutodetectResult>(){
            AutodetectResult result;

            @Override
            public boolean hasNext() {
                try {
                    while (BlackHoleAutodetectProcess.this.open) {
                        this.result = BlackHoleAutodetectProcess.this.results.poll(100L, TimeUnit.MILLISECONDS);
                        if (this.result == null) continue;
                        return true;
                    }
                    this.result = (AutodetectResult)BlackHoleAutodetectProcess.this.results.poll();
                    return this.result != null;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }

            @Override
            public AutodetectResult next() {
                return this.result;
            }
        };
    }

    @Override
    public void consumeAndCloseOutputStream() {
    }

    @Override
    public ZonedDateTime getProcessStartTime() {
        return this.startTime;
    }

    @Override
    public boolean isProcessAlive() {
        return this.open;
    }

    @Override
    public boolean isProcessAliveAfterWaiting() {
        try {
            Thread.sleep(45L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return this.open;
    }

    @Override
    public String readError() {
        return "";
    }

    @Override
    public void forecastJob(ForecastParams params) {
    }
}

