/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation.logging;

import co.elastic.logging.log4j2.EcsLayout;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.logging.ECSJsonLayout;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.logging.RateLimitingFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.deprecation.logging.DeprecationIndexingAppender;

public class DeprecationIndexingComponent
extends AbstractLifecycleComponent {
    private static final Logger logger = LogManager.getLogger(DeprecationIndexingComponent.class);
    private final DeprecationIndexingAppender appender;
    private final BulkProcessor processor;
    private final RateLimitingFilter rateLimitingFilterForIndexing;

    public DeprecationIndexingComponent(Client client, Settings settings, RateLimitingFilter rateLimitingFilterForIndexing, boolean enableDeprecationLogIndexingDefault) {
        this.rateLimitingFilterForIndexing = rateLimitingFilterForIndexing;
        this.processor = this.getBulkProcessor((Client)new OriginSettingClient(client, "deprecation"), settings);
        Consumer<IndexRequest> consumer = arg_0 -> ((BulkProcessor)this.processor).add(arg_0);
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = context.getConfiguration();
        EcsLayout ecsLayout = ((ECSJsonLayout.Builder)ECSJsonLayout.newBuilder().setDataset("deprecation.elasticsearch").setConfiguration(configuration)).build();
        this.appender = new DeprecationIndexingAppender("deprecation_indexing_appender", (Filter)rateLimitingFilterForIndexing, (Layout<String>)ecsLayout, consumer);
        this.enableDeprecationLogIndexing(enableDeprecationLogIndexingDefault);
    }

    protected void doStart() {
        this.appender.start();
        Loggers.addAppender((Logger)LogManager.getLogger((String)"org.elasticsearch.deprecation"), (Appender)this.appender);
    }

    protected void doStop() {
        Loggers.removeAppender((Logger)LogManager.getLogger((String)"org.elasticsearch.deprecation"), (Appender)this.appender);
        this.appender.stop();
    }

    protected void doClose() {
        this.processor.close();
    }

    public void enableDeprecationLogIndexing(boolean newEnabled) {
        if (this.appender.isEnabled() != newEnabled) {
            this.appender.setEnabled(newEnabled);
            if (newEnabled) {
                this.rateLimitingFilterForIndexing.reset();
            } else {
                this.processor.flush();
            }
        }
    }

    private BulkProcessor getBulkProcessor(Client client, Settings settings) {
        DeprecationBulkListener listener = new DeprecationBulkListener();
        return BulkProcessor.builder((arg_0, arg_1) -> ((Client)client).bulk(arg_0, arg_1), (BulkProcessor.Listener)listener, (String)"deprecation-indexing").setBackoffPolicy(BackoffPolicy.exponentialBackoff((TimeValue)TimeValue.timeValueMillis((long)1000L), (int)3)).setConcurrentRequests(Math.max(2, EsExecutors.allocatedProcessors((Settings)settings))).setBulkActions(-1).setBulkSize(new ByteSizeValue(-1L, ByteSizeUnit.BYTES)).setFlushInterval(TimeValue.timeValueSeconds((long)5L)).build();
    }

    private static class DeprecationBulkListener
    implements BulkProcessor.Listener {
        private DeprecationBulkListener() {
        }

        public void beforeBulk(long executionId, BulkRequest request) {
        }

        public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
            long numberOfActions = request.numberOfActions();
            if (logger.isTraceEnabled()) {
                logger.trace("indexed [{}] deprecation documents into [{}]", (Object)numberOfActions, (Object)Arrays.stream(response.getItems()).map(BulkItemResponse::getIndex).distinct().collect(Collectors.joining(",")));
            }
            if (response.hasFailures()) {
                List failures = Arrays.stream(response.getItems()).filter(BulkItemResponse::isFailed).map(r -> r.getId() + " " + r.getFailureMessage()).collect(Collectors.toList());
                logger.error("Bulk write of deprecation logs encountered some failures: [{}]", failures);
            }
        }

        public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
            logger.error("Bulk write of " + request.numberOfActions() + " deprecation logs failed: " + failure.getMessage(), failure);
        }
    }
}

