/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.AbstractFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;

public class RegularFileSnapshot
extends AbstractFileSystemLocationSnapshot {
    private final HashCode contentHash;
    private final long lastModified;

    public RegularFileSnapshot(String absolutePath, String name, HashCode contentHash, long lastModified) {
        super(absolutePath, name);
        this.contentHash = contentHash;
        this.lastModified = lastModified;
    }

    @Override
    public FileType getType() {
        return FileType.RegularFile;
    }

    @Override
    public HashCode getHash() {
        return this.contentHash;
    }

    @Override
    public boolean isContentAndMetadataUpToDate(FileSystemLocationSnapshot other) {
        if (!(other instanceof RegularFileSnapshot)) {
            return false;
        }
        RegularFileSnapshot otherSnapshot = (RegularFileSnapshot)other;
        return this.lastModified == otherSnapshot.lastModified && this.contentHash.equals((Object)otherSnapshot.contentHash);
    }

    @Override
    public void accept(FileSystemSnapshotVisitor visitor) {
        visitor.visit(this);
    }
}

