/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import redis.clients.util.MurmurHash;
import redis.clients.util.SafeEncoder;

public interface Hashing {
    public static final Hashing MURMUR_HASH = new MurmurHash();
    public static final Hashing MD5 = new Hashing(){
        private MessageDigest md5 = null;

        public long hash(String key) {
            return this.hash(SafeEncoder.encode(key));
        }

        public long hash(byte[] key) {
            if (this.md5 == null) {
                try {
                    this.md5 = MessageDigest.getInstance("MD5");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("++++ no md5 algorythm found");
                }
            }
            this.md5.reset();
            this.md5.update(key);
            byte[] bKey = this.md5.digest();
            long res = (long)(bKey[3] & 0xFF) << 24 | (long)(bKey[2] & 0xFF) << 16 | (long)(bKey[1] & 0xFF) << 8 | (long)(bKey[0] & 0xFF);
            return res;
        }
    };

    public long hash(String var1);

    public long hash(byte[] var1);
}

