/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import redis.clients.util.Hashing;
import redis.clients.util.SafeEncoder;
import redis.clients.util.ShardInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sharded<R, S extends ShardInfo<R>> {
    public static final int DEFAULT_WEIGHT = 1;
    private TreeMap<Long, S> nodes;
    private final Hashing algo;
    private final Map<ShardInfo<R>, R> resources = new HashMap<ShardInfo<R>, R>();
    private Pattern tagPattern = null;
    public static final Pattern DEFAULT_KEY_TAG_PATTERN = Pattern.compile("\\{(.+?)\\}");

    public Sharded(List<S> shards) {
        this(shards, Hashing.MURMUR_HASH);
    }

    public Sharded(List<S> shards, Hashing algo) {
        this.algo = algo;
        this.initialize(shards);
    }

    public Sharded(List<S> shards, Pattern tagPattern) {
        this(shards, Hashing.MURMUR_HASH, tagPattern);
    }

    public Sharded(List<S> shards, Hashing algo, Pattern tagPattern) {
        this.algo = algo;
        this.tagPattern = tagPattern;
        this.initialize(shards);
    }

    private void initialize(List<S> shards) {
        this.nodes = new TreeMap();
        for (int i = 0; i != shards.size(); ++i) {
            ShardInfo shardInfo = (ShardInfo)shards.get(i);
            for (int n = 0; n < 160 * shardInfo.getWeight(); ++n) {
                this.nodes.put(this.algo.hash(shardInfo.toString() + n), shardInfo);
            }
            this.resources.put(shardInfo, shardInfo.createResource());
        }
    }

    public R getShard(byte[] key) {
        return this.resources.get(this.getShardInfo(key));
    }

    public R getShard(String key) {
        return this.resources.get(this.getShardInfo(key));
    }

    private S getShardInfo(byte[] key) {
        SortedMap<Long, S> tail = this.nodes.tailMap(this.algo.hash(key));
        if (tail.size() == 0) {
            return (S)((ShardInfo)this.nodes.get(this.nodes.firstKey()));
        }
        return (S)((ShardInfo)tail.get(tail.firstKey()));
    }

    public S getShardInfo(String key) {
        return this.getShardInfo(SafeEncoder.encode(this.getKeyTag(key)));
    }

    public String getKeyTag(String key) {
        Matcher m;
        if (this.tagPattern != null && (m = this.tagPattern.matcher(key)).find()) {
            return m.group(1);
        }
        return key;
    }

    public Collection<S> getAllShardInfo() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    public Collection<R> getAllShards() {
        return Collections.unmodifiableCollection(this.resources.values());
    }
}

