/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import com.google.common.collect.Lists;
import hudson.ExtensionComponent;
import hudson.ExtensionFinder;
import hudson.FilePath;
import hudson.Plugin;
import hudson.PluginFirstClassLoader;
import hudson.PluginManager;
import hudson.PluginStrategy;
import hudson.PluginWrapper;
import hudson.Util;
import hudson.model.Hudson;
import hudson.util.CyclicGraphDetector;
import hudson.util.IOUtils;
import hudson.util.MaskingClassLoader;
import hudson.util.VersionNumber;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.ClassLoaderReflectionToolkit;
import jenkins.ExtensionFilter;
import jenkins.util.AntClassLoader;
import jenkins.util.SystemProperties;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.types.resources.MappedResourceCollection;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipExtraField;
import org.apache.tools.zip.ZipOutputStream;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class ClassicPluginStrategy
implements PluginStrategy {
    private static final FilenameFilter JAR_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    };
    private PluginManager pluginManager;
    private final MaskingClassLoader coreClassLoader = new MaskingClassLoader(this.getClass().getClassLoader(), new String[0]);
    private static final List<DetachedPlugin> DETACHED_LIST = Collections.unmodifiableList(Arrays.asList(new DetachedPlugin("maven-plugin", "1.296", "1.296"), new DetachedPlugin("subversion", "1.310", "1.0"), new DetachedPlugin("cvs", "1.340", "0.1"), new DetachedPlugin("ant", "1.430.*", "1.0"), new DetachedPlugin("javadoc", "1.430.*", "1.0"), new DetachedPlugin("external-monitor-job", "1.467.*", "1.0"), new DetachedPlugin("ldap", "1.467.*", "1.0"), new DetachedPlugin("pam-auth", "1.467.*", "1.0"), new DetachedPlugin("mailer", "1.493.*", "1.2"), new DetachedPlugin("matrix-auth", "1.535.*", "1.0.2"), new DetachedPlugin("windows-slaves", "1.547.*", "1.0"), new DetachedPlugin("antisamy-markup-formatter", "1.553.*", "1.0"), new DetachedPlugin("matrix-project", "1.561.*", "1.0"), new DetachedPlugin("junit", "1.577.*", "1.0")));
    private static final Set<String> BREAK_CYCLES = new HashSet<String>(Arrays.asList("script-security/matrix-auth", "script-security/windows-slaves", "script-security/antisamy-markup-formatter", "script-security/matrix-project", "credentials/matrix-auth", "credentials/windows-slaves"));
    public static boolean useAntClassLoader = SystemProperties.getBoolean(ClassicPluginStrategy.class.getName() + ".useAntClassLoader");
    private static final Logger LOGGER = Logger.getLogger(ClassicPluginStrategy.class.getName());
    public static boolean DISABLE_TRANSFORMER = SystemProperties.getBoolean(ClassicPluginStrategy.class.getName() + ".noBytecodeTransformer");

    public ClassicPluginStrategy(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getShortName(File archive) throws IOException {
        Manifest manifest;
        if (ClassicPluginStrategy.isLinked(archive)) {
            manifest = ClassicPluginStrategy.loadLinkedManifest(archive);
        } else {
            try (JarFile jf = new JarFile(archive, false);){
                manifest = jf.getManifest();
            }
        }
        return PluginWrapper.computeShortName(manifest, archive.getName());
    }

    private static boolean isLinked(File archive) {
        return archive.getName().endsWith(".hpl") || archive.getName().endsWith(".jpl");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Manifest loadLinkedManifest(File archive) throws IOException {
        Manifest manifest;
        String firstLine;
        try (FileInputStream manifestHeaderInput = new FileInputStream(archive);){
            firstLine = IOUtils.readFirstLine(manifestHeaderInput, "UTF-8");
        }
        if (!firstLine.startsWith("Manifest-Version:")) {
            archive = ClassicPluginStrategy.resolve(archive, firstLine);
        }
        FileInputStream manifestInput = new FileInputStream(archive);
        try {
            manifest = new Manifest(manifestInput);
        }
        catch (Throwable throwable) {
            try {
                manifestInput.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new IOException("Failed to load " + archive, e);
            }
        }
        manifestInput.close();
        return manifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PluginWrapper createPluginWrapper(File archive) throws IOException {
        Manifest manifest;
        URL baseResourceURL = null;
        File expandDir = null;
        boolean isLinked = ClassicPluginStrategy.isLinked(archive);
        if (isLinked) {
            manifest = ClassicPluginStrategy.loadLinkedManifest(archive);
        } else {
            if (archive.isDirectory()) {
                expandDir = archive;
            } else {
                File f = this.pluginManager.getWorkDir();
                expandDir = new File(f == null ? archive.getParentFile() : f, FilenameUtils.getBaseName((String)archive.getName()));
                ClassicPluginStrategy.explode(archive, expandDir);
            }
            File manifestFile = new File(expandDir, "META-INF/MANIFEST.MF");
            if (!manifestFile.exists()) {
                throw new IOException("Plugin installation failed. No manifest at " + manifestFile);
            }
            try (FileInputStream fin = new FileInputStream(manifestFile);){
                manifest = new Manifest(fin);
            }
        }
        Attributes atts = manifest.getMainAttributes();
        ArrayList<File> paths = new ArrayList<File>();
        if (isLinked) {
            ClassicPluginStrategy.parseClassPath(manifest, archive, paths, "Libraries", ",");
            ClassicPluginStrategy.parseClassPath(manifest, archive, paths, "Class-Path", " +");
            baseResourceURL = ClassicPluginStrategy.resolve(archive, atts.getValue("Resource-Path")).toURI().toURL();
        } else {
            File lib;
            File[] libs;
            File classes = new File(expandDir, "WEB-INF/classes");
            if (classes.exists()) {
                paths.add(classes);
            }
            if ((libs = (lib = new File(expandDir, "WEB-INF/lib")).listFiles(JAR_FILTER)) != null) {
                paths.addAll(Arrays.asList(libs));
            }
            baseResourceURL = expandDir.toPath().toUri().toURL();
        }
        File disableFile = new File(archive.getPath() + ".disabled");
        if (disableFile.exists()) {
            LOGGER.info("Plugin " + archive.getName() + " is disabled");
        }
        ArrayList<PluginWrapper.Dependency> dependencies = new ArrayList<PluginWrapper.Dependency>();
        ArrayList<PluginWrapper.Dependency> optionalDependencies = new ArrayList<PluginWrapper.Dependency>();
        String v = atts.getValue("Plugin-Dependencies");
        if (v != null) {
            for (String s : v.split(",")) {
                PluginWrapper.Dependency d = new PluginWrapper.Dependency(s);
                if (d.optional) {
                    optionalDependencies.add(d);
                    continue;
                }
                dependencies.add(d);
            }
        }
        ClassicPluginStrategy.fix(atts, optionalDependencies);
        String masked = atts.getValue("Global-Mask-Classes");
        if (masked != null) {
            for (String pkg : masked.trim().split("[ \t\r\n]+")) {
                this.coreClassLoader.add(pkg);
            }
        }
        ClassLoader dependencyLoader = new DependencyClassLoader(this.coreClassLoader, archive, Util.join(dependencies, optionalDependencies));
        dependencyLoader = this.getBaseClassLoader(atts, dependencyLoader);
        return new PluginWrapper(this.pluginManager, archive, manifest, baseResourceURL, this.createClassLoader(paths, dependencyLoader, atts), disableFile, dependencies, optionalDependencies);
    }

    private static void fix(Attributes atts, List<PluginWrapper.Dependency> optionalDependencies) {
        String pluginName = atts.getValue("Short-Name");
        String jenkinsVersion = atts.getValue("Jenkins-Version");
        if (jenkinsVersion == null) {
            jenkinsVersion = atts.getValue("Hudson-Version");
        }
        optionalDependencies.addAll(ClassicPluginStrategy.getImpliedDependencies(pluginName, jenkinsVersion));
    }

    @Nonnull
    public static List<PluginWrapper.Dependency> getImpliedDependencies(String pluginName, String jenkinsVersion) {
        ArrayList<PluginWrapper.Dependency> out = new ArrayList<PluginWrapper.Dependency>();
        for (DetachedPlugin detached : DETACHED_LIST) {
            if (detached.shortName.equals(pluginName)) continue;
            if (BREAK_CYCLES.contains(pluginName + '/' + detached.shortName)) {
                LOGGER.log(Level.FINE, "skipping implicit dependency {0} \u2192 {1}", new Object[]{pluginName, detached.shortName});
                continue;
            }
            if (jenkinsVersion != null && !jenkinsVersion.equals("null") && new VersionNumber(jenkinsVersion).compareTo(detached.splitWhen) > 0) continue;
            out.add(new PluginWrapper.Dependency(detached.shortName + ':' + detached.requiredVersion));
            LOGGER.log(Level.FINE, "adding implicit dependency {0} \u2192 {1} because of {2}", new Object[]{pluginName, detached.shortName, jenkinsVersion});
        }
        return out;
    }

    @Deprecated
    protected ClassLoader createClassLoader(List<File> paths, ClassLoader parent) throws IOException {
        return this.createClassLoader(paths, parent, null);
    }

    protected ClassLoader createClassLoader(List<File> paths, ClassLoader parent, Attributes atts) throws IOException {
        String usePluginFirstClassLoader;
        if (atts != null && Boolean.valueOf(usePluginFirstClassLoader = atts.getValue("PluginFirstClassLoader")).booleanValue()) {
            PluginFirstClassLoader classLoader = new PluginFirstClassLoader();
            classLoader.setParentFirst(false);
            classLoader.setParent(parent);
            classLoader.addPathFiles(paths);
            return classLoader;
        }
        AntClassLoader2 classLoader = new AntClassLoader2(parent);
        classLoader.addPathFiles(paths);
        return classLoader;
    }

    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public static List<DetachedPlugin> getDetachedPlugins() {
        return DETACHED_LIST;
    }

    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public static List<DetachedPlugin> getDetachedPlugins(@Nonnull VersionNumber since) {
        ArrayList<DetachedPlugin> detachedPlugins = new ArrayList<DetachedPlugin>();
        for (DetachedPlugin detachedPlugin : DETACHED_LIST) {
            if (detachedPlugin.getSplitWhen().isOlderThan(since)) continue;
            detachedPlugins.add(detachedPlugin);
        }
        return detachedPlugins;
    }

    @Restricted(value={NoExternalUse.class})
    public static boolean isDetachedPlugin(@Nonnull String pluginId) {
        for (DetachedPlugin detachedPlugin : DETACHED_LIST) {
            if (!detachedPlugin.getShortName().equals(pluginId)) continue;
            return true;
        }
        return false;
    }

    private ClassLoader getBaseClassLoader(Attributes atts, ClassLoader base) {
        String masked = atts.getValue("Mask-Classes");
        if (masked != null) {
            base = new MaskingClassLoader(base, masked.trim().split("[ \t\r\n]+"));
        }
        return base;
    }

    @Override
    public void initializeComponents(PluginWrapper plugin) {
    }

    @Override
    public <T> List<ExtensionComponent<T>> findComponents(Class<T> type, Hudson hudson) {
        List<ExtensionFinder> finders = type == ExtensionFinder.class ? Collections.singletonList(new ExtensionFinder.Sezpoz()) : hudson.getExtensionList(ExtensionFinder.class);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "Scout-loading ExtensionList: " + type, new Throwable());
        }
        for (ExtensionFinder finder : finders) {
            finder.scout(type, hudson);
        }
        ArrayList r = Lists.newArrayList();
        for (ExtensionFinder finder : finders) {
            try {
                r.addAll(finder.find(type, hudson));
            }
            catch (AbstractMethodError e) {
                for (T t : finder.findExtensions(type, hudson)) {
                    r.add(new ExtensionComponent<T>(t));
                }
            }
        }
        ArrayList filtered = Lists.newArrayList();
        for (ExtensionComponent e : r) {
            if (!ExtensionFilter.isAllowed(type, e)) continue;
            filtered.add(e);
        }
        return filtered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(PluginWrapper wrapper) throws IOException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(wrapper.classLoader);
        try {
            String className = wrapper.getPluginClass();
            if (className == null) {
                wrapper.setPlugin(new Plugin.DummyImpl());
            } else {
                try {
                    Class<?> clazz = wrapper.classLoader.loadClass(className);
                    Object o = clazz.newInstance();
                    if (!(o instanceof Plugin)) {
                        throw new IOException(className + " doesn't extend from hudson.Plugin");
                    }
                    wrapper.setPlugin((Plugin)o);
                }
                catch (ClassNotFoundException | LinkageError e) {
                    throw new IOException("Unable to load " + className + " from " + wrapper.getShortName(), e);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IOException("Unable to create instance of " + className + " from " + wrapper.getShortName(), e);
                }
            }
            try {
                Plugin plugin = wrapper.getPlugin();
                plugin.setServletContext(this.pluginManager.context);
                this.startPlugin(wrapper);
            }
            catch (Throwable t) {
                throw new IOException("Failed to initialize", t);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void startPlugin(PluginWrapper plugin) throws Exception {
        plugin.getPlugin().start();
    }

    @Override
    public void updateDependency(PluginWrapper depender, PluginWrapper dependee) {
        DependencyClassLoader classLoader = this.findAncestorDependencyClassLoader(depender.classLoader);
        if (classLoader != null) {
            classLoader.updateTransientDependencies();
            LOGGER.log(Level.INFO, "Updated dependency of {0}", depender.getShortName());
        }
    }

    private DependencyClassLoader findAncestorDependencyClassLoader(ClassLoader classLoader) {
        while (classLoader != null) {
            DependencyClassLoader ret;
            if (classLoader instanceof DependencyClassLoader) {
                return (DependencyClassLoader)classLoader;
            }
            if (classLoader instanceof AntClassLoader && (ret = this.findAncestorDependencyClassLoader(((AntClassLoader)classLoader).getConfiguredParent())) != null) {
                return ret;
            }
            classLoader = classLoader.getParent();
        }
        return null;
    }

    private static File resolve(File base, String relative) {
        File rel = new File(relative);
        if (rel.isAbsolute()) {
            return rel;
        }
        return new File(base.getParentFile(), relative);
    }

    private static void parseClassPath(Manifest manifest, File archive, List<File> paths, String attributeName, String separator) throws IOException {
        String classPath = manifest.getMainAttributes().getValue(attributeName);
        if (classPath == null) {
            return;
        }
        for (String s : classPath.split(separator)) {
            File file = ClassicPluginStrategy.resolve(archive, s);
            if (file.getName().contains("*")) {
                FileSet fs = new FileSet();
                File dir = file.getParentFile();
                fs.setDir(dir);
                fs.setIncludes(file.getName());
                for (String included : fs.getDirectoryScanner(new Project()).getIncludedFiles()) {
                    paths.add(new File(dir, included));
                }
                continue;
            }
            if (!file.exists()) {
                throw new IOException("No such file: " + file);
            }
            paths.add(file);
        }
    }

    private static void explode(File archive, File destDir) throws IOException {
        destDir.mkdirs();
        File explodeTime = new File(destDir, ".timestamp2");
        if (explodeTime.exists() && explodeTime.lastModified() == archive.lastModified()) {
            return;
        }
        Util.deleteRecursive(destDir);
        try {
            Project prj = new Project();
            ClassicPluginStrategy.unzipExceptClasses(archive, destDir, prj);
            ClassicPluginStrategy.createClassJarFromWebInfClasses(archive, destDir, prj);
        }
        catch (BuildException x) {
            throw new IOException("Failed to expand " + archive, x);
        }
        try {
            new FilePath(explodeTime).touch(archive.lastModified());
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createClassJarFromWebInfClasses(File archive, File destDir, Project prj) throws IOException {
        File classesJar = new File(destDir, "WEB-INF/lib/classes.jar");
        ZipFileSet zfs = new ZipFileSet();
        zfs.setProject(prj);
        zfs.setSrc(archive);
        zfs.setIncludes("WEB-INF/classes/");
        MappedResourceCollection mapper = new MappedResourceCollection();
        mapper.add((ResourceCollection)zfs);
        GlobPatternMapper gm = new GlobPatternMapper();
        gm.setFrom("WEB-INF/classes/*");
        gm.setTo("*");
        mapper.add((FileNameMapper)gm);
        final long dirTime = archive.lastModified();
        try (final ZipOutputStream wrappedZOut = new ZipOutputStream((OutputStream)new NullOutputStream()){

            public void putNextEntry(ZipEntry ze) throws IOException {
                ze.setTime(dirTime + 1999L);
                super.putNextEntry(ze);
            }
        };){
            Zip z = new Zip(){

                protected void zipDir(Resource dir, ZipOutputStream zOut, String vPath, int mode, ZipExtraField[] extra) throws IOException {
                    super.zipDir(dir, wrappedZOut, vPath, mode, extra);
                }
            };
            z.setProject(prj);
            z.setTaskType("zip");
            classesJar.getParentFile().mkdirs();
            z.setDestFile(classesJar);
            z.add((ResourceCollection)mapper);
            z.execute();
        }
    }

    private static void unzipExceptClasses(File archive, File destDir, Project prj) {
        Expand e = new Expand();
        e.setProject(prj);
        e.setTaskType("unzip");
        e.setSrc(archive);
        e.setDest(destDir);
        PatternSet p = new PatternSet();
        p.setExcludes("WEB-INF/classes/");
        e.addPatternset(p);
        e.execute();
    }

    private final class AntClassLoader2
    extends AntClassLoader
    implements Closeable {
        private final Vector pathComponents;

        private AntClassLoader2(ClassLoader parent) {
            super(parent, true);
            try {
                Field $pathComponents = AntClassLoader.class.getDeclaredField("pathComponents");
                $pathComponents.setAccessible(true);
                this.pathComponents = (Vector)$pathComponents.get(this);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new Error(e);
            }
        }

        public void addPathFiles(Collection<File> paths) throws IOException {
            for (File f : paths) {
                this.addPathFile(f);
            }
        }

        @Override
        public void close() throws IOException {
            this.cleanup();
        }

        @Override
        protected URL findResource(String name) {
            URL url = null;
            Enumeration e = this.pathComponents.elements();
            while (e.hasMoreElements() && url == null) {
                File pathComponent = (File)e.nextElement();
                url = this.getResourceURL(pathComponent, name);
                if (url == null) continue;
                this.log("Resource " + name + " loaded from ant loader", 4);
            }
            return url;
        }

        @Override
        protected Class defineClassFromData(File container, byte[] classData, String classname) throws IOException {
            if (!DISABLE_TRANSFORMER) {
                classData = ClassicPluginStrategy.this.pluginManager.getCompatibilityTransformer().transform(classname, classData, (ClassLoader)this);
            }
            return super.defineClassFromData(container, classData, classname);
        }
    }

    final class DependencyClassLoader
    extends ClassLoader {
        private final File _for;
        private List<PluginWrapper.Dependency> dependencies;
        private volatile List<PluginWrapper> transientDependencies;

        public DependencyClassLoader(ClassLoader parent, File archive, List<PluginWrapper.Dependency> dependencies) {
            super(parent);
            this._for = archive;
            this.dependencies = dependencies;
        }

        private void updateTransientDependencies() {
            this.transientDependencies = null;
        }

        private List<PluginWrapper> getTransitiveDependencies() {
            if (this.transientDependencies == null) {
                CyclicGraphDetector<PluginWrapper> cgd = new CyclicGraphDetector<PluginWrapper>(){

                    @Override
                    protected List<PluginWrapper> getEdges(PluginWrapper pw) {
                        ArrayList<PluginWrapper> dep = new ArrayList<PluginWrapper>();
                        for (PluginWrapper.Dependency d : pw.getDependencies()) {
                            PluginWrapper p = ClassicPluginStrategy.this.pluginManager.getPlugin(d.shortName);
                            if (p == null || !p.isActive()) continue;
                            dep.add(p);
                        }
                        return dep;
                    }
                };
                try {
                    for (PluginWrapper.Dependency d : this.dependencies) {
                        PluginWrapper p = ClassicPluginStrategy.this.pluginManager.getPlugin(d.shortName);
                        if (p == null || !p.isActive()) continue;
                        cgd.run(Collections.singleton(p));
                    }
                }
                catch (CyclicGraphDetector.CycleDetectedException e) {
                    throw new AssertionError((Object)e);
                }
                this.transientDependencies = cgd.getSorted();
            }
            return this.transientDependencies;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (PluginManager.FAST_LOOKUP) {
                for (PluginWrapper pw : this.getTransitiveDependencies()) {
                    try {
                        Class<?> c = ClassLoaderReflectionToolkit._findLoadedClass(pw.classLoader, name);
                        if (c != null) {
                            return c;
                        }
                        return ClassLoaderReflectionToolkit._findClass(pw.classLoader, name);
                    }
                    catch (ClassNotFoundException e) {
                    }
                }
            } else {
                for (PluginWrapper.Dependency dep : this.dependencies) {
                    PluginWrapper p = ClassicPluginStrategy.this.pluginManager.getPlugin(dep.shortName);
                    if (p == null) continue;
                    try {
                        return p.classLoader.loadClass(name);
                    }
                    catch (ClassNotFoundException _) {
                    }
                }
            }
            throw new ClassNotFoundException(name);
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            HashSet<URL> result = new HashSet<URL>();
            if (PluginManager.FAST_LOOKUP) {
                for (PluginWrapper pw : this.getTransitiveDependencies()) {
                    Enumeration<URL> urls = ClassLoaderReflectionToolkit._findResources(pw.classLoader, name);
                    while (urls != null && urls.hasMoreElements()) {
                        result.add(urls.nextElement());
                    }
                }
            } else {
                for (PluginWrapper.Dependency dep : this.dependencies) {
                    PluginWrapper p = ClassicPluginStrategy.this.pluginManager.getPlugin(dep.shortName);
                    if (p == null) continue;
                    Enumeration<URL> urls = p.classLoader.getResources(name);
                    while (urls != null && urls.hasMoreElements()) {
                        result.add(urls.nextElement());
                    }
                }
            }
            return Collections.enumeration(result);
        }

        @Override
        protected URL findResource(String name) {
            if (PluginManager.FAST_LOOKUP) {
                for (PluginWrapper pw : this.getTransitiveDependencies()) {
                    URL url = ClassLoaderReflectionToolkit._findResource(pw.classLoader, name);
                    if (url == null) continue;
                    return url;
                }
            } else {
                for (PluginWrapper.Dependency dep : this.dependencies) {
                    URL url;
                    PluginWrapper p = ClassicPluginStrategy.this.pluginManager.getPlugin(dep.shortName);
                    if (p == null || (url = p.classLoader.getResource(name)) == null) continue;
                    return url;
                }
            }
            return null;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class DetachedPlugin {
        private final String shortName;
        private final VersionNumber splitWhen;
        private final String requiredVersion;

        private DetachedPlugin(String shortName, String splitWhen, String requiredVersion) {
            this.shortName = shortName;
            this.splitWhen = new VersionNumber(splitWhen);
            this.requiredVersion = requiredVersion;
        }

        public String getShortName() {
            return this.shortName;
        }

        public VersionNumber getSplitWhen() {
            return this.splitWhen;
        }

        public VersionNumber getRequiredVersion() {
            return new VersionNumber(this.requiredVersion);
        }
    }
}

