/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import hudson.Extension;
import hudson.ExtensionComponent;
import hudson.ExtensionPoint;
import hudson.PluginManager;
import hudson.model.Hudson;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.ExtensionComponentSet;
import jenkins.ExtensionRefreshException;
import jenkins.ProxyInjector;
import jenkins.model.Jenkins;
import net.java.sezpoz.Index;
import net.java.sezpoz.IndexItem;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class ExtensionFinder
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(ExtensionFinder.class.getName());

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public <T> Collection<T> findExtensions(Class<T> type, Hudson hudson) {
        return Collections.emptyList();
    }

    public boolean isRefreshable() {
        try {
            return this.getClass().getMethod("refresh", new Class[0]).getDeclaringClass() != ExtensionFinder.class;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public abstract ExtensionComponentSet refresh() throws ExtensionRefreshException;

    public abstract <T> Collection<ExtensionComponent<T>> find(Class<T> var1, Hudson var2);

    @Deprecated
    public <T> Collection<ExtensionComponent<T>> _find(Class<T> type, Hudson hudson) {
        return this.find(type, hudson);
    }

    public void scout(Class extensionType, Hudson hudson) {
    }

    public static final class Sezpoz
    extends ExtensionFinder {
        private volatile List<IndexItem<Extension, Object>> indices;

        private List<IndexItem<Extension, Object>> getIndices() {
            if (this.indices == null) {
                ClassLoader cl = Jenkins.getInstance().getPluginManager().uberClassLoader;
                this.indices = ImmutableList.copyOf((Iterable)Index.load(Extension.class, Object.class, (ClassLoader)cl));
            }
            return this.indices;
        }

        @Override
        public synchronized ExtensionComponentSet refresh() {
            List<IndexItem<Extension, Object>> old = this.indices;
            if (old == null) {
                return ExtensionComponentSet.EMPTY;
            }
            final List<IndexItem<Extension, Object>> delta = Sezpoz.listDelta(Extension.class, old);
            ArrayList r = Lists.newArrayList(old);
            r.addAll(delta);
            this.indices = ImmutableList.copyOf((Collection)r);
            return new ExtensionComponentSet(){

                @Override
                public <T> Collection<ExtensionComponent<T>> find(Class<T> type) {
                    return Sezpoz.this._find(type, delta);
                }
            };
        }

        static <T extends Annotation> List<IndexItem<T, Object>> listDelta(Class<T> annotationType, List<? extends IndexItem<?, Object>> old) {
            ArrayList delta = Lists.newArrayList();
            ClassLoader cl = Jenkins.getInstance().getPluginManager().uberClassLoader;
            for (IndexItem ii : Index.load(annotationType, Object.class, (ClassLoader)cl)) {
                if (old.contains(ii)) continue;
                delta.add(ii);
            }
            return delta;
        }

        @Override
        public <T> Collection<ExtensionComponent<T>> find(Class<T> type, Hudson jenkins) {
            return this._find(type, this.getIndices());
        }

        private <T> Collection<ExtensionComponent<T>> _find(Class<T> type, List<IndexItem<Extension, Object>> indices) {
            ArrayList<ExtensionComponent<T>> result = new ArrayList<ExtensionComponent<T>>();
            for (IndexItem<Extension, Object> item : indices) {
                try {
                    Object instance;
                    Class<?> extType;
                    AnnotatedElement e = item.element();
                    if (e instanceof Class) {
                        extType = (Class<?>)e;
                    } else if (e instanceof Field) {
                        extType = ((Field)e).getType();
                    } else if (e instanceof Method) {
                        extType = ((Method)e).getReturnType();
                    } else {
                        throw new AssertionError();
                    }
                    if (!type.isAssignableFrom(extType) || (instance = item.instance()) == null) continue;
                    result.add(new ExtensionComponent<T>(type.cast(instance), (Extension)item.annotation()));
                }
                catch (Exception | LinkageError e) {
                    LOGGER.log(this.logLevel(item), "Failed to load " + item.className(), e);
                }
            }
            return result;
        }

        @Override
        public void scout(Class extensionType, Hudson hudson) {
            for (IndexItem<Extension, Object> item : this.getIndices()) {
                try {
                    Class<?> extType;
                    AnnotatedElement e = item.element();
                    if (e instanceof Class) {
                        extType = (Class<?>)e;
                    } else if (e instanceof Field) {
                        extType = ((Field)e).getType();
                    } else if (e instanceof Method) {
                        extType = ((Method)e).getReturnType();
                    } else {
                        throw new AssertionError();
                    }
                    Class.forName(extType.getName(), true, extType.getClassLoader());
                }
                catch (Exception | LinkageError e) {
                    LOGGER.log(this.logLevel(item), "Failed to scout " + item.className(), e);
                }
            }
        }

        private Level logLevel(IndexItem<Extension, Object> item) {
            return ((Extension)item.annotation()).optional() ? Level.FINE : Level.WARNING;
        }
    }

    @Extension
    public static class GuiceFinder
    extends ExtensionFinder {
        private volatile Injector container;
        private List<IndexItem<?, Object>> sezpozIndex;
        private final Map<Key, Annotation> annotations = new HashMap<Key, Annotation>();
        private final Sezpoz moduleFinder = new Sezpoz();
        private Map<Class<? extends Annotation>, GuiceExtensionAnnotation<?>> extensionAnnotations = Maps.newHashMap();
        public static final Scope FAULT_TOLERANT_SCOPE = new FaultTolerantScope(true);
        private static final Scope QUIET_FAULT_TOLERANT_SCOPE = new FaultTolerantScope(false);
        private static final Logger LOGGER = Logger.getLogger(GuiceFinder.class.getName());

        public GuiceFinder() {
            for (ExtensionComponent<GuiceExtensionAnnotation> ec : this.moduleFinder.find(GuiceExtensionAnnotation.class, Hudson.getInstance())) {
                GuiceExtensionAnnotation gea = ec.getInstance();
                this.extensionAnnotations.put(gea.annotationType, gea);
            }
            this.sezpozIndex = this.loadSezpozIndices(Jenkins.getInstance().getPluginManager().uberClassLoader);
            ArrayList<Object> modules = new ArrayList<Object>();
            modules.add(new AbstractModule(){

                protected void configure() {
                    Jenkins j = Jenkins.getInstance();
                    this.bind(Jenkins.class).toInstance((Object)j);
                    this.bind(PluginManager.class).toInstance((Object)j.getPluginManager());
                }
            });
            modules.add((Object)new SezpozModule(this.sezpozIndex));
            for (ExtensionComponent<Module> ec : this.moduleFinder.find(Module.class, Hudson.getInstance())) {
                modules.add(ec.getInstance());
            }
            try {
                this.container = Guice.createInjector(modules);
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Failed to create Guice container from all the plugins", e);
                this.container = Guice.createInjector((Module[])new Module[]{new SezpozModule((List<IndexItem<?, Object>>)this.loadSezpozIndices(Jenkins.class.getClassLoader()))});
            }
            Jenkins.getInstance().lookup.set(Injector.class, new ProxyInjector(){

                @Override
                protected Injector resolve() {
                    return GuiceFinder.this.getContainer();
                }
            });
        }

        private ImmutableList<IndexItem<?, Object>> loadSezpozIndices(ClassLoader classLoader) {
            ArrayList indices = Lists.newArrayList();
            for (GuiceExtensionAnnotation<?> gea : this.extensionAnnotations.values()) {
                Iterables.addAll((Collection)indices, (Iterable)Index.load(gea.annotationType, Object.class, (ClassLoader)classLoader));
            }
            return ImmutableList.copyOf((Collection)indices);
        }

        public Injector getContainer() {
            return this.container;
        }

        @Override
        public synchronized ExtensionComponentSet refresh() throws ExtensionRefreshException {
            ArrayList delta = Lists.newArrayList();
            for (Class<? extends Annotation> annotationType : this.extensionAnnotations.keySet()) {
                delta.addAll(Sezpoz.listDelta(annotationType, this.sezpozIndex));
            }
            ArrayList l = Lists.newArrayList(this.sezpozIndex);
            l.addAll(delta);
            this.sezpozIndex = l;
            ArrayList<SezpozModule> modules = new ArrayList<SezpozModule>();
            modules.add(new SezpozModule(delta));
            for (ExtensionComponent<Module> ec : this.moduleFinder.refresh().find(Module.class)) {
                modules.add((SezpozModule)ec.getInstance());
            }
            try {
                Injector child;
                this.container = child = this.container.createChildInjector(modules);
                return new ExtensionComponentSet(){

                    @Override
                    public <T> Collection<ExtensionComponent<T>> find(Class<T> type) {
                        ArrayList<ExtensionComponent<T>> result = new ArrayList<ExtensionComponent<T>>();
                        GuiceFinder.this._find(type, result, child);
                        return result;
                    }
                };
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Failed to create Guice container from newly added plugins", e);
                throw new ExtensionRefreshException(e);
            }
        }

        private Object instantiate(IndexItem<?, Object> item) {
            try {
                return item.instance();
            }
            catch (Exception | LinkageError e) {
                LOGGER.log(this.isOptional(item.annotation()) ? Level.FINE : Level.WARNING, "Failed to load " + item.className(), e);
                return null;
            }
        }

        private boolean isOptional(Annotation annotation) {
            GuiceExtensionAnnotation<?> gea = this.extensionAnnotations.get(annotation.annotationType());
            return gea.isOptional(annotation);
        }

        private boolean isActive(Annotation annotation, AnnotatedElement e) {
            GuiceExtensionAnnotation<?> gea = this.extensionAnnotations.get(annotation.annotationType());
            return gea.isActive(e);
        }

        public <U> Collection<ExtensionComponent<U>> find(Class<U> type, Hudson jenkins) {
            ArrayList<ExtensionComponent<U>> result = new ArrayList<ExtensionComponent<U>>();
            for (Injector i = this.container; i != null; i = i.getParent()) {
                this._find(type, result, i);
            }
            return result;
        }

        private <U> void _find(Class<U> type, List<ExtensionComponent<U>> result, Injector container) {
            for (Map.Entry e : container.getBindings().entrySet()) {
                if (!type.isAssignableFrom(((Key)e.getKey()).getTypeLiteral().getRawType())) continue;
                Annotation a = this.annotations.get(e.getKey());
                Object o = ((Binding)e.getValue()).getProvider().get();
                if (o == null) continue;
                GuiceExtensionAnnotation<?> gea = a != null ? this.extensionAnnotations.get(a.annotationType()) : null;
                result.add(new ExtensionComponent<U>(type.cast(o), gea != null ? gea.getOrdinal(a) : 0.0));
            }
        }

        @Override
        public void scout(Class extensionType, Hudson hudson) {
        }

        private class SezpozModule
        extends AbstractModule {
            private final List<IndexItem<?, Object>> index;

            public SezpozModule(List<IndexItem<?, Object>> index) {
                this.index = index;
            }

            private void resolve(Class c) {
                try {
                    c.getGenericSuperclass();
                    c.getGenericInterfaces();
                    ClassLoader ecl = c.getClassLoader();
                    Method m = ClassLoader.class.getDeclaredMethod("resolveClass", Class.class);
                    m.setAccessible(true);
                    m.invoke((Object)ecl, c);
                    c.getConstructors();
                    c.getMethods();
                    for (Field f : c.getFields()) {
                        if (f.getAnnotation(javax.inject.Inject.class) == null && f.getAnnotation(Inject.class) == null) continue;
                        this.resolve(f.getType());
                    }
                    LOGGER.log(Level.FINER, "{0} looks OK", c);
                    while (c != Object.class) {
                        c.getGenericSuperclass();
                        c = c.getSuperclass();
                    }
                }
                catch (Exception x) {
                    throw (LinkageError)new LinkageError("Failed to resolve " + c).initCause(x);
                }
            }

            protected void configure() {
                for (final IndexItem<?, Object> item : this.index) {
                    boolean optional = GuiceFinder.this.isOptional(item.annotation());
                    try {
                        Class<?> extType;
                        Scope scope;
                        AnnotatedElement e = item.element();
                        Annotation a = item.annotation();
                        if (!GuiceFinder.this.isActive(a, e)) continue;
                        Scope scope2 = scope = optional ? QUIET_FAULT_TOLERANT_SCOPE : FAULT_TOLERANT_SCOPE;
                        if (e instanceof Class) {
                            Key key = Key.get((Class)((Class)e));
                            this.resolve((Class)e);
                            GuiceFinder.this.annotations.put(key, a);
                            this.bind(key).in(scope);
                            continue;
                        }
                        if (e instanceof Field) {
                            extType = ((Field)e).getType();
                        } else if (e instanceof Method) {
                            extType = ((Method)e).getReturnType();
                        } else {
                            throw new AssertionError();
                        }
                        this.resolve(extType);
                        Key key = Key.get(extType, (Annotation)Names.named((String)(item.className() + "." + item.memberName())));
                        GuiceFinder.this.annotations.put(key, a);
                        this.bind(key).toProvider(new Provider(){

                            public Object get() {
                                return GuiceFinder.this.instantiate(item);
                            }
                        }).in(scope);
                    }
                    catch (Exception | LinkageError e) {
                        LOGGER.log(optional ? Level.FINE : Level.WARNING, "Failed to load " + item.className(), e);
                    }
                }
            }
        }

        private static final class FaultTolerantScope
        implements Scope {
            private final boolean verbose;

            FaultTolerantScope(boolean verbose) {
                this.verbose = verbose;
            }

            public <T> Provider<T> scope(final Key<T> key, Provider<T> unscoped) {
                final Provider base = Scopes.SINGLETON.scope(key, unscoped);
                return new Provider<T>(){

                    public T get() {
                        try {
                            return base.get();
                        }
                        catch (Exception | LinkageError e) {
                            this.error(key, e);
                            return null;
                        }
                    }

                    void error(Key<T> key2, Throwable x) {
                        if (FaultTolerantScope.this.verbose) {
                            LOGGER.log(Level.WARNING, "Failed to instantiate " + key2 + "; skipping this component", x);
                        } else {
                            LOGGER.log(Level.INFO, "Failed to instantiate optional component {0}; skipping", key2.getTypeLiteral());
                            LOGGER.log(Level.FINE, key2.toString(), x);
                        }
                    }
                };
            }
        }
    }

    public static abstract class GuiceExtensionAnnotation<T extends Annotation> {
        public final Class<T> annotationType;

        protected GuiceExtensionAnnotation(Class<T> annotationType) {
            this.annotationType = annotationType;
        }

        protected abstract double getOrdinal(T var1);

        protected abstract boolean isActive(AnnotatedElement var1);

        protected abstract boolean isOptional(T var1);
    }

    @Extension
    public static final class DefaultGuiceExtensionAnnotation
    extends GuiceExtensionAnnotation<Extension> {
        public DefaultGuiceExtensionAnnotation() {
            super(Extension.class);
        }

        @Override
        protected boolean isOptional(Extension annotation) {
            return annotation.optional();
        }

        @Override
        protected double getOrdinal(Extension annotation) {
            return annotation.ordinal();
        }

        @Override
        protected boolean isActive(AnnotatedElement e) {
            return true;
        }
    }
}

