/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import groovy.lang.Binding;
import groovy.lang.Closure;
import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.Messages;
import hudson.remoting.ChannelClosedException;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import jline.TerminalFactory;
import jline.UnsupportedTerminal;
import org.codehaus.groovy.tools.shell.Groovysh;
import org.codehaus.groovy.tools.shell.IO;
import org.codehaus.groovy.tools.shell.Shell;
import org.codehaus.groovy.tools.shell.util.XmlCommandRegistrar;
import org.kohsuke.args4j.Argument;

@Extension
public class GroovyshCommand
extends CLICommand {
    @Argument(metaVar="ARGS")
    public List<String> args = new ArrayList<String>();

    @Override
    public String getShortDescription() {
        return Messages.GroovyshCommand_ShortDescription();
    }

    @Override
    protected int run() {
        Jenkins.getActiveInstance().checkPermission(Jenkins.RUN_SCRIPTS);
        System.setProperty("jline.terminal", UnsupportedTerminal.class.getName());
        TerminalFactory.reset();
        StringBuilder commandLine = new StringBuilder();
        for (String arg : this.args) {
            if (commandLine.length() > 0) {
                commandLine.append(" ");
            }
            commandLine.append(arg);
        }
        Groovysh shell = this.createShell(this.stdin, this.stdout, this.stderr);
        return shell.run(commandLine.toString());
    }

    protected Groovysh createShell(InputStream stdin, PrintStream stdout, PrintStream stderr) {
        Binding binding = new Binding();
        binding.setProperty("out", (Object)new PrintWriter(stdout, true));
        binding.setProperty("hudson", (Object)Jenkins.getActiveInstance());
        binding.setProperty("jenkins", (Object)Jenkins.getActiveInstance());
        IO io = new IO((InputStream)new BufferedInputStream(stdin), (OutputStream)stdout, (OutputStream)stderr);
        final ClassLoader cl = Jenkins.getActiveInstance().pluginManager.uberClassLoader;
        Closure registrar = new Closure(null, null){
            private static final long serialVersionUID = 1L;

            @SuppressWarnings(value={"UMAC_UNCALLABLE_METHOD_OF_ANONYMOUS_CLASS"}, justification="Closure invokes this via reflection")
            public Object doCall(Object[] args) {
                assert (args.length == 1);
                assert (args[0] instanceof Shell);
                Shell shell = (Shell)args[0];
                XmlCommandRegistrar r = new XmlCommandRegistrar(shell, cl);
                r.register(GroovyshCommand.class.getResource("commands.xml"));
                return null;
            }
        };
        Groovysh shell = new Groovysh(cl, binding, io, registrar);
        shell.getImports().add("hudson.model.*");
        final Closure originalErrorHook = shell.getErrorHook();
        shell.setErrorHook(new Closure(shell, shell){
            private static final long serialVersionUID = 1L;

            @SuppressWarnings(value={"UMAC_UNCALLABLE_METHOD_OF_ANONYMOUS_CLASS"}, justification="Closure invokes this via reflection")
            public Object doCall(Object[] args) throws ChannelClosedException {
                if (args.length == 1 && args[0] instanceof ChannelClosedException) {
                    throw (ChannelClosedException)args[0];
                }
                return originalErrorHook.call(args);
            }
        });
        return shell;
    }
}

