/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.AbortException;
import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.Messages;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Item;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.args4j.Argument;

@Extension
public class ReloadJobCommand
extends CLICommand {
    @Argument(usage="Name of the job(s) to reload", required=true, multiValued=true)
    private List<String> jobs;
    private static final Logger LOGGER = Logger.getLogger(ReloadJobCommand.class.getName());

    @Override
    public String getShortDescription() {
        return Messages.ReloadJobCommand_ShortDescription();
    }

    @Override
    protected int run() throws Exception {
        boolean errorOccurred = false;
        Jenkins jenkins = Jenkins.getActiveInstance();
        HashSet<String> hs = new HashSet<String>();
        hs.addAll(this.jobs);
        for (String job_s : hs) {
            AbstractItem job = null;
            try {
                Item item = jenkins.getItemByFullName(job_s);
                if (item instanceof AbstractItem) {
                    job = (AbstractItem)item;
                } else if (item != null) {
                    LOGGER.log(Level.WARNING, "Unsupported item type: {0}", item.getClass().getName());
                }
                if (job == null) {
                    AbstractProject project = AbstractProject.findNearest(job_s);
                    throw new IllegalArgumentException(project == null ? "No such job \u2018" + job_s + "\u2019 exists." : String.format("No such job \u2018%s\u2019 exists. Perhaps you meant \u2018%s\u2019?", job_s, project.getFullName()));
                }
                job.checkPermission(AbstractItem.CONFIGURE);
                job.doReload();
            }
            catch (Exception e) {
                if (hs.size() == 1) {
                    throw e;
                }
                String errorMsg = String.format(job_s + ": " + e.getMessage(), new Object[0]);
                this.stderr.println(errorMsg);
                errorOccurred = true;
            }
        }
        if (errorOccurred) {
            throw new AbortException("Error occured while performing this command, see previous stderr output.");
        }
        return 0;
    }
}

