/*
 * Decompiled with CFR 0.152.
 */
package hudson.fsp;

import hudson.FilePath;
import hudson.Launcher;
import hudson.PermalinkList;
import hudson.WorkspaceSnapshot;
import hudson.fsp.Messages;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.PermalinkProjectAction;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import java.io.File;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class WorkspaceSnapshotSCM
extends SCM {
    public String jobName;
    public String permalink;

    @DataBoundConstructor
    public WorkspaceSnapshotSCM(String jobName, String permalink) {
        this.jobName = jobName;
        this.permalink = permalink;
    }

    public Snapshot resolve() throws ResolvedFailedException {
        Jenkins h = Jenkins.getInstance();
        AbstractProject job = h.getItemByFullName(this.jobName, AbstractProject.class);
        if (job == null) {
            if (h.getItemByFullName(this.jobName) == null) {
                AbstractProject nearest = AbstractProject.findNearest(this.jobName);
                throw new ResolvedFailedException(Messages.WorkspaceSnapshotSCM_NoSuchJob(this.jobName, nearest.getFullName()));
            }
            throw new ResolvedFailedException(Messages.WorkspaceSnapshotSCM_IncorrectJobType(this.jobName));
        }
        PermalinkList permalinks = job.getPermalinks();
        PermalinkProjectAction.Permalink p = permalinks.get(this.permalink);
        if (p == null) {
            throw new ResolvedFailedException(Messages.WorkspaceSnapshotSCM_NoSuchPermalink(this.permalink, this.jobName));
        }
        AbstractBuild b = (AbstractBuild)p.resolve(job);
        if (b == null) {
            throw new ResolvedFailedException(Messages.WorkspaceSnapshotSCM_NoBuild(this.permalink, this.jobName));
        }
        WorkspaceSnapshot snapshot = b.getAction(WorkspaceSnapshot.class);
        if (snapshot == null) {
            throw new ResolvedFailedException(Messages.WorkspaceSnapshotSCM_NoWorkspace(this.jobName, this.permalink));
        }
        return new Snapshot(snapshot, b);
    }

    @Override
    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return null;
    }

    protected PollingResult compareRemoteRevisionWith(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        return PollingResult.NO_CHANGES;
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        try {
            this.resolve().restoreTo(workspace, listener);
            return true;
        }
        catch (ResolvedFailedException e) {
            listener.error(e.getMessage());
            build.setResult(Result.FAILURE);
            return false;
        }
    }

    @Override
    public ChangeLogParser createChangeLogParser() {
        return null;
    }

    @Override
    public SCMDescriptor<?> getDescriptor() {
        return null;
    }

    private static class Snapshot {
        final WorkspaceSnapshot snapshot;
        final AbstractBuild<?, ?> owner;

        private Snapshot(WorkspaceSnapshot snapshot, AbstractBuild<?, ?> owner) {
            this.snapshot = snapshot;
            this.owner = owner;
        }

        void restoreTo(FilePath dst, TaskListener listener) throws IOException, InterruptedException {
            this.snapshot.restoreTo(this.owner, dst, listener);
        }
    }

    private final class ResolvedFailedException
    extends Exception {
        private ResolvedFailedException(String message) {
            super(message);
        }
    }
}

