/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.ExtensionList;
import hudson.Util;
import hudson.model.AbstractModelObject;
import hudson.model.Action;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.ModelObjectWithContextMenu;
import jenkins.model.TransientActionFactory;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class Actionable
extends AbstractModelObject
implements ModelObjectWithContextMenu {
    private volatile CopyOnWriteArrayList<Action> actions;
    private static final Logger LOGGER = Logger.getLogger(Actionable.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List<Action> getActions() {
        if (this.actions == null) {
            Actionable actionable = this;
            synchronized (actionable) {
                if (this.actions == null) {
                    this.actions = new CopyOnWriteArrayList();
                }
            }
        }
        return this.actions;
    }

    @Exported(name="actions")
    public final List<? extends Action> getAllActions() {
        ArrayList<Action> _actions = new ArrayList<Action>(this.getActions());
        for (TransientActionFactory taf : ExtensionList.lookup(TransientActionFactory.class)) {
            if (!taf.type().isInstance(this)) continue;
            try {
                _actions.addAll(this.createFor(taf));
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Could not load actions from " + taf + " for " + this, e);
            }
        }
        return Collections.unmodifiableList(_actions);
    }

    private <T> Collection<? extends Action> createFor(TransientActionFactory<T> taf) {
        return taf.createFor(taf.type().cast(this));
    }

    public <T extends Action> List<T> getActions(Class<T> type) {
        return Util.filter(this.getAllActions(), type);
    }

    public void addAction(Action a) {
        if (a == null) {
            throw new IllegalArgumentException();
        }
        this.getActions().add(a);
    }

    public void replaceAction(Action a) {
        ArrayList<Action> old = new ArrayList<Action>(1);
        List<Action> current = this.getActions();
        for (Action a2 : current) {
            if (a2.getClass() != a.getClass()) continue;
            old.add(a2);
        }
        current.removeAll(old);
        this.addAction(a);
    }

    @Deprecated
    public Action getAction(int index) {
        if (this.actions == null) {
            return null;
        }
        return this.actions.get(index);
    }

    public <T extends Action> T getAction(Class<T> type) {
        for (Action action : this.getAllActions()) {
            if (!type.isInstance(action)) continue;
            return (T)((Action)type.cast(action));
        }
        return null;
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        for (Action action : this.getAllActions()) {
            String urlName;
            if (action == null || (urlName = action.getUrlName()) == null || !urlName.equals(token)) continue;
            return action;
        }
        return null;
    }

    @Override
    public ModelObjectWithContextMenu.ContextMenu doContextMenu(StaplerRequest request, StaplerResponse response) throws Exception {
        return new ModelObjectWithContextMenu.ContextMenu().from(this, request, response);
    }
}

