/*
 * Decompiled with CFR 0.152.
 */
package hudson.model.queue;

import hudson.console.ModelHyperlinkNote;
import hudson.model.Label;
import hudson.model.Messages;
import hudson.model.Node;
import hudson.model.TaskListener;
import org.jvnet.localizer.Localizable;

public abstract class CauseOfBlockage {
    public abstract String getShortDescription();

    public void print(TaskListener listener) {
        listener.getLogger().println(this.getShortDescription());
    }

    public static CauseOfBlockage fromMessage(final Localizable l) {
        return new CauseOfBlockage(){

            @Override
            public String getShortDescription() {
                return l.toString();
            }
        };
    }

    public String toString() {
        return this.getShortDescription();
    }

    public static CauseOfBlockage createNeedsMoreExecutor(Localizable l) {
        return new NeedsMoreExecutorImpl(l);
    }

    public static final class BecauseLabelIsBusy
    extends CauseOfBlockage
    implements NeedsMoreExecutor {
        public final Label label;

        public BecauseLabelIsBusy(Label label) {
            this.label = label;
        }

        @Override
        public String getShortDescription() {
            return Messages.Queue_WaitingForNextAvailableExecutorOn(this.label.getName());
        }
    }

    public static final class BecauseNodeIsBusy
    extends CauseOfBlockage
    implements NeedsMoreExecutor {
        public final Node node;

        public BecauseNodeIsBusy(Node node) {
            this.node = node;
        }

        @Override
        public String getShortDescription() {
            String name = this.node.toComputer() != null ? this.node.toComputer().getDisplayName() : this.node.getDisplayName();
            return Messages.Queue_WaitingForNextAvailableExecutorOn(name);
        }

        @Override
        public void print(TaskListener listener) {
            listener.getLogger().println(Messages.Queue_WaitingForNextAvailableExecutorOn(ModelHyperlinkNote.encodeTo(this.node)));
        }
    }

    public static final class BecauseLabelIsOffline
    extends CauseOfBlockage
    implements NeedsMoreExecutor {
        public final Label label;

        public BecauseLabelIsOffline(Label l) {
            this.label = l;
        }

        @Override
        public String getShortDescription() {
            if (this.label.isEmpty()) {
                return Messages.Queue_LabelHasNoNodes(this.label.getName());
            }
            return Messages.Queue_AllNodesOffline(this.label.getName());
        }
    }

    public static final class BecauseNodeIsOffline
    extends CauseOfBlockage
    implements NeedsMoreExecutor {
        public final Node node;

        public BecauseNodeIsOffline(Node node) {
            this.node = node;
        }

        @Override
        public String getShortDescription() {
            String name = this.node.toComputer() != null ? this.node.toComputer().getDisplayName() : this.node.getDisplayName();
            return Messages.Queue_NodeOffline(name);
        }

        @Override
        public void print(TaskListener listener) {
            listener.getLogger().println(Messages.Queue_NodeOffline(ModelHyperlinkNote.encodeTo(this.node)));
        }
    }

    private static final class NeedsMoreExecutorImpl
    extends CauseOfBlockage
    implements NeedsMoreExecutor {
        private final Localizable l;

        private NeedsMoreExecutorImpl(Localizable l) {
            this.l = l;
        }

        @Override
        public String getShortDescription() {
            return this.l.toString();
        }
    }

    static interface NeedsMoreExecutor {
    }
}

