/*
 * Decompiled with CFR 0.152.
 */
package hudson.model.queue;

import hudson.model.Queue;
import hudson.model.queue.SubTask;
import hudson.security.ACL;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import jenkins.security.QueueItemAuthenticator;
import jenkins.security.QueueItemAuthenticatorConfiguration;
import org.acegisecurity.Authentication;

public class Tasks {
    public static Collection<? extends SubTask> getSubTasksOf(Queue.Task task) {
        try {
            return task.getSubTasks();
        }
        catch (AbstractMethodError e) {
            return Collections.singleton(task);
        }
    }

    public static Object getSameNodeConstraintOf(SubTask t) {
        try {
            return t.getSameNodeConstraint();
        }
        catch (AbstractMethodError e) {
            return null;
        }
    }

    @Nonnull
    public static Queue.Task getOwnerTaskOf(@Nonnull SubTask t) {
        try {
            return t.getOwnerTask();
        }
        catch (AbstractMethodError e) {
            return (Queue.Task)t;
        }
    }

    @Nonnull
    public static Authentication getDefaultAuthenticationOf(Queue.Task t) {
        try {
            return t.getDefaultAuthentication();
        }
        catch (AbstractMethodError e) {
            return ACL.SYSTEM;
        }
    }

    @Nonnull
    public static Authentication getDefaultAuthenticationOf(Queue.Task t, Queue.Item item) {
        try {
            return t.getDefaultAuthentication(item);
        }
        catch (AbstractMethodError e) {
            return Tasks.getDefaultAuthenticationOf(t);
        }
    }

    @Nonnull
    public static Authentication getAuthenticationOf(@Nonnull Queue.Task t) {
        for (QueueItemAuthenticator qia : QueueItemAuthenticatorConfiguration.get().getAuthenticators()) {
            Authentication a = qia.authenticate(t);
            if (a == null) continue;
            return a;
        }
        return Tasks.getDefaultAuthenticationOf(t);
    }
}

