/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import hudson.model.Hudson;
import hudson.security.Permission;
import hudson.security.PermissionScope;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import org.jvnet.localizer.Localizable;

public final class PermissionGroup
implements Iterable<Permission>,
Comparable<PermissionGroup> {
    private final SortedSet<Permission> permissions = new TreeSet<Permission>(Permission.ID_COMPARATOR);
    public final Class owner;
    public final Localizable title;
    private static final SortedSet<PermissionGroup> PERMISSIONS = new TreeSet<PermissionGroup>();

    public PermissionGroup(Class owner, Localizable title) throws IllegalStateException {
        this.owner = owner;
        this.title = title;
        PermissionGroup.register(this);
    }

    private String id() {
        return this.owner.getName();
    }

    @Override
    public Iterator<Permission> iterator() {
        return this.getPermissions().iterator();
    }

    synchronized void add(Permission p) {
        if (!this.permissions.add(p)) {
            throw new IllegalStateException("attempt to register a second Permission for " + p.getId());
        }
    }

    public synchronized List<Permission> getPermissions() {
        return new ArrayList<Permission>(this.permissions);
    }

    public synchronized boolean hasPermissionContainedBy(PermissionScope scope) {
        for (Permission p : this.permissions) {
            if (!p.isContainedBy(scope)) continue;
            return true;
        }
        return false;
    }

    public synchronized Permission find(String name) {
        for (Permission p : this.permissions) {
            if (!p.name.equals(name)) continue;
            return p;
        }
        return null;
    }

    @Override
    public int compareTo(PermissionGroup that) {
        int r = this.compareOrder() - that.compareOrder();
        if (r != 0) {
            return r;
        }
        return this.id().compareTo(that.id());
    }

    private int compareOrder() {
        if (this.owner == Hudson.class) {
            return 0;
        }
        return 1;
    }

    public boolean equals(Object o) {
        return o instanceof PermissionGroup && this.id().equals(((PermissionGroup)o).id());
    }

    public int hashCode() {
        return this.id().hashCode();
    }

    public synchronized int size() {
        return this.permissions.size();
    }

    public String toString() {
        return "PermissionGroup[" + this.id() + "]";
    }

    private static synchronized void register(PermissionGroup g) {
        if (!PERMISSIONS.add(g)) {
            throw new IllegalStateException("attempt to register a second PermissionGroup for " + g.id());
        }
    }

    public static synchronized List<PermissionGroup> getAll() {
        return new ArrayList<PermissionGroup>(PERMISSIONS);
    }

    @CheckForNull
    public static synchronized PermissionGroup get(Class owner) {
        for (PermissionGroup g : PERMISSIONS) {
            if (g.owner != owner) continue;
            return g;
        }
        return null;
    }
}

