/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks;

import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tasks.CommandInterpreter;
import hudson.tasks.Messages;
import hudson.util.FormValidation;
import hudson.util.LineEndingConversion;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.MasterToSlaveCallable;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class Shell
extends CommandInterpreter {
    private static final Logger LOGGER = Logger.getLogger(Shell.class.getName());

    @DataBoundConstructor
    public Shell(String command) {
        super(LineEndingConversion.convertEOL(command, LineEndingConversion.EOLType.Unix));
    }

    private static String addLineFeedForNonASCII(String s) {
        if (!s.startsWith("#!") && s.indexOf(10) != 0) {
            return "\n" + s;
        }
        return s;
    }

    @Override
    public String[] buildCommandLine(FilePath script) {
        if (this.command.startsWith("#!")) {
            int end = this.command.indexOf(10);
            if (end < 0) {
                end = this.command.length();
            }
            ArrayList<String> args = new ArrayList<String>();
            args.addAll(Arrays.asList(Util.tokenize(this.command.substring(0, end).trim())));
            args.add(script.getRemote());
            args.set(0, ((String)args.get(0)).substring(2));
            return args.toArray(new String[args.size()]);
        }
        return new String[]{this.getDescriptor().getShellOrDefault(script.getChannel()), "-xe", script.getRemote()};
    }

    @Override
    protected String getContents() {
        return Shell.addLineFeedForNonASCII(LineEndingConversion.convertEOL(this.command, LineEndingConversion.EOLType.Unix));
    }

    @Override
    protected String getFileExtension() {
        return ".sh";
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private Object readResolve() throws ObjectStreamException {
        return new Shell(this.command);
    }

    @Extension
    @Symbol(value={"shell"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private String shell;

        public DescriptorImpl() {
            this.load();
        }

        @Override
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getShell() {
            return this.shell;
        }

        @Deprecated
        public String getShellOrDefault() {
            if (this.shell == null) {
                return Functions.isWindows() ? "sh" : "/bin/sh";
            }
            return this.shell;
        }

        public String getShellOrDefault(VirtualChannel channel) {
            if (this.shell != null) {
                return this.shell;
            }
            String interpreter = null;
            try {
                interpreter = channel.call(new Shellinterpreter());
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, null, e);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, null, e);
            }
            if (interpreter == null) {
                interpreter = this.getShellOrDefault();
            }
            return interpreter;
        }

        public void setShell(String shell) {
            this.shell = Util.fixEmptyAndTrim(shell);
            this.save();
        }

        @Override
        public String getDisplayName() {
            return Messages.Shell_DisplayName();
        }

        @Override
        public boolean configure(StaplerRequest req, JSONObject data) throws Descriptor.FormException {
            req.bindJSON((Object)this, data);
            return super.configure(req, data);
        }

        public FormValidation doCheckShell(@QueryParameter String value) {
            return FormValidation.validateExecutable(value);
        }

        private static final class Shellinterpreter
        extends MasterToSlaveCallable<String, IOException> {
            private static final long serialVersionUID = 1L;

            private Shellinterpreter() {
            }

            @Override
            public String call() throws IOException {
                return Functions.isWindows() ? "sh" : "/bin/sh";
            }
        }
    }
}

