/*
 * Decompiled with CFR 0.152.
 */
package hudson.tools;

import com.thoughtworks.xstream.annotations.XStreamSerializable;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.ExtensionPoint;
import hudson.diagnosis.OldDataMonitor;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolLocationNodeProperty;
import hudson.tools.ToolProperty;
import hudson.tools.ToolPropertyDescriptor;
import hudson.util.DescribableList;
import hudson.util.XStream2;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;

public abstract class ToolInstallation
extends AbstractDescribableImpl<ToolInstallation>
implements Serializable,
ExtensionPoint {
    private final String name;
    private String home;
    @XStreamSerializable
    private transient DescribableList<ToolProperty<?>, ToolPropertyDescriptor> properties = new DescribableList(Saveable.NOOP);
    private static final long serialVersionUID = 1L;

    @Deprecated
    public ToolInstallation(String name, String home) {
        this.name = name;
        this.home = home;
    }

    public ToolInstallation(String name, String home, List<? extends ToolProperty<?>> properties) {
        this.name = name;
        this.home = home;
        if (properties != null) {
            try {
                this.properties.replaceBy(properties);
                for (ToolProperty<?> p : properties) {
                    this._setTool(p, this);
                }
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private <T extends ToolInstallation> void _setTool(ToolProperty<T> prop, ToolInstallation t) {
        prop.setTool((ToolInstallation)prop.type().cast(t));
    }

    public String getName() {
        return this.name;
    }

    @CheckForNull
    public String getHome() {
        return this.home;
    }

    public void buildEnvVars(EnvVars env) {
    }

    public DescribableList<ToolProperty<?>, ToolPropertyDescriptor> getProperties() {
        assert (this.properties != null);
        return this.properties;
    }

    public ToolInstallation translate(@Nonnull Node node, EnvVars envs, TaskListener listener) throws IOException, InterruptedException {
        ToolInstallation t = this;
        if (t instanceof NodeSpecific) {
            NodeSpecific n = (NodeSpecific)((Object)t);
            t = (ToolInstallation)n.forNode(node, listener);
        }
        if (t instanceof EnvironmentSpecific) {
            EnvironmentSpecific e = (EnvironmentSpecific)((Object)t);
            t = (ToolInstallation)e.forEnvironment(envs);
        }
        return t;
    }

    public ToolInstallation translate(AbstractBuild<?, ?> buildInProgress, TaskListener listener) throws IOException, InterruptedException {
        assert (buildInProgress.isBuilding());
        return this.translate(buildInProgress.getBuiltOn(), buildInProgress.getEnvironment(listener), listener);
    }

    protected String translateFor(Node node, TaskListener log) throws IOException, InterruptedException {
        return ToolLocationNodeProperty.getToolHome(node, this, log);
    }

    protected Object readResolve() {
        if (this.properties == null) {
            this.properties = new DescribableList(Saveable.NOOP);
        }
        for (ToolProperty p : this.properties) {
            this._setTool(p, this);
        }
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.name + "]";
    }

    public static DescriptorExtensionList<ToolInstallation, ToolDescriptor<?>> all() {
        return Jenkins.getInstance().getDescriptorList(ToolInstallation.class);
    }

    protected static abstract class ToolConverter
    extends XStream2.PassthruConverter<ToolInstallation> {
        public ToolConverter(XStream2 xstream) {
            super(xstream);
        }

        @Override
        protected void callback(ToolInstallation obj, UnmarshallingContext context) {
            String s;
            if (obj.home == null && (s = this.oldHomeField(obj)) != null) {
                obj.home = s;
                OldDataMonitor.report(context, "1.286");
            }
        }

        protected abstract String oldHomeField(ToolInstallation var1);
    }
}

