/*
 * Decompiled with CFR 0.152.
 */
package hudson.triggers;

import hudson.security.ACL;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;

public abstract class SafeTimerTask
extends TimerTask {
    private static final Logger LOGGER = Logger.getLogger(SafeTimerTask.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        SecurityContext oldContext = ACL.impersonate(ACL.SYSTEM);
        try {
            this.doRun();
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Timer task " + this + " failed", t);
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)oldContext);
        }
    }

    protected abstract void doRun() throws Exception;
}

