/*
 * Decompiled with CFR 0.152.
 */
package hudson.triggers;

import antlr.ANTLRException;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.DependencyRunner;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Describable;
import hudson.model.Item;
import hudson.model.PeriodicWork;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.scheduler.CronTabList;
import hudson.scheduler.Hash;
import hudson.triggers.SCMTrigger;
import hudson.triggers.TriggerDescriptor;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Timer;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import org.jenkinsci.Symbol;

public abstract class Trigger<J extends Item>
implements Describable<Trigger<?>>,
ExtensionPoint {
    protected final String spec;
    protected transient CronTabList tabs;
    @CheckForNull
    protected transient J job;
    private static Future previousSynchronousPolling;
    private static final Logger LOGGER;
    @Deprecated
    @CheckForNull
    @SuppressWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static Timer timer;

    public void start(J project, boolean newInstance) {
        this.job = project;
        try {
            this.tabs = CronTabList.create(this.spec, Hash.from(project.getFullName()));
        }
        catch (ANTLRException e) {
            LOGGER.log(Level.FINE, "Failed to parse crontab spec: " + this.spec, e);
        }
    }

    public void run() {
    }

    public void stop() {
    }

    @Deprecated
    public Action getProjectAction() {
        return null;
    }

    public Collection<? extends Action> getProjectActions() {
        Action a = this.getProjectAction();
        if (a == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(a);
    }

    public TriggerDescriptor getDescriptor() {
        return (TriggerDescriptor)Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }

    protected Trigger(@Nonnull String cronTabSpec) throws ANTLRException {
        this.spec = cronTabSpec;
        this.tabs = CronTabList.create(cronTabSpec);
    }

    protected Trigger() {
        this.spec = "";
        this.tabs = new CronTabList(Collections.emptyList());
    }

    public final String getSpec() {
        return this.spec;
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            this.tabs = CronTabList.create(this.spec);
        }
        catch (ANTLRException e) {
            InvalidObjectException x = new InvalidObjectException(e.getMessage());
            x.initCause(e);
            throw x;
        }
        return this;
    }

    public static void checkTriggers(Calendar cal) {
        Jenkins inst = Jenkins.getInstance();
        SCMTrigger.DescriptorImpl scmd = inst.getDescriptorByType(SCMTrigger.DescriptorImpl.class);
        if (scmd.synchronousPolling) {
            LOGGER.fine("using synchronous polling");
            if (previousSynchronousPolling == null || previousSynchronousPolling.isDone()) {
                previousSynchronousPolling = scmd.getExecutor().submit(new DependencyRunner(new DependencyRunner.ProjectRunnable(){

                    @Override
                    public void run(AbstractProject p) {
                        for (Trigger<?> t : p.getTriggers().values()) {
                            if (!(t instanceof SCMTrigger)) continue;
                            LOGGER.fine("synchronously triggering SCMTrigger for project " + t.job.getName());
                            t.run();
                        }
                    }
                }));
            } else {
                LOGGER.fine("synchronous polling has detected unfinished jobs, will not trigger additional jobs.");
            }
        }
        for (ParameterizedJobMixIn.ParameterizedJob p : inst.getAllItems(ParameterizedJobMixIn.ParameterizedJob.class)) {
            for (Trigger<?> t : p.getTriggers().values()) {
                if (t instanceof SCMTrigger && scmd.synchronousPolling) continue;
                LOGGER.log(Level.FINE, "cron checking {0} with spec \u2018{1}\u2019", new Object[]{p, t.spec.trim()});
                if (t.tabs.check(cal)) {
                    LOGGER.log(Level.CONFIG, "cron triggered {0}", p);
                    try {
                        t.run();
                    }
                    catch (Throwable e) {
                        LOGGER.log(Level.WARNING, t.getClass().getName() + ".run() failed for " + p, e);
                    }
                    continue;
                }
                LOGGER.log(Level.FINER, "did not trigger {0}", p);
            }
        }
    }

    public static DescriptorExtensionList<Trigger<?>, TriggerDescriptor> all() {
        return Jenkins.getInstance().getDescriptorList(Trigger.class);
    }

    public static List<TriggerDescriptor> for_(Item i) {
        ArrayList<TriggerDescriptor> r = new ArrayList<TriggerDescriptor>();
        for (TriggerDescriptor t : Trigger.all()) {
            TopLevelItemDescriptor tld;
            if (!t.isApplicable(i) || i instanceof TopLevelItem && (tld = ((TopLevelItem)i).getDescriptor()) != null && !tld.isApplicable(t)) continue;
            r.add(t);
        }
        return r;
    }

    static {
        LOGGER = Logger.getLogger(Trigger.class.getName());
    }

    @Extension
    @Symbol(value={"cron"})
    public static class Cron
    extends PeriodicWork {
        private final Calendar cal = new GregorianCalendar();

        public Cron() {
            this.cal.set(13, 0);
            this.cal.set(14, 0);
        }

        @Override
        public long getRecurrencePeriod() {
            return 60000L;
        }

        @Override
        public long getInitialDelay() {
            return 60000L - (long)(Calendar.getInstance().get(13) * 1000);
        }

        @Override
        public void doRun() {
            while (new Date().getTime() >= this.cal.getTimeInMillis()) {
                LOGGER.log(Level.FINE, "cron checking {0}", this.cal.getTime());
                try {
                    Trigger.checkTriggers(this.cal);
                }
                catch (Throwable e) {
                    LOGGER.log(Level.WARNING, "Cron thread throw an exception", e);
                }
                this.cal.add(12, 1);
            }
        }
    }
}

