/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import hudson.model.AbstractProject;
import hudson.model.DependencyGraph;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ReconfigurableDescribable;
import hudson.model.Saveable;
import hudson.util.CopyOnWriteList;
import hudson.util.PersistedList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.DependencyDeclarer;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

public class DescribableList<T extends Describable<T>, D extends Descriptor<T>>
extends PersistedList<T> {
    private static final Logger LOGGER = Logger.getLogger(DescribableList.class.getName());

    protected DescribableList() {
    }

    @Deprecated
    public DescribableList(Owner owner) {
        this.setOwner(owner);
    }

    public DescribableList(Saveable owner) {
        this.setOwner(owner);
    }

    public DescribableList(Saveable owner, Collection<? extends T> initialList) {
        super(initialList);
        this.setOwner(owner);
    }

    @Deprecated
    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    public void replace(T item) throws IOException {
        this.removeAll(item.getClass());
        this.data.add(item);
        this.onModified();
    }

    public T getDynamic(String id) {
        for (Describable t : this.data) {
            if (!t.getDescriptor().getId().equals(id)) continue;
            return (T)t;
        }
        try {
            return (T)((Describable)this.data.get(Integer.parseInt(id)));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public T get(D descriptor) {
        for (Describable t : this.data) {
            if (t.getDescriptor() != descriptor) continue;
            return (T)t;
        }
        return null;
    }

    @Override
    public boolean contains(D d) {
        return this.get(d) != null;
    }

    public void remove(D descriptor) throws IOException {
        for (Describable t : this.data) {
            if (t.getDescriptor() != descriptor) continue;
            this.data.remove(t);
            this.onModified();
            return;
        }
    }

    public Map<D, T> toMap() {
        return Descriptor.toMap(this.data);
    }

    public void rebuild(StaplerRequest req, JSONObject json, List<? extends Descriptor<T>> descriptors) throws Descriptor.FormException, IOException {
        ArrayList<Object> newList = new ArrayList<Object>();
        for (Descriptor<T> d : descriptors) {
            T existing = this.get(d);
            String name = d.getJsonSafeClassName();
            JSONObject o = json.optJSONObject(name);
            Object instance = null;
            if (o != null) {
                instance = existing instanceof ReconfigurableDescribable ? (Object)((ReconfigurableDescribable)existing).reconfigure(req, o) : (Object)d.newInstance(req, o);
            } else if (existing instanceof ReconfigurableDescribable) {
                instance = ((ReconfigurableDescribable)existing).reconfigure(req, null);
            }
            if (instance == null) continue;
            newList.add(instance);
        }
        this.replaceBy(newList);
    }

    @Deprecated
    public void rebuild(StaplerRequest req, JSONObject json, List<? extends Descriptor<T>> descriptors, String prefix) throws Descriptor.FormException, IOException {
        this.rebuild(req, json, descriptors);
    }

    public void rebuildHetero(StaplerRequest req, JSONObject formData, Collection<? extends Descriptor<T>> descriptors, String key) throws Descriptor.FormException, IOException {
        this.replaceBy(Descriptor.newInstancesFromHeteroList(req, formData, key, descriptors));
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        for (Object o : this) {
            if (!(o instanceof DependencyDeclarer)) continue;
            DependencyDeclarer dd = (DependencyDeclarer)o;
            try {
                dd.buildDependencyGraph(owner, graph);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.SEVERE, "Failed to build dependency graph for " + owner, e);
            }
        }
    }

    @Override
    public <U extends T> U get(Class<U> type) {
        return (U)((Describable)super.get(type));
    }

    @Override
    public T[] toArray(T[] array) {
        return (Describable[])super.toArray(array);
    }

    public static class ConverterImpl
    extends AbstractCollectionConverter {
        CopyOnWriteList.ConverterImpl copyOnWriteListConverter = new CopyOnWriteList.ConverterImpl(this.mapper());

        public ConverterImpl(Mapper mapper) {
            super(mapper);
        }

        public boolean canConvert(Class type) {
            return DescribableList.class.isAssignableFrom(type);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            for (Object o : (DescribableList)source) {
                this.writeItem(o, context, writer);
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            CopyOnWriteList core = this.copyOnWriteListConverter.unmarshal(reader, context);
            try {
                DescribableList r = (DescribableList)context.getRequiredType().newInstance();
                r.data.replaceBy(core);
                return r;
            }
            catch (InstantiationException e) {
                InstantiationError x = new InstantiationError();
                x.initCause(e);
                throw x;
            }
            catch (IllegalAccessException e) {
                IllegalAccessError x = new IllegalAccessError();
                x.initCause(e);
                throw x;
            }
        }
    }

    @Deprecated
    public static interface Owner
    extends Saveable {
    }
}

