/*
 * Decompiled with CFR 0.152.
 */
package hudson.util.jna;

import hudson.util.jna.JnaException;
import hudson.util.jna.RegistryKey;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jinterop.dcom.common.IJIAuthInfo;
import org.jinterop.dcom.common.JIException;
import org.jinterop.winreg.IJIWinReg;
import org.jinterop.winreg.JIPolicyHandle;
import org.jinterop.winreg.JIWinRegFactory;

public class DotNet {
    private static final Pattern VERSION_PATTERN = Pattern.compile("v(\\d+)\\.(\\d+).*");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isInstalled(int major, int minor) {
        try {
            RegistryKey key = RegistryKey.LOCAL_MACHINE.openReadonly("SOFTWARE\\Microsoft\\.NETFramework");
            try {
                for (String keyName : key.getSubKeys()) {
                    if (!DotNet.matches(keyName, major, minor)) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                key.dispose();
            }
        }
        catch (JnaException e) {
            if (e.getErrorCode() != 2) throw e;
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isInstalled(int major, int minor, String targetMachine, IJIAuthInfo session) throws JIException, UnknownHostException {
        IJIWinReg registry = JIWinRegFactory.getSingleTon().getWinreg(session, targetMachine, true);
        JIPolicyHandle hklm = null;
        JIPolicyHandle key = null;
        try {
            hklm = registry.winreg_OpenHKLM();
            key = registry.winreg_OpenKey(hklm, "SOFTWARE\\Microsoft\\.NETFramework", 131097);
            int i = 0;
            while (true) {
                String keyName;
                if (DotNet.matches(keyName = registry.winreg_EnumKey(key, i)[0], major, minor)) {
                    boolean bl = true;
                    return bl;
                }
                ++i;
                continue;
                break;
            }
        }
        catch (JIException e) {
            if (e.getErrorCode() != 2) throw e;
            boolean bl = false;
            return bl;
        }
        finally {
            if (hklm != null) {
                registry.winreg_CloseKey(hklm);
            }
            if (key != null) {
                registry.winreg_CloseKey(key);
            }
            registry.closeConnection();
        }
    }

    private static boolean matches(String keyName, int major, int minor) {
        int mn;
        int mj;
        Matcher m = VERSION_PATTERN.matcher(keyName);
        return m.matches() && (mj = Integer.parseInt(m.group(1))) >= major && (mn = Integer.parseInt(m.group(2))) >= minor;
    }
}

