/*
 * Decompiled with CFR 0.152.
 */
package hudson.util.spring;

import groovy.lang.GroovyObjectSupport;
import hudson.util.spring.BeanConfiguration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.ChildBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;

class DefaultBeanConfiguration
extends GroovyObjectSupport
implements BeanConfiguration {
    private static final String AUTOWIRE = "autowire";
    private static final String CONSTRUCTOR_ARGS = "constructorArgs";
    private static final String DESTROY_METHOD = "destroyMethod";
    private static final String FACTORY_BEAN = "factoryBean";
    private static final String FACTORY_METHOD = "factoryMethod";
    private static final String INIT_METHOD = "initMethod";
    private static final String BY_NAME = "byName";
    private static final String PARENT = "parent";
    private static final String BY_TYPE = "byType";
    private static final String BY_CONSTRUCTOR = "constructor";
    private static final Set<String> DYNAMIC_PROPS = new HashSet<String>(Arrays.asList("autowire", "constructorArgs", "destroyMethod", "factoryBean", "factoryMethod", "initMethod", "byName", "byType", "constructor"));
    private String parentName;
    private Class clazz;
    private String name;
    private boolean singleton = true;
    private AbstractBeanDefinition definition;
    private Collection constructorArgs = Collections.EMPTY_LIST;
    private BeanWrapper wrapper;

    public Object getProperty(String property) {
        this.getBeanDefinition();
        if (this.wrapper.isReadableProperty(property)) {
            return this.wrapper.getPropertyValue(property);
        }
        if (DYNAMIC_PROPS.contains(property)) {
            return null;
        }
        return super.getProperty(property);
    }

    public void setProperty(String property, Object newValue) {
        if (PARENT.equals(property)) {
            this.setParent(newValue);
        } else {
            AbstractBeanDefinition bd = this.getBeanDefinition();
            if (AUTOWIRE.equals(property)) {
                if (BY_NAME.equals(newValue)) {
                    bd.setAutowireMode(1);
                } else if (BY_TYPE.equals(newValue)) {
                    bd.setAutowireMode(2);
                } else if (Boolean.TRUE.equals(newValue)) {
                    bd.setAutowireMode(1);
                } else if (BY_CONSTRUCTOR.equals(newValue)) {
                    bd.setAutowireMode(3);
                }
            } else if (CONSTRUCTOR_ARGS.equals(property) && newValue instanceof List) {
                ConstructorArgumentValues cav = new ConstructorArgumentValues();
                List args = (List)newValue;
                for (Object e : args) {
                    cav.addGenericArgumentValue(e);
                }
                bd.setConstructorArgumentValues(cav);
            } else if (DESTROY_METHOD.equals(property)) {
                if (newValue != null) {
                    bd.setDestroyMethodName(newValue.toString());
                }
            } else if (FACTORY_BEAN.equals(property)) {
                if (newValue != null) {
                    bd.setFactoryBeanName(newValue.toString());
                }
            } else if (FACTORY_METHOD.equals(property)) {
                if (newValue != null) {
                    bd.setFactoryMethodName(newValue.toString());
                }
            } else if (INIT_METHOD.equals(property)) {
                if (newValue != null) {
                    bd.setInitMethodName(newValue.toString());
                }
            } else if (this.wrapper.isWritableProperty(property)) {
                this.wrapper.setPropertyValue(property, newValue);
            } else {
                super.setProperty(property, newValue);
            }
        }
    }

    public DefaultBeanConfiguration(String name, Class clazz) {
        this.name = name;
        this.clazz = clazz;
    }

    public DefaultBeanConfiguration(String name, Class clazz, boolean prototype) {
        this(name, clazz, Collections.EMPTY_LIST);
        this.singleton = !prototype;
    }

    public DefaultBeanConfiguration(String name) {
        this(name, null, Collections.EMPTY_LIST);
    }

    public DefaultBeanConfiguration(Class clazz2) {
        this.clazz = clazz2;
    }

    public DefaultBeanConfiguration(String name2, Class clazz2, Collection args) {
        this.name = name2;
        this.clazz = clazz2;
        this.constructorArgs = args;
    }

    public DefaultBeanConfiguration(String name2, boolean prototype) {
        this(name2, null, Collections.EMPTY_LIST);
        this.singleton = !prototype;
    }

    public DefaultBeanConfiguration(Class clazz2, Collection constructorArguments) {
        this.clazz = clazz2;
        this.constructorArgs = constructorArguments;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isSingleton() {
        return this.singleton;
    }

    @Override
    public AbstractBeanDefinition getBeanDefinition() {
        if (this.definition == null) {
            this.definition = this.createBeanDefinition();
        }
        return this.definition;
    }

    protected AbstractBeanDefinition createBeanDefinition() {
        Object bd;
        if (this.constructorArgs.size() > 0) {
            ConstructorArgumentValues cav = new ConstructorArgumentValues();
            for (Object constructorArg : this.constructorArgs) {
                cav.addGenericArgumentValue(constructorArg);
            }
            bd = StringUtils.isBlank((String)this.parentName) ? new RootBeanDefinition(this.clazz, cav, null) : new ChildBeanDefinition(this.parentName, this.clazz, cav, null);
            bd.setSingleton(this.singleton);
        } else if (StringUtils.isBlank((String)this.parentName)) {
            bd = new RootBeanDefinition(this.clazz, this.singleton);
        } else {
            bd = new ChildBeanDefinition(this.parentName, this.clazz, null, null);
            bd.setSingleton(this.singleton);
        }
        this.wrapper = new BeanWrapperImpl(bd);
        return bd;
    }

    @Override
    public BeanConfiguration addProperty(String propertyName, Object propertyValue) {
        if (propertyValue instanceof BeanConfiguration) {
            propertyValue = ((BeanConfiguration)propertyValue).getBeanDefinition();
        }
        this.getBeanDefinition().getPropertyValues().addPropertyValue(propertyName, propertyValue);
        return this;
    }

    @Override
    public BeanConfiguration setDestroyMethod(String methodName) {
        this.getBeanDefinition().setDestroyMethodName(methodName);
        return this;
    }

    @Override
    public BeanConfiguration setDependsOn(String[] dependsOn) {
        this.getBeanDefinition().setDependsOn(dependsOn);
        return this;
    }

    @Override
    public BeanConfiguration setFactoryBean(String beanName) {
        this.getBeanDefinition().setFactoryBeanName(beanName);
        return this;
    }

    @Override
    public BeanConfiguration setFactoryMethod(String methodName) {
        this.getBeanDefinition().setFactoryMethodName(methodName);
        return this;
    }

    @Override
    public BeanConfiguration setAutowire(String type) {
        if (BY_NAME.equals(type)) {
            this.getBeanDefinition().setAutowireMode(1);
        } else if (BY_TYPE.equals(type)) {
            this.getBeanDefinition().setAutowireMode(2);
        }
        return this;
    }

    @Override
    public void setName(String beanName) {
        this.name = beanName;
    }

    @Override
    public Object getPropertyValue(String name) {
        return this.getBeanDefinition().getPropertyValues().getPropertyValue(name).getValue();
    }

    @Override
    public boolean hasProperty(String name) {
        return this.getBeanDefinition().getPropertyValues().contains(name);
    }

    @Override
    public void setPropertyValue(String property, Object newValue) {
        this.getBeanDefinition().getPropertyValues().addPropertyValue(property, newValue);
    }

    @Override
    public BeanConfiguration setAbstract(boolean isAbstract) {
        this.getBeanDefinition().setAbstract(isAbstract);
        return this;
    }

    @Override
    public void setParent(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Parent bean cannot be set to a null runtime bean reference!");
        }
        if (obj instanceof String) {
            this.parentName = (String)obj;
        } else if (obj instanceof RuntimeBeanReference) {
            this.parentName = ((RuntimeBeanReference)obj).getBeanName();
        } else if (obj instanceof BeanConfiguration) {
            this.parentName = ((BeanConfiguration)obj).getName();
        }
    }
}

