/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import hudson.util.TimeUnit2;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
@Symbol(value={"assetManager"})
public class AssetManager
implements UnprotectedRootAction {
    private static final Method $findResource = AssetManager.init();

    @Override
    public String getIconFileName() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return null;
    }

    @Override
    public String getUrlName() {
        return "assets";
    }

    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        String path = req.getRestOfPath();
        URL resource = this.findResource(path);
        if (resource == null) {
            rsp.setStatus(404);
            return;
        }
        String requestPath = req.getRequestURI().substring(req.getContextPath().length());
        boolean staticLink = requestPath.startsWith("/static/");
        long expires = staticLink ? TimeUnit2.DAYS.toMillis(365L) : -1L;
        rsp.serveLocalizedFile(req, resource, expires);
    }

    private URL findResource(String path) throws IOException {
        try {
            if (path.contains("..")) {
                throw new IllegalArgumentException(path);
            }
            String name = path.charAt(0) == '/' ? "assets" + path : "assets/" + path;
            ClassLoader cl = Jenkins.class.getClassLoader();
            URL url = (URL)$findResource.invoke((Object)cl, name);
            if (url == null) {
                Enumeration<URL> e = cl.getResources(name);
                while (e.hasMoreElements()) {
                    url = e.nextElement();
                }
            }
            return url;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Error(e);
        }
    }

    private static Method init() {
        try {
            Method m = ClassLoader.class.getDeclaredMethod("findResource", String.class);
            m.setAccessible(true);
            return m;
        }
        catch (NoSuchMethodException e) {
            throw (Error)new NoSuchMethodError().initCause(e);
        }
    }
}

