/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import hudson.console.ModelHyperlinkNote;
import hudson.model.TaskListener;
import hudson.model.User;
import java.io.Serializable;
import jenkins.model.Messages;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class CauseOfInterruption
implements Serializable {
    private static final long serialVersionUID = 1L;

    @Exported
    public abstract String getShortDescription();

    public void print(TaskListener listener) {
        listener.getLogger().println(this.getShortDescription());
    }

    public static final class UserInterruption
    extends CauseOfInterruption {
        private final String user;
        private static final long serialVersionUID = 1L;

        public UserInterruption(User user) {
            this.user = user.getId();
        }

        public UserInterruption(String userId) {
            this.user = userId;
        }

        public User getUser() {
            return User.get(this.user);
        }

        @Override
        public String getShortDescription() {
            return Messages.CauseOfInterruption_ShortDescription(this.user);
        }

        @Override
        public void print(TaskListener listener) {
            listener.getLogger().println(Messages.CauseOfInterruption_ShortDescription(ModelHyperlinkNote.encodeTo(this.getUser())));
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserInterruption that = (UserInterruption)o;
            return this.user.equals(that.user);
        }

        public int hashCode() {
            return this.user.hashCode();
        }
    }
}

