/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import hudson.Extension;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.servlet.ServletContext;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import jenkins.model.Messages;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
@Symbol(value={"location"})
public class JenkinsLocationConfiguration
extends GlobalConfiguration {
    @Deprecated
    private transient String hudsonUrl;
    private String adminAddress;
    private String jenkinsUrl;
    private transient String charset;
    private transient String useSsl;
    private static final Logger LOGGER = Logger.getLogger(JenkinsLocationConfiguration.class.getName());

    @CheckForNull
    public static JenkinsLocationConfiguration get() {
        return GlobalConfiguration.all().get(JenkinsLocationConfiguration.class);
    }

    public JenkinsLocationConfiguration() {
        this.load();
    }

    @Override
    public synchronized void load() {
        XmlFile file = this.getConfigFile();
        if (!file.exists()) {
            XStream2 xs = new XStream2();
            xs.addCompatibilityAlias("hudson.tasks.Mailer$DescriptorImpl", JenkinsLocationConfiguration.class);
            file = new XmlFile(xs, new File(Jenkins.getInstance().getRootDir(), "hudson.tasks.Mailer.xml"));
            if (file.exists()) {
                try {
                    file.unmarshal(this);
                    if (this.jenkinsUrl == null) {
                        this.jenkinsUrl = this.hudsonUrl;
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to load " + file, e);
                }
            }
        } else {
            super.load();
        }
        this.updateSecureSessionFlag();
    }

    @Nonnull
    public String getAdminAddress() {
        String v = this.adminAddress;
        if (v == null) {
            v = Messages.Mailer_Address_Not_Configured();
        }
        return v;
    }

    public void setAdminAddress(@CheckForNull String adminAddress) {
        String address = Util.nullify(adminAddress);
        if (address != null && address.startsWith("\"") && address.endsWith("\"")) {
            address = address.substring(1, address.length() - 1);
        }
        this.adminAddress = address;
        this.save();
    }

    @CheckForNull
    public String getUrl() {
        return this.jenkinsUrl;
    }

    public void setUrl(@CheckForNull String jenkinsUrl) {
        String url = Util.nullify(jenkinsUrl);
        if (url != null && !url.endsWith("/")) {
            url = url + '/';
        }
        this.jenkinsUrl = url;
        this.save();
        this.updateSecureSessionFlag();
    }

    private void updateSecureSessionFlag() {
        try {
            Method m;
            ServletContext context = Jenkins.getInstance().servletContext;
            try {
                m = context.getClass().getMethod("getSessionCookieConfig", new Class[0]);
            }
            catch (NoSuchMethodException x) {
                LOGGER.log(Level.FINE, "Failed to set secure cookie flag", x);
                return;
            }
            Object sessionCookieConfig = m.invoke((Object)context, new Object[0]);
            Class<?> scc = Class.forName("javax.servlet.SessionCookieConfig");
            Method setSecure = scc.getMethod("setSecure", Boolean.TYPE);
            boolean v = Util.fixNull(this.jenkinsUrl).startsWith("https");
            setSecure.invoke(sessionCookieConfig, v);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IllegalStateException) {
                return;
            }
            LOGGER.log(Level.WARNING, "Failed to set secure cookie flag", e);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to set secure cookie flag", e);
        }
    }

    @Override
    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        req.bindJSON((Object)this, json);
        return true;
    }

    public FormValidation doCheckUrl(@QueryParameter String value) {
        if (value.startsWith("http://localhost")) {
            return FormValidation.warning(Messages.Mailer_Localhost_Error());
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckAdminAddress(@QueryParameter String value) {
        try {
            new InternetAddress(value);
            return FormValidation.ok();
        }
        catch (AddressException e) {
            return FormValidation.error(e.getMessage());
        }
    }
}

