/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import hudson.BulkChange;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.Computer;
import hudson.model.Messages;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import hudson.slaves.EphemeralNode;
import hudson.slaves.OfflineCause;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class Nodes
implements Saveable {
    @Nonnull
    private final Jenkins jenkins;
    private final ConcurrentMap<String, Node> nodes = new ConcurrentSkipListMap<String, Node>();

    Nodes(@Nonnull Jenkins jenkins) {
        this.jenkins = jenkins;
    }

    @Nonnull
    public List<Node> getNodes() {
        return new ArrayList<Node>(this.nodes.values());
    }

    public void setNodes(final @Nonnull Collection<? extends Node> nodes) throws IOException {
        Queue.withLock(new Runnable(){

            @Override
            public void run() {
                HashSet toRemove = new HashSet(Nodes.this.nodes.keySet());
                for (Node n : nodes) {
                    String name = n.getNodeName();
                    toRemove.remove(name);
                    Nodes.this.nodes.put(name, n);
                }
                Nodes.this.nodes.keySet().removeAll(toRemove);
                Nodes.this.jenkins.updateComputerList();
                Nodes.this.jenkins.trimLabels();
            }
        });
        this.save();
    }

    public void addNode(final @Nonnull Node node) throws IOException {
        if (node != this.nodes.get(node.getNodeName())) {
            Queue.withLock(new Runnable(){

                @Override
                public void run() {
                    Nodes.this.nodes.put(node.getNodeName(), node);
                    Nodes.this.jenkins.updateComputerList();
                    Nodes.this.jenkins.trimLabels();
                }
            });
            this.persistNode(node);
        }
    }

    private void persistNode(@Nonnull Node node) throws IOException {
        if (node instanceof EphemeralNode) {
            Util.deleteRecursive(new File(this.getNodesDir(), node.getNodeName()));
        } else {
            XmlFile xmlFile = new XmlFile(Jenkins.XSTREAM, new File(new File(this.getNodesDir(), node.getNodeName()), "config.xml"));
            xmlFile.write(node);
            SaveableListener.fireOnChange(this, xmlFile);
        }
        this.jenkins.getQueue().scheduleMaintenance();
    }

    public boolean updateNode(final @Nonnull Node node) throws IOException {
        boolean exists;
        try {
            exists = Queue.withLock(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    if (node == Nodes.this.nodes.get(node.getNodeName())) {
                        Nodes.this.jenkins.trimLabels();
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            exists = false;
        }
        if (exists) {
            this.persistNode(node);
            return true;
        }
        return false;
    }

    public void removeNode(final @Nonnull Node node) throws IOException {
        if (node == this.nodes.get(node.getNodeName())) {
            Queue.withLock(new Runnable(){

                @Override
                public void run() {
                    Computer c = node.toComputer();
                    if (c != null) {
                        c.recordTermination();
                        c.disconnect(OfflineCause.create(Messages._Hudson_NodeBeingRemoved()));
                    }
                    if (node == Nodes.this.nodes.remove(node.getNodeName())) {
                        Nodes.this.jenkins.updateComputerList();
                        Nodes.this.jenkins.trimLabels();
                    }
                }
            });
            Util.deleteRecursive(new File(this.getNodesDir(), node.getNodeName()));
        }
    }

    @Override
    public void save() throws IOException {
        if (BulkChange.contains(this)) {
            return;
        }
        File nodesDir = this.getNodesDir();
        final HashSet<String> existing = new HashSet<String>();
        for (Node n : this.nodes.values()) {
            if (n instanceof EphemeralNode) continue;
            existing.add(n.getNodeName());
            XmlFile xmlFile = new XmlFile(Jenkins.XSTREAM, new File(new File(nodesDir, n.getNodeName()), "config.xml"));
            xmlFile.write(n);
            SaveableListener.fireOnChange(this, xmlFile);
        }
        for (File forDeletion : nodesDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && !existing.contains(pathname.getName());
            }
        })) {
            Util.deleteRecursive(forDeletion);
        }
    }

    @CheckForNull
    public Node getNode(String name) {
        return name == null ? null : (Node)this.nodes.get(name);
    }

    public void load() throws IOException {
        File nodesDir = this.getNodesDir();
        File[] subdirs = nodesDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File child) {
                return child.isDirectory();
            }
        });
        final TreeMap<String, Node> newNodes = new TreeMap<String, Node>();
        if (subdirs != null) {
            for (File subdir : subdirs) {
                try {
                    XmlFile xmlFile = new XmlFile(Jenkins.XSTREAM, new File(subdir, "config.xml"));
                    if (!xmlFile.exists()) continue;
                    Node node = (Node)xmlFile.read();
                    newNodes.put(node.getNodeName(), node);
                }
                catch (IOException e) {
                    Logger.getLogger(Nodes.class.getName()).log(Level.WARNING, "could not load " + subdir, e);
                }
            }
        }
        Queue.withLock(new Runnable(){

            @Override
            public void run() {
                Iterator i = Nodes.this.nodes.entrySet().iterator();
                while (i.hasNext()) {
                    if (i.next().getValue() instanceof EphemeralNode) continue;
                    i.remove();
                }
                Nodes.this.nodes.putAll(newNodes);
                Nodes.this.jenkins.updateComputerList();
                Nodes.this.jenkins.trimLabels();
            }
        });
    }

    private File getNodesDir() throws IOException {
        File nodesDir = new File(this.jenkins.getRootDir(), "nodes");
        if (!nodesDir.isDirectory() && !nodesDir.mkdirs()) {
            throw new IOException(String.format("Could not mkdirs %s", nodesDir));
        }
        return nodesDir;
    }

    public boolean isLegacy() {
        return !new File(this.jenkins.getRootDir(), "nodes").isDirectory();
    }
}

