/*
 * Decompiled with CFR 0.152.
 */
package jenkins.slaves;

import hudson.Extension;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.Socket;
import jenkins.slaves.JnlpAgentReceiver;
import jenkins.slaves.JnlpSlaveAgentProtocol;
import jenkins.slaves.JnlpSlaveHandshake;
import org.jenkinsci.Symbol;
import org.jenkinsci.remoting.nio.NioChannelHub;

@Extension
@Symbol(value={"jnlp2"})
public class JnlpSlaveAgentProtocol2
extends JnlpSlaveAgentProtocol {
    @Override
    public String getName() {
        return "JNLP2-connect";
    }

    @Override
    public void handle(Socket socket) throws IOException, InterruptedException {
        new Handler2(this.hub.getHub(), socket).run();
    }

    protected static class Handler2
    extends JnlpSlaveAgentProtocol.Handler {
        @Deprecated
        public Handler2(Socket socket) throws IOException {
            super(socket);
        }

        public Handler2(NioChannelHub hub, Socket socket) throws IOException {
            super(hub, socket);
        }

        @Override
        protected void run() throws IOException, InterruptedException {
            this.request.load(new ByteArrayInputStream(this.in.readUTF().getBytes("UTF-8")));
            String nodeName = this.request.getProperty("Node-Name");
            for (JnlpAgentReceiver recv : JnlpAgentReceiver.all()) {
                try {
                    if (!recv.handle(nodeName, this)) continue;
                    return;
                }
                catch (AbstractMethodError e) {
                    if (!recv.handle(nodeName, new JnlpSlaveHandshake(this))) continue;
                    return;
                }
            }
            this.error("JNLP2-connect: rejected connection for node: " + nodeName);
        }
    }
}

