/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.solaris.libzfs;

import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import org.jvnet.solaris.libzfs.LibZFS;
import org.jvnet.solaris.libzfs.ZFSException;
import org.jvnet.solaris.libzfs.ZPoolStatus;
import org.jvnet.solaris.libzfs.jna.libzfs;
import org.jvnet.solaris.libzfs.jna.zpool_handle_t;
import org.jvnet.solaris.libzfs.jna.zpool_prop_t;

public final class ZFSPool {
    final LibZFS library;
    zpool_handle_t handle;
    private final String name;

    ZFSPool(LibZFS parent, zpool_handle_t handle) {
        this.library = parent;
        this.handle = handle;
        this.name = libzfs.LIBZFS.zpool_get_name(handle);
    }

    public String getName() {
        return this.name;
    }

    public String getProperty(zpool_prop_t prop) {
        Memory propbuf = new Memory(1024L);
        int ret = libzfs.LIBZFS.zpool_get_prop(this.handle, new NativeLong((long)prop.ordinal()), (Pointer)propbuf, new NativeLong(1024L), null);
        return ret != 0 ? null : propbuf.getString(0L);
    }

    public ZPoolStatus getStatus() {
        return ZPoolStatus.values()[libzfs.LIBZFS.zpool_get_status(this.handle, new PointerByReference())];
    }

    public long getSize() {
        return this.toSize(this.getProperty(zpool_prop_t.ZPOOL_PROP_SIZE));
    }

    public long getAvailableSize() {
        return this.toSize(this.getProperty(zpool_prop_t.ZPOOL_PROP_AVAILABLE));
    }

    public long getUsedSize() {
        return this.toSize(this.getProperty(zpool_prop_t.ZPOOL_PROP_USED));
    }

    private long toSize(String value) {
        value = value.toUpperCase();
        double d = Double.parseDouble(value.substring(0, value.length() - 1));
        long multiplier = 1L;
        switch (value.charAt(value.length() - 1)) {
            case 'P': {
                multiplier *= 1024L;
            }
            case 'T': {
                multiplier *= 1024L;
            }
            case 'G': {
                multiplier *= 1024L;
            }
            case 'M': {
                multiplier *= 1024L;
            }
            case 'K': {
                multiplier *= 1024L;
            }
        }
        if (multiplier == 1L) {
            return (long)d;
        }
        return (long)(d * 1024.0) * (multiplier / 1024L);
    }

    public void disableDatasets(boolean force) {
        this.check(libzfs.LIBZFS.zpool_disable_datasets(this.handle, force));
    }

    private void check(int r) {
        if (r != 0) {
            throw new ZFSException(this.library);
        }
    }

    public void export(boolean force, boolean hardForce) {
        this.disableDatasets(force);
        if (hardForce) {
            this.check(libzfs.LIBZFS.zpool_export_force(this.handle));
        } else {
            this.check(libzfs.LIBZFS.zpool_export(this.handle, force));
        }
    }

    public synchronized void dispose() {
        if (this.handle != null) {
            libzfs.LIBZFS.zpool_close(this.handle);
        }
        this.handle = null;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

