/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks;

import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.constants.DNSConstants;
import javax.jmdns.impl.tasks.DNSTask;

public class Responder
extends DNSTask {
    static Logger logger = Logger.getLogger(Responder.class.getName());
    private final DNSIncoming _in;
    private final boolean _unicast;

    public Responder(JmDNSImpl jmDNSImpl, DNSIncoming in, int port) {
        super(jmDNSImpl);
        this._in = in;
        this._unicast = port != DNSConstants.MDNS_PORT;
    }

    public String getName() {
        return "Responder(" + (this.getDns() != null ? this.getDns().getName() : "") + ")";
    }

    public String toString() {
        return super.toString() + " incomming: " + this._in;
    }

    public void start(Timer timer) {
        int delay;
        boolean iAmTheOnlyOne = true;
        for (DNSQuestion dNSQuestion : this._in.getQuestions()) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.getName() + "start() question=" + dNSQuestion);
            }
            if (iAmTheOnlyOne = dNSQuestion.iAmTheOnlyOne(this.getDns())) continue;
            break;
        }
        int n = delay = iAmTheOnlyOne && !this._in.isTruncated() ? 0 : 20 + JmDNSImpl.getRandom().nextInt(96) - this._in.elapseSinceArrival();
        if (delay < 0) {
            delay = 0;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.getName() + "start() Responder chosen delay=" + delay);
        }
        if (!this.getDns().isCanceling() && !this.getDns().isCanceled()) {
            timer.schedule((TimerTask)this, delay);
        }
    }

    public void run() {
        this.getDns().respondToQuery(this._in);
        HashSet<DNSQuestion> questions = new HashSet<DNSQuestion>();
        HashSet<DNSRecord> answers = new HashSet<DNSRecord>();
        if (this.getDns().isAnnounced()) {
            try {
                for (DNSQuestion dNSQuestion : this._in.getQuestions()) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(this.getName() + "run() JmDNS responding to: " + dNSQuestion);
                    }
                    if (this._unicast) {
                        questions.add(dNSQuestion);
                    }
                    dNSQuestion.addAnswers(this.getDns(), answers);
                }
                long now = System.currentTimeMillis();
                for (DNSRecord dNSRecord : this._in.getAnswers()) {
                    if (!dNSRecord.isStale(now)) continue;
                    answers.remove(dNSRecord);
                    if (!logger.isLoggable(Level.FINER)) continue;
                    logger.finer(this.getName() + "JmDNS Responder Known Answer Removed");
                }
                if (!answers.isEmpty()) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(this.getName() + "run() JmDNS responding");
                    }
                    DNSOutgoing out = new DNSOutgoing(33792, !this._unicast, this._in.getSenderUDPPayload());
                    out.setId(this._in.getId());
                    for (DNSQuestion question : questions) {
                        if (question == null) continue;
                        out = this.addQuestion(out, question);
                    }
                    for (DNSRecord answer : answers) {
                        if (answer == null) continue;
                        out = this.addAnswer(out, this._in, answer);
                    }
                    if (!out.isEmpty()) {
                        this.getDns().send(out);
                    }
                }
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, this.getName() + "run() exception ", e);
                this.getDns().close();
            }
        }
    }
}

