/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.IOException;
import java.util.Map;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import winstone.ConnectorFactory;
import winstone.cmdline.Option;

public class HttpConnectorFactory
implements ConnectorFactory {
    public boolean start(Map args, Server server) throws IOException {
        int listenPort = Option.HTTP_PORT.get(args);
        String listenAddress = Option.HTTP_LISTEN_ADDRESS.get(args);
        int keepAliveTimeout = Option.HTTP_KEEP_ALIVE_TIMEOUT.get(args);
        if (listenPort < 0) {
            return false;
        }
        ServerConnector connector = this.createConnector(server);
        connector.setPort(listenPort);
        connector.setHost(listenAddress);
        connector.setIdleTimeout(keepAliveTimeout);
        HttpConfiguration config = connector.getConnectionFactory(HttpConnectionFactory.class).getHttpConfiguration();
        config.addCustomizer(new ForwardedRequestCustomizer());
        config.setRequestHeaderSize(Option.REQUEST_HEADER_SIZE.get(args));
        server.addConnector(connector);
        return true;
    }

    protected ServerConnector createConnector(Server server) {
        return new ServerConnector(server);
    }
}

