/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.modules.slave_installer;

import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.remoting.Channel;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.modules.slave_installer.SlaveInstaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SlaveInstallerFactory
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(SlaveInstallerFactory.class.getName());

    public SlaveInstaller createIfApplicable(SlaveComputer c) throws IOException, InterruptedException {
        return this.createIfApplicable(c.getChannel());
    }

    public SlaveInstaller createIfApplicable(Channel c) throws IOException, InterruptedException {
        return null;
    }

    public static SlaveInstaller createFor(SlaveComputer c) throws InterruptedException {
        for (SlaveInstallerFactory f : SlaveInstallerFactory.all()) {
            try {
                SlaveInstaller si = f.createIfApplicable(c);
                if (si == null) continue;
                return si;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, f + " has failed on " + c, e);
            }
        }
        return null;
    }

    public static SlaveInstaller createFor(Channel c) throws InterruptedException {
        for (SlaveInstallerFactory f : SlaveInstallerFactory.all()) {
            try {
                SlaveInstaller si = f.createIfApplicable(c);
                if (si == null) continue;
                return si;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, f + " has failed on " + c.getName(), e);
            }
        }
        return null;
    }

    public static ExtensionList<SlaveInstallerFactory> all() {
        return Jenkins.getInstance().getExtensionList(SlaveInstallerFactory.class);
    }
}

