/*
 * Decompiled with CFR 0.152.
 */
package net.java.sezpoz.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import net.java.sezpoz.Indexable;
import net.java.sezpoz.impl.SerAnnConst;
import net.java.sezpoz.impl.SerAnnotatedElement;
import net.java.sezpoz.impl.SerEnumConst;
import net.java.sezpoz.impl.SerTypeConst;

@SupportedAnnotationTypes(value={"*"})
@SupportedOptions(value={"sezpoz.quiet"})
public class Indexer6
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Indexable.class)) {
            String error = this.verifyIndexable(element);
            if (error != null) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, error, element);
                continue;
            }
            Retention retention = element.getAnnotation(Retention.class);
            if (retention != null && retention.value() == RetentionPolicy.SOURCE) continue;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "should be marked @Retention(RetentionPolicy.SOURCE)", element);
        }
        HashMap<String, List<SerAnnotatedElement>> output = new HashMap<String, List<SerAnnotatedElement>>();
        HashMap<String, Collection<Element>> hashMap = new HashMap<String, Collection<Element>>();
        this.scan(annotations, hashMap, roundEnv, output);
        this.write(output, hashMap);
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    /*
     * WARNING - void declaration
     */
    private void scan(Set<? extends TypeElement> annotations, Map<String, Collection<Element>> originatingElementsByAnn, RoundEnvironment roundEnv, Map<String, List<SerAnnotatedElement>> output) {
        for (TypeElement typeElement : annotations) {
            AnnotationMirror indexable = null;
            for (AnnotationMirror annotationMirror : this.processingEnv.getElementUtils().getAllAnnotationMirrors(typeElement)) {
                if (!this.processingEnv.getElementUtils().getBinaryName((TypeElement)annotationMirror.getAnnotationType().asElement()).contentEquals(Indexable.class.getName())) continue;
                indexable = annotationMirror;
                break;
            }
            if (indexable == null) continue;
            String annName = this.processingEnv.getElementUtils().getBinaryName(typeElement).toString();
            Collection<Element> collection = originatingElementsByAnn.get(annName);
            if (collection == null) {
                ArrayList arrayList = new ArrayList();
                originatingElementsByAnn.put(annName, arrayList);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                void var14_22;
                void var9_13;
                AnnotationMirror marked = null;
                for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                    if (!this.processingEnv.getElementUtils().getBinaryName((TypeElement)annotationMirror.getAnnotationType().asElement()).contentEquals(annName)) continue;
                    marked = annotationMirror;
                    break;
                }
                if (marked == null) continue;
                String error = this.verify(element, indexable);
                if (error != null) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, error, element, marked);
                    continue;
                }
                var9_13.add(element);
                List<SerAnnotatedElement> list = output.get(annName);
                if (list == null) {
                    ArrayList arrayList = new ArrayList();
                    output.put(annName, arrayList);
                }
                SerAnnotatedElement ser = this.makeSerAnnotatedElement(element, typeElement);
                if (!Boolean.parseBoolean(this.processingEnv.getOptions().get("sezpoz.quiet"))) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, ser.className.replace('$', '.') + (ser.memberName != null ? "." + ser.memberName : "") + " indexed under " + annName.replace('$', '.'));
                }
                var14_22.add(ser);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Map<String, List<SerAnnotatedElement>> output, Map<String, Collection<Element>> originatingElementsByAnn) {
        for (Map.Entry<String, List<SerAnnotatedElement>> outputEntry : output.entrySet()) {
            String annName = outputEntry.getKey();
            try {
                List<SerAnnotatedElement> elements = outputEntry.getValue();
                try {
                    FileObject in = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/annotations/" + annName);
                    InputStream is = in.openInputStream();
                    try {
                        ObjectInputStream ois = new ObjectInputStream(is);
                        while (true) {
                            SerAnnotatedElement el;
                            try {
                                el = (SerAnnotatedElement)ois.readObject();
                            }
                            catch (ClassNotFoundException cnfe) {
                                throw new IOException(cnfe.toString());
                            }
                            if (el == null) {
                                break;
                            }
                            elements.add(el);
                        }
                    }
                    finally {
                        is.close();
                    }
                }
                catch (FileNotFoundException in) {
                    // empty catch block
                }
                FileObject out = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/annotations/" + annName, originatingElementsByAnn.get(annName).toArray(new Element[0]));
                OutputStream os = out.openOutputStream();
                try {
                    ObjectOutputStream oos = new ObjectOutputStream(os);
                    for (SerAnnotatedElement el : elements) {
                        oos.writeObject(el);
                    }
                    oos.writeObject(null);
                    oos.flush();
                }
                finally {
                    os.close();
                }
            }
            catch (IOException x) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, x.toString());
            }
        }
    }

    private SerAnnotatedElement makeSerAnnotatedElement(Element elt, TypeElement ann) {
        boolean isMethod;
        String memberName;
        String className;
        switch (elt.getKind()) {
            case CLASS: {
                className = this.processingEnv.getElementUtils().getBinaryName((TypeElement)elt).toString();
                memberName = null;
                isMethod = false;
                break;
            }
            case METHOD: {
                className = this.processingEnv.getElementUtils().getBinaryName((TypeElement)elt.getEnclosingElement()).toString();
                memberName = elt.getSimpleName().toString();
                isMethod = true;
                break;
            }
            case FIELD: {
                className = this.processingEnv.getElementUtils().getBinaryName((TypeElement)elt.getEnclosingElement()).toString();
                memberName = elt.getSimpleName().toString();
                isMethod = false;
                break;
            }
            default: {
                throw new AssertionError((Object)elt.getKind());
            }
        }
        return new SerAnnotatedElement(className, memberName, isMethod, this.translate(elt.getAnnotationMirrors(), ann));
    }

    private TreeMap<String, Object> translate(List<? extends AnnotationMirror> mirrors, TypeElement ann) {
        TreeMap<String, Object> values = new TreeMap<String, Object>();
        for (AnnotationMirror annotationMirror : mirrors) {
            if (!this.processingEnv.getTypeUtils().isSameType(annotationMirror.getAnnotationType(), ann.asType())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                values.put(entry.getKey().getSimpleName().toString(), this.translate(entry.getValue().getValue()));
            }
        }
        return values;
    }

    private Object translate(Object annval) {
        if (annval instanceof List) {
            List annvals = (List)annval;
            ArrayList<Object> values = new ArrayList<Object>(annvals.size());
            for (AnnotationValue v : annvals) {
                values.add(this.translate(v.getValue()));
            }
            return values;
        }
        if (annval instanceof TypeMirror) {
            return new SerTypeConst(this.processingEnv.getElementUtils().getBinaryName((TypeElement)this.processingEnv.getTypeUtils().asElement((TypeMirror)annval)).toString());
        }
        if (annval instanceof VariableElement) {
            VariableElement elt = (VariableElement)annval;
            return new SerEnumConst(this.processingEnv.getElementUtils().getBinaryName((TypeElement)elt.getEnclosingElement()).toString(), elt.getSimpleName().toString());
        }
        if (annval instanceof AnnotationMirror) {
            AnnotationMirror am = (AnnotationMirror)annval;
            TreeMap<String, Object> values = new TreeMap<String, Object>();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : am.getElementValues().entrySet()) {
                values.put(entry.getKey().getSimpleName().toString(), this.translate(entry.getValue().getValue()));
            }
            return new SerAnnConst(am.getAnnotationType().toString(), values);
        }
        return annval;
    }

    private String verify(Element registration, AnnotationMirror indexable) {
        TypeMirror thistype;
        if (!registration.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return "annotated elements must be public";
        }
        TypeMirror supertype = this.processingEnv.getElementUtils().getTypeElement("java.lang.Object").asType();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : indexable.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().contentEquals("type")) continue;
            supertype = (TypeMirror)entry.getValue().getValue();
        }
        switch (registration.getKind()) {
            case CLASS: {
                if (registration.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    return "annotated classes must not be abstract";
                }
                boolean hasDefaultCtor = false;
                for (ExecutableElement constructor : ElementFilter.constructorsIn(registration.getEnclosedElements())) {
                    if (!constructor.getModifiers().contains((Object)Modifier.PUBLIC) || !constructor.getParameters().isEmpty()) continue;
                    hasDefaultCtor = true;
                    break;
                }
                if (!hasDefaultCtor) {
                    return "annotated classes must have a public no-argument constructor";
                }
                Element enclosing = registration.getEnclosingElement();
                if (enclosing != null && enclosing.getKind() != ElementKind.PACKAGE && !registration.getModifiers().contains((Object)Modifier.STATIC)) {
                    return "annotated nested classes must be static";
                }
                thistype = registration.asType();
                break;
            }
            case METHOD: {
                if (!registration.getEnclosingElement().getModifiers().contains((Object)Modifier.PUBLIC)) {
                    return "annotated methods must be contained in a public class";
                }
                if (!registration.getModifiers().contains((Object)Modifier.STATIC)) {
                    return "annotated methods must be static";
                }
                if (!((ExecutableElement)registration).getParameters().isEmpty()) {
                    return "annotated methods must take no parameters";
                }
                thistype = ((ExecutableElement)registration).getReturnType();
                break;
            }
            case FIELD: {
                if (!registration.getEnclosingElement().getModifiers().contains((Object)Modifier.PUBLIC)) {
                    return "annotated fields must be contained in a public class";
                }
                if (!registration.getModifiers().contains((Object)Modifier.STATIC)) {
                    return "annotated fields must be static";
                }
                if (!registration.getModifiers().contains((Object)Modifier.FINAL)) {
                    return "annotated fields must be final";
                }
                thistype = ((VariableElement)registration).asType();
                break;
            }
            default: {
                return "annotations must be on classes, methods, or fields";
            }
        }
        if (!this.processingEnv.getTypeUtils().isAssignable(thistype, supertype)) {
            return "not assignable to " + supertype;
        }
        return null;
    }

    private String verifyIndexable(Element indexable) {
        if (indexable.getAnnotation(Inherited.class) != null) {
            return "cannot be @Inherited";
        }
        Target target = indexable.getAnnotation(Target.class);
        if (target == null) {
            return "must be marked with @Target";
        }
        if (target.value().length == 0) {
            return "must have at least one element type in @Target";
        }
        block3: for (ElementType type : target.value()) {
            switch (type) {
                case TYPE: 
                case METHOD: 
                case FIELD: {
                    continue block3;
                }
                default: {
                    return "should not be permitted on element type " + (Object)((Object)type);
                }
            }
        }
        return null;
    }
}

