/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.compression;

import com.jcraft.jzlib.GZIPOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.kohsuke.stapler.compression.FilterServletOutputStream;

public class CompressionServletResponse
extends HttpServletResponseWrapper {
    private ServletOutputStream stream;
    private PrintWriter writer;

    public CompressionServletResponse(HttpServletResponse response) {
        super(response);
    }

    public void setContentLength(int len) {
        if (this.stream != null) {
            return;
        }
        super.setContentLength(len);
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.stream != null) {
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.stream, this.getCharacterEncoding()));
            return this.writer;
        }
        return super.getWriter();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.stream != null) {
            return this.stream;
        }
        return super.getOutputStream();
    }

    public void activate() throws IOException {
        if (this.stream == null) {
            super.setHeader("Content-Encoding", "gzip");
            this.stream = new FilterServletOutputStream((OutputStream)new GZIPOutputStream((OutputStream)super.getOutputStream()));
        }
    }

    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
    }
}

