/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import com.ibm.icu.text.Collator;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleListValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.AbstractTransformer;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.BaseTemporalConverter;
import org.eclipse.jpt.jpa.core.context.TemporalType;
import org.eclipse.jpt.jpa.ui.details.JptJpaUiDetailsMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemporalTypeCombo
extends Pane<BaseTemporalConverter> {
    private Control combo;

    public TemporalTypeCombo(Pane<?> parentPane, PropertyValueModel<? extends BaseTemporalConverter> subjectModel, Composite parentComposite) {
        super(parentPane, subjectModel, parentComposite);
    }

    protected boolean addsComposite() {
        return false;
    }

    public Control getControl() {
        return this.combo;
    }

    protected void initializeLayout(Composite container) {
        this.combo = this.addCombo(container, this.buildTemporalTypeListHolder(), this.buildTemporalTypeHolder(), this.buildTemporalTypeConverter(), this.buildSubjectIsNotNullModel());
    }

    private ModifiablePropertyValueModel<TemporalType> buildTemporalTypeHolder() {
        return new PropertyAspectAdapter<BaseTemporalConverter, TemporalType>(this.getSubjectHolder(), new String[]{"temporalType"}){

            protected TemporalType buildValue_() {
                return ((BaseTemporalConverter)this.subject).getTemporalType();
            }

            protected void setValue_(TemporalType value) {
                ((BaseTemporalConverter)this.subject).setTemporalType(value);
            }
        };
    }

    private ListValueModel<TemporalType> buildTemporalTypeListHolder() {
        return new SimpleListValueModel(this.buildSortedTemporalTypeList());
    }

    private List<TemporalType> buildSortedTemporalTypeList() {
        return ListTools.sort((List)ListTools.list((Object[])TemporalType.values()), this.buildTemporalTypeComparator());
    }

    private Comparator<TemporalType> buildTemporalTypeComparator() {
        return new Comparator<TemporalType>(){

            @Override
            public int compare(TemporalType type1, TemporalType type2) {
                String displayString1 = TemporalTypeCombo.this.displayString(type1);
                String displayString2 = TemporalTypeCombo.this.displayString(type2);
                return Collator.getInstance().compare(displayString1, displayString2);
            }
        };
    }

    private Transformer<TemporalType, String> buildTemporalTypeConverter() {
        return new TemporalTypeLabelTransformer();
    }

    String displayString(TemporalType temporalType) {
        switch (temporalType) {
            case DATE: {
                return JptJpaUiDetailsMessages.TEMPORAL_TYPE_COMPOSITE_DATE;
            }
            case TIME: {
                return JptJpaUiDetailsMessages.TEMPORAL_TYPE_COMPOSITE_TIME;
            }
            case TIMESTAMP: {
                return JptJpaUiDetailsMessages.TEMPORAL_TYPE_COMPOSITE_TIMESTAMP;
            }
        }
        throw new IllegalStateException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TemporalTypeLabelTransformer
    extends AbstractTransformer<TemporalType, String> {
        TemporalTypeLabelTransformer() {
        }

        public String transform_(TemporalType temporalType) {
            return TemporalTypeCombo.this.displayString(temporalType);
        }
    }
}

