/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.io;

import java.io.Writer;

public class StringBuilderWriter
extends Writer {
    private StringBuilder sb;

    public StringBuilderWriter(StringBuilder sb) {
        if (sb == null) {
            throw new NullPointerException();
        }
        this.sb = sb;
        this.lock = sb;
    }

    public StringBuilderWriter(int initialSize) {
        this(new StringBuilder(initialSize));
    }

    public StringBuilderWriter() {
        this(new StringBuilder());
    }

    public void write(int c) {
        this.sb.append((char)c);
    }

    public void write(char[] cbuf, int off, int len) {
        if (len != 0) {
            this.sb.append(cbuf, off, len);
        }
    }

    public void write(String str) {
        this.sb.append(str);
    }

    public void write(String str, int off, int len) {
        this.sb.append(str, off, off + len);
    }

    public StringBuilder getBuilder() {
        return this.sb;
    }

    public void flush() {
    }

    public void close() {
    }

    public String toString() {
        return this.sb.toString();
    }
}

