/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.help.IContext;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.common.ui.internal.WorkbenchWindowTools;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WorkbenchTools {
    public static Display getDisplay() {
        IWorkbench wb = WorkbenchTools.getWorkbench();
        return wb == null ? null : wb.getDisplay();
    }

    public static Shell getActiveShell() {
        IWorkbenchWindow ww = WorkbenchTools.getActiveWindow();
        return ww == null ? null : ww.getShell();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow ww = WorkbenchTools.getActiveWindow();
        return ww == null ? null : ww.getActivePage();
    }

    public static IWorkbenchWindow getActiveWindow() {
        IWorkbench wb = WorkbenchTools.getWorkbench();
        return wb == null ? null : wb.getActiveWorkbenchWindow();
    }

    public static IWorkbench getWorkbench() {
        return PlatformUI.isWorkbenchRunning() ? PlatformUI.getWorkbench() : null;
    }

    public static IEditorDescriptor getDefaultEditor(IFile file) {
        return WorkbenchTools.getDefaultEditor(file.getName(), IDE.getContentType((IFile)file));
    }

    public static IEditorDescriptor getDefaultEditor(String fileName, IContentType contentType) {
        IWorkbench wb = WorkbenchTools.getWorkbench();
        return wb == null ? null : wb.getEditorRegistry().getDefaultEditor(fileName, contentType);
    }

    public static Image getSharedImage(String symbolicName) {
        IWorkbench wb = WorkbenchTools.getWorkbench();
        return wb == null ? null : wb.getSharedImages().getImage(symbolicName);
    }

    public static ImageDescriptor getSharedImageDescriptor(String symbolicName) {
        IWorkbench wb = WorkbenchTools.getWorkbench();
        return wb == null ? null : wb.getSharedImages().getImageDescriptor(symbolicName);
    }

    public static void setHelp(Control control, String contextID) {
        IWorkbench wb = WorkbenchTools.getWorkbench();
        if (wb != null) {
            wb.getHelpSystem().setHelp(control, contextID);
        }
    }

    public static void setHelp(IAction action, String contextID) {
        IWorkbench wb = WorkbenchTools.getWorkbench();
        if (wb != null) {
            wb.getHelpSystem().setHelp(action, contextID);
        }
    }

    public static void setHelp(Menu menu, String contextID) {
        IWorkbench wb = WorkbenchTools.getWorkbench();
        if (wb != null) {
            wb.getHelpSystem().setHelp(menu, contextID);
        }
    }

    public static void setHelp(MenuItem item, String contextID) {
        IWorkbench wb = WorkbenchTools.getWorkbench();
        if (wb != null) {
            wb.getHelpSystem().setHelp(item, contextID);
        }
    }

    public static void displayHelp() {
        IWorkbench wb = WorkbenchTools.getWorkbench();
        if (wb != null) {
            wb.getHelpSystem().displayHelp();
        }
    }

    public static void displayHelp(IContext context) {
        IWorkbench wb = WorkbenchTools.getWorkbench();
        if (wb != null) {
            wb.getHelpSystem().displayHelp(context);
        }
    }

    public static void displayHelp(String contextID) {
        IWorkbench wb = WorkbenchTools.getWorkbench();
        if (wb != null) {
            wb.getHelpSystem().displayHelp(contextID);
        }
    }

    public static void closeAllViews(String viewID) {
        IWorkbench wb = WorkbenchTools.getWorkbench();
        if (wb != null) {
            WorkbenchTools.closeAllViews(wb, viewID);
        }
    }

    public static void closeAllViews(IWorkbench workbench, String viewID) {
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            WorkbenchWindowTools.closeAllViews(window, viewID);
            ++n2;
        }
    }

    public static <A> A getAdapter(Class<A> adapterType) {
        IWorkbench wb = WorkbenchTools.getWorkbench();
        return (A)(wb == null ? null : PlatformTools.getAdapter((Object)wb, adapterType));
    }

    public static <A> A getService(Class<A> api) {
        IWorkbench wb = WorkbenchTools.getWorkbench();
        return (A)(wb == null ? null : wb.getService(api));
    }

    private WorkbenchTools() {
        throw new UnsupportedOperationException();
    }
}

