/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.view;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.filters.SystemFilterReference;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemContentsType;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.ISystemResourceSet;
import org.eclipse.rse.core.model.SystemMessageObject;
import org.eclipse.rse.core.model.SystemRemoteResourceSet;
import org.eclipse.rse.core.model.SystemWorkspaceResourceSet;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISystemDragDropAdapter;
import org.eclipse.rse.core.subsystems.RemoteChildrenContentsType;
import org.eclipse.rse.core.subsystems.SubSystem;
import org.eclipse.rse.files.ui.resources.SystemEditableRemoteFile;
import org.eclipse.rse.files.ui.resources.UniversalFileTransferUtility;
import org.eclipse.rse.internal.core.RSECoreMessages;
import org.eclipse.rse.internal.files.ui.FileResources;
import org.eclipse.rse.internal.files.ui.actions.SystemCompareFilesAction;
import org.eclipse.rse.internal.files.ui.actions.SystemCompareWithEditionAction;
import org.eclipse.rse.internal.files.ui.actions.SystemEditFilesAction;
import org.eclipse.rse.internal.files.ui.actions.SystemMoveRemoteFileAction;
import org.eclipse.rse.internal.files.ui.actions.SystemNewFileAction;
import org.eclipse.rse.internal.files.ui.actions.SystemNewFileFilterFromFolderAction;
import org.eclipse.rse.internal.files.ui.actions.SystemNewFolderAction;
import org.eclipse.rse.internal.files.ui.actions.SystemRemoteFileOpenWithMenu;
import org.eclipse.rse.internal.files.ui.actions.SystemReplaceWithEditionAction;
import org.eclipse.rse.internal.files.ui.actions.SystemSearchAction;
import org.eclipse.rse.internal.files.ui.resources.SystemRemoteEditManager;
import org.eclipse.rse.internal.files.ui.view.DownloadAndOpenJob;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.dialogs.CopyRunnable;
import org.eclipse.rse.internal.ui.view.SystemViewResources;
import org.eclipse.rse.internal.ui.view.search.SystemSearchTableView;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.StringCompare;
import org.eclipse.rse.services.clientserver.SystemSearchString;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.messages.CommonMessages;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.IFilePermissionsService;
import org.eclipse.rse.services.files.IHostFilePermissions;
import org.eclipse.rse.services.files.IHostFilePermissionsContainer;
import org.eclipse.rse.services.files.PendingHostFilePermissions;
import org.eclipse.rse.services.search.HostSearchResultSet;
import org.eclipse.rse.services.search.IHostSearchResultConfiguration;
import org.eclipse.rse.services.search.IHostSearchResultSet;
import org.eclipse.rse.subsystems.files.core.SystemIFileProperties;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystemConfiguration;
import org.eclipse.rse.subsystems.files.core.subsystems.IVirtualRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileEmpty;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileRoot;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteSearchResultsContentsType;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.actions.SystemCopyToClipboardAction;
import org.eclipse.rse.ui.actions.SystemPasteFromClipboardAction;
import org.eclipse.rse.ui.dialogs.SystemRenameSingleDialog;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.operations.SystemFetchOperation;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.rse.ui.view.IContextObject;
import org.eclipse.rse.ui.view.ISystemEditableRemoteObject;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemViewDropDestination;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class SystemViewRemoteFileAdapter
extends AbstractSystemViewAdapter
implements ISystemRemoteElementAdapter {
    private String xlatedSize = null;
    private String xlatedCompressedSize = null;
    private String xlatedExpandedSize = null;
    private static final Object[] EMPTY_LIST = new Object[0];
    private boolean filesOnly;
    private boolean foldersOnly;
    private SystemNewFileAction addNewFile;
    private SystemNewFolderAction addNewFolder;
    private SystemNewFileFilterFromFolderAction addNewFilter;
    private SystemMoveRemoteFileAction moveAction;
    private SystemCopyToClipboardAction copyClipboardAction;
    private SystemPasteFromClipboardAction pasteClipboardAction;
    private SystemCompareFilesAction compareFilesAction;
    private SystemCompareWithEditionAction compareEditionAction;
    private SystemReplaceWithEditionAction replaceEditionAction;
    private SystemSearchAction searchAction;
    private IEditorRegistry registry;
    private SystemRemoteFileOpenWithMenu openWithMenu;
    private boolean debug = false;
    private static PropertyDescriptor[] propertyDescriptorArray = null;
    private static PropertyDescriptor[] briefPropertyDescriptorArray = null;
    private static PropertyDescriptor[] uniquePropertyDescriptorArray = null;
    private static PropertyDescriptor[] uniqueArchiveDescriptorArray = null;
    private static PropertyDescriptor[] uniqueVirtualDescriptorArray = null;
    private static PropertyDescriptor[] archiveDescriptorArray = null;
    private static PropertyDescriptor[] virtualDescriptorArray = null;
    static final String _uploadMessage = FileResources.MSG_UPLOADING_PROGRESS;
    static final String _downloadMessage = FileResources.MSG_DOWNLOADING_PROGRESS;
    public HashMap _permissionsJobMap = new HashMap();

    public SystemViewRemoteFileAdapter() {
        this.xlatedSize = FileResources.RESID_PROPERTY_FILE_SIZE_VALUE;
        this.xlatedCompressedSize = FileResources.RESID_PROPERTY_VIRTUALFILE_COMPRESSEDSIZE_VALUE;
        this.xlatedExpandedSize = FileResources.RESID_PROPERTY_ARCHIVE_EXPANDEDSIZE_VALUE;
    }

    private IEditorRegistry getEditorRegistry() {
        IWorkbench workbench;
        if (this.registry == null && (workbench = PlatformUI.getWorkbench()) != null) {
            this.registry = workbench.getEditorRegistry();
        }
        return this.registry;
    }

    public SystemViewRemoteFileAdapter(boolean foldersOnly, boolean filesOnly) {
        this();
        this.foldersOnly = foldersOnly;
        this.filesOnly = filesOnly;
    }

    public void setFilterString(String filterString) {
        if (this.filesOnly && filterString != null && filterString.indexOf("/ns") == -1) {
            filterString = String.valueOf(filterString) + " /ns";
        } else if (this.foldersOnly && filterString != null && filterString.indexOf("/nf") == -1) {
            filterString = String.valueOf(filterString) + " /nf";
        }
        super.setFilterString(filterString);
    }

    public String getFilterString() {
        return super.getFilterString();
    }

    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup) {
        boolean elementType = false;
        boolean isArchive = false;
        boolean canRead = true;
        boolean supportsSearch = true;
        boolean supportsArchiveManagement = false;
        boolean offline = false;
        Object firstSelection = selection.getFirstElement();
        IRemoteFile firstFile = null;
        if (firstSelection == null || !(firstSelection instanceof IRemoteFile)) {
            return;
        }
        firstFile = (IRemoteFile)firstSelection;
        elementType = firstFile.isDirectory() || firstFile.isRoot();
        isArchive = firstFile.isArchive();
        canRead = firstFile.canRead();
        IRemoteFileSubSystem fileSubSystem = firstFile.getParentRemoteFileSubSystem();
        offline = fileSubSystem.isOffline();
        supportsSearch = fileSubSystem.getParentRemoteFileSubSystemConfiguration().supportsSearch();
        supportsArchiveManagement = fileSubSystem.getParentRemoteFileSubSystemConfiguration().supportsArchiveManagement();
        if (isArchive) {
            Iterator elements = selection.iterator();
            Object element = null;
            while (elements.hasNext()) {
                element = elements.next();
                IRemoteFile remoteObj = element;
                if (remoteObj.isArchive()) continue;
            }
        }
        if (elementType || isArchive && supportsArchiveManagement) {
            if (!this.foldersOnly) {
                if (this.addNewFile == null) {
                    this.addNewFile = new SystemNewFileAction(shell);
                }
                this.addNewFile.setEnabled(canRead && !offline);
                menu.add("group.new", (IAction)this.addNewFile);
            }
            if (!this.filesOnly) {
                if (this.addNewFolder == null) {
                    this.addNewFolder = new SystemNewFolderAction(shell);
                }
                this.addNewFolder.setEnabled(canRead && !offline);
                menu.add("group.new", (IAction)this.addNewFolder);
                if (this.addNewFilter == null) {
                    this.addNewFilter = new SystemNewFileFilterFromFolderAction(shell);
                }
                menu.appendToGroup("group.new", (IContributionItem)new Separator());
                menu.add("group.new", (IAction)this.addNewFilter);
            }
        } else {
            String label = SystemResources.ACTION_CASCADING_OPEN_LABEL;
            String tooltip = SystemResources.ACTION_CASCADING_OPEN_TOOLTIP;
            SystemEditFilesAction action = new SystemEditFilesAction(label, tooltip, shell);
            menu.add("group.open", (IAction)action);
            action.setEnabled(canRead && !offline);
            MenuManager submenu = new MenuManager(FileResources.ResourceNavigator_openWith, "group.openwith");
            if (this.openWithMenu == null) {
                this.openWithMenu = new SystemRemoteFileOpenWithMenu();
            }
            this.openWithMenu.updateSelection(selection);
            submenu.add((IContributionItem)this.openWithMenu);
            menu.getMenuManager().appendToGroup("group.openwith", (IContributionItem)submenu);
        }
        if (this.moveAction == null) {
            this.moveAction = new SystemMoveRemoteFileAction(shell);
        }
        if (this.pasteClipboardAction == null) {
            this.pasteClipboardAction = new SystemPasteFromClipboardAction(shell, null);
        }
        if (this.copyClipboardAction == null) {
            this.copyClipboardAction = new SystemCopyToClipboardAction(shell, null);
        }
        if (this.searchAction == null) {
            this.searchAction = new SystemSearchAction(shell);
        }
        if (this.compareFilesAction == null) {
            this.compareFilesAction = new SystemCompareFilesAction(shell);
        }
        if (this.compareEditionAction == null) {
            this.compareEditionAction = new SystemCompareWithEditionAction(shell);
        }
        if (this.replaceEditionAction == null) {
            this.replaceEditionAction = new SystemReplaceWithEditionAction(shell);
        }
        if (supportsSearch) {
            menu.add("group.search", (IAction)this.searchAction);
            this.searchAction.setEnabled(canRead && !offline);
        }
        if (!firstFile.isRoot()) {
            menu.add(menuGroup, (IAction)this.copyClipboardAction);
            this.copyClipboardAction.setEnabled(canRead && !offline);
            if (!elementType) {
                menu.add("group.comparewith", (IAction)this.compareFilesAction);
                menu.add("group.comparewith", (IAction)this.compareEditionAction);
                menu.add("group.replacewith", (IAction)this.replaceEditionAction);
                this.compareFilesAction.setEnabled(canRead && !offline);
                this.compareEditionAction.setEnabled(canRead && !offline);
                this.replaceEditionAction.setEnabled(canRead && !offline);
            }
        }
        if (elementType || isArchive && supportsArchiveManagement) {
            menu.add(menuGroup, (IAction)this.pasteClipboardAction);
            this.pasteClipboardAction.setEnabled(canRead && !offline);
        }
        if (!firstFile.isRoot()) {
            menu.add(menuGroup, (IAction)this.moveAction);
            this.moveAction.setEnabled(canRead && !offline);
        }
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        Object[] contents;
        AbstractTreeViewer atv;
        IRemoteFile file = (IRemoteFile)element;
        if (file.isFile() || file.isArchive()) {
            IFile localFile = this.getLocalResource(file);
            if (localFile != null) {
                ImageDescriptor image;
                IEditorDescriptor editorDesc = this.getEditorRegistry().getDefaultEditor(file.getName(), IDE.guessContentType((IFile)localFile));
                Class<IDE> clazz = IDE.class;
                try {
                    Class[] parmtypes = new Class[]{IEditorInput.class, IContentType.class, IEditorDescriptor.class};
                    Method method = clazz.getMethod("overrideDefaultEditorAssociation", parmtypes);
                    if (method != null) {
                        Object[] args = new Object[]{new FileEditorInput(localFile), IDE.guessContentType((IFile)localFile), editorDesc};
                        editorDesc = (IEditorDescriptor)method.invoke(null, args);
                    }
                }
                catch (Exception exception) {}
                if (editorDesc != null && (image = editorDesc.getImageDescriptor()) != null) {
                    return image;
                }
            }
            return this.getEditorRegistry().getImageDescriptor(file.getName());
        }
        boolean isOpen = false;
        if (this.getViewer() instanceof AbstractTreeViewer && !(isOpen = (atv = (AbstractTreeViewer)this.getViewer()).getExpandedState(element)) && (contents = file.getContents((ISystemContentsType)RemoteChildrenContentsType.getInstance())) != null && contents.length == 0) {
            isOpen = true;
        }
        if (file.isRoot()) {
            return RSEUIPlugin.getDefault().getImageDescriptor(isOpen ? "org.eclipse.rse.ui.systemrootdriveopenIcon" : "org.eclipse.rse.ui.systemrootdriveIcon");
        }
        if (isOpen) {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
        }
        return RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemfolderIcon");
    }

    private IFile getLocalResource(IRemoteFile remoteFile) {
        IFile file = null;
        if (remoteFile.getHost().getSystemType().isLocal()) {
            String absolutePath = remoteFile.getAbsolutePath();
            file = SystemViewRemoteFileAdapter.getProjectFileForLocation(absolutePath);
        }
        if (file == null) {
            file = (IFile)UniversalFileTransferUtility.getTempFileFor(remoteFile);
        }
        return file;
    }

    public String getText(Object element) {
        return this.getName(element);
    }

    public String getAlternateText(Object element) {
        return ((IRemoteFile)element).getLabel();
    }

    public String getName(Object element) {
        return ((IRemoteFile)element).getName();
    }

    public String getType(Object element) {
        IRemoteFile file = (IRemoteFile)element;
        if (file.isRoot()) {
            return SystemViewResources.RESID_PROPERTY_FILE_TYPE_ROOT_VALUE;
        }
        if (file.isDirectory()) {
            return SystemViewResources.RESID_PROPERTY_FILE_TYPE_FOLDER_VALUE;
        }
        return SystemViewResources.RESID_PROPERTY_FILE_TYPE_FILE_VALUE;
    }

    public String getStatusLineText(Object element) {
        return String.valueOf(this.getType(element)) + ": " + this.getAbsoluteName(element);
    }

    public boolean exists(Object element) {
        IRemoteFile file = (IRemoteFile)element;
        if (file != null) {
            return file.exists();
        }
        return false;
    }

    public Object getParent(Object element) {
        IRemoteFile file = (IRemoteFile)element;
        IRemoteFile parent = file.getParentRemoteFile();
        if (parent != null && parent.getAbsolutePath().equals(file.getAbsolutePath())) {
            parent = null;
        }
        return parent;
    }

    public Object[] getChildren(IAdaptable element, IProgressMonitor monitor) {
        return this.internalGetChildren(element, null, monitor);
    }

    public Object[] getChildren(IContextObject context, IProgressMonitor monitor) {
        return this.internalGetChildren(context.getModelObject(), context.getFilterReference(), monitor);
    }

    private Object[] internalGetChildren(IAdaptable element, ISystemFilterReference filterReference, IProgressMonitor monitor) {
        boolean hasChildren;
        IRemoteFile cachedFile;
        IRemoteFile file = (IRemoteFile)element;
        if (file instanceof RemoteFileEmpty) {
            return EMPTY_LIST;
        }
        if (file instanceof RemoteFileRoot) {
            return ((RemoteFileRoot)file).getRootFiles();
        }
        IRemoteFileSubSystem ss = file.getParentRemoteFileSubSystem();
        IRemoteFile originalFile = file;
        if (ss instanceof RemoteFileSubSystem && (cachedFile = ((RemoteFileSubSystem)ss).getCachedRemoteFile(file.getAbsolutePath())) != null && cachedFile != originalFile) {
            file = cachedFile;
            if (originalFile.isStale()) {
                file.markStale(true);
            }
        }
        String filter = null;
        if (filterReference != null) {
            ISystemFilter filterObject = filterReference.getReferencedFilter();
            if (filterObject.getFilterStringCount() > 0) {
                String separator;
                String filterString = filterObject.getFilterStrings()[0];
                int sepIndex = filterString.lastIndexOf(separator = PathUtility.getSeparator((String)filterString));
                filter = sepIndex >= 0 ? filterString.substring(sepIndex + 1) : filterString;
            }
        } else {
            String filterString = this.getFilterString();
            filter = this.foldersOnly ? (filterString == null ? "* /nf" : filterString) : (this.filesOnly ? (filterString == null ? "* /ns" : filterString) : (filterString == null ? "*" : filterString));
        }
        Object[] children = null;
        Viewer v = this.getViewer();
        if (v != null && v instanceof SystemSearchTableView) {
            SystemSearchTableView view = (SystemSearchTableView)v;
            Iterator iter = view.getResultSet().getSearchConfigurations();
            boolean hasSearchResults = false;
            while (iter.hasNext() && !hasSearchResults) {
                IHostSearchResultConfiguration config = (IHostSearchResultConfiguration)iter.next();
                String searchString = config.getSearchString().getTextString();
                hasSearchResults = file.hasContents((ISystemContentsType)RemoteSearchResultsContentsType.getInstance(), searchString);
                if (!hasSearchResults) continue;
                children = file.getContents((ISystemContentsType)RemoteSearchResultsContentsType.getInstance(), searchString);
                return children;
            }
        }
        if ((hasChildren = file.hasContents((ISystemContentsType)RemoteChildrenContentsType.getInstance(), filter)) && !file.isStale()) {
            children = file.getContents((ISystemContentsType)RemoteChildrenContentsType.getInstance(), filter);
            children = this.filterChildren(children);
        } else {
            try {
                children = monitor != null ? ss.resolveFilterString((Object)file, filter, monitor) : ss.resolveFilterString((Object)file, filter, (IProgressMonitor)new NullProgressMonitor());
                if (children == null || children.length == 0) {
                    children = EMPTY_LIST;
                } else if (children.length != 1 || !(children[0] instanceof SystemMessageObject)) {
                    children = this.filterChildren(children);
                }
            }
            catch (InterruptedException interruptedException) {
                children = new SystemMessageObject[1];
                SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEG1067", 8, CommonMessages.MSG_EXPAND_CANCELLED);
                children[0] = new SystemMessageObject((SystemMessage)msg, 1, (Object)element);
            }
            catch (Exception exc) {
                children = new SystemMessageObject[1];
                SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEG1098", 4, CommonMessages.MSG_EXPAND_FAILED);
                children[0] = new SystemMessageObject((SystemMessage)msg, 0, (Object)element);
                SystemBasePlugin.logError((String)"Exception resolving file filter strings", (Throwable)exc);
            }
        }
        file.markStale(false);
        if (originalFile != null && originalFile != file) {
            originalFile.markStale(false);
        }
        return children;
    }

    private Object[] filterChildren(Object[] children) {
        boolean showHidden = RSEUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.rse.subsystems.files.core.preferences.showhidden");
        if (showHidden) {
            return children;
        }
        ArrayList<IRemoteFile> results = new ArrayList<IRemoteFile>(children.length);
        int i = 0;
        while (i < children.length) {
            IRemoteFile remoteFile;
            if (children[i] instanceof IRemoteFile && !(remoteFile = (IRemoteFile)children[i]).isHidden()) {
                results.add(remoteFile);
            }
            ++i;
        }
        return results.toArray();
    }

    public boolean hasChildren(IContextObject element) {
        return this.internalHasChildren(element.getModelObject(), element.getFilterReference());
    }

    public boolean hasChildren(IAdaptable element) {
        return this.internalHasChildren(element, null);
    }

    public boolean internalHasChildren(IAdaptable element, ISystemFilterReference filterReference) {
        String separator;
        String filterString;
        int sepIndex;
        ISystemFilter filterObject;
        IRemoteFile cachedFile;
        IRemoteFile file = (IRemoteFile)element;
        IRemoteFileSubSystem ss = file.getParentRemoteFileSubSystem();
        IRemoteFile originalFile = file;
        if (ss instanceof RemoteFileSubSystem && (cachedFile = ((RemoteFileSubSystem)ss).getCachedRemoteFile(file.getAbsolutePath())) != null && cachedFile != originalFile) {
            file = cachedFile;
            if (originalFile.isStale()) {
                file.markStale(true);
            }
        }
        if (!file.exists()) {
            return false;
        }
        boolean supportsArchiveManagement = file.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemConfiguration().supportsArchiveManagement();
        boolean hasChildren = false;
        String filter = "*";
        if (filterReference != null && (filterObject = filterReference.getReferencedFilter()).getFilterStringCount() > 0 && (sepIndex = (filterString = filterObject.getFilterStrings()[0]).lastIndexOf(separator = PathUtility.getSeparator((String)filterString))) > 0) {
            filter = filterString.substring(sepIndex + 1);
        }
        if (file instanceof IVirtualRemoteFile) {
            hasChildren = ((IVirtualRemoteFile)file).isVirtualFolder();
        } else {
            boolean bl = hasChildren = !file.isFile() || file.isArchive() && supportsArchiveManagement;
        }
        if (!hasChildren) {
            Viewer v = this.getViewer();
            if (v != null && v instanceof SystemSearchTableView) {
                SystemSearchTableView view = (SystemSearchTableView)v;
                Iterator iter = view.getResultSet().getSearchConfigurations();
                while (iter.hasNext() && !hasChildren) {
                    IHostSearchResultConfiguration config = (IHostSearchResultConfiguration)iter.next();
                    String searchString = config.getSearchString().getTextString();
                    hasChildren = file.hasContents((ISystemContentsType)RemoteSearchResultsContentsType.getInstance(), searchString);
                }
            } else {
                hasChildren = file.hasContents((ISystemContentsType)RemoteChildrenContentsType.getInstance(), filter);
            }
        } else {
            hasChildren = file.hasContents((ISystemContentsType)RemoteChildrenContentsType.getInstance(), filter);
            if (!hasChildren && file.isStale() && (file.isDirectory() || file.isArchive())) {
                hasChildren = true;
            }
        }
        return hasChildren;
    }

    public IPropertyDescriptor[] getUniquePropertyDescriptors() {
        IRemoteFile file = null;
        if (this.propertySourceInput instanceof IRemoteFile) {
            boolean isRegular;
            file = (IRemoteFile)this.propertySourceInput;
            boolean supportsArchiveManagement = file.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemConfiguration().supportsArchiveManagement();
            boolean isArchive = file.isArchive() && supportsArchiveManagement;
            boolean isVirtual = file instanceof IVirtualRemoteFile && supportsArchiveManagement;
            boolean bl = isRegular = !isArchive && !isVirtual;
            if (isRegular && uniquePropertyDescriptorArray == null || isArchive && uniqueArchiveDescriptorArray == null || isVirtual && uniqueVirtualDescriptorArray == null) {
                int nbrOfArchiveProperties = 2;
                int nbrOfVirtualProperties = 4;
                int nbrOfProperties = 8;
                if (isVirtual) {
                    nbrOfProperties += nbrOfVirtualProperties;
                } else if (isArchive) {
                    nbrOfProperties += nbrOfArchiveProperties;
                }
                if (isRegular) {
                    uniquePropertyDescriptorArray = new PropertyDescriptor[nbrOfProperties];
                } else if (isVirtual) {
                    uniqueVirtualDescriptorArray = new PropertyDescriptor[nbrOfProperties];
                } else if (isArchive) {
                    uniqueArchiveDescriptorArray = new PropertyDescriptor[nbrOfProperties];
                }
                int i = -1;
                if (isRegular) {
                    SystemViewRemoteFileAdapter.uniquePropertyDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.classification", (String)FileResources.RESID_PROPERTY_FILE_CLASSIFICATION_LABEL, (String)FileResources.RESID_PROPERTY_FILE_CLASSIFICATION_TOOLTIP);
                } else if (isVirtual) {
                    SystemViewRemoteFileAdapter.uniqueVirtualDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.classification", (String)FileResources.RESID_PROPERTY_FILE_CLASSIFICATION_LABEL, (String)FileResources.RESID_PROPERTY_FILE_CLASSIFICATION_TOOLTIP);
                } else if (isArchive) {
                    SystemViewRemoteFileAdapter.uniqueArchiveDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.classification", (String)FileResources.RESID_PROPERTY_FILE_CLASSIFICATION_LABEL, (String)FileResources.RESID_PROPERTY_FILE_CLASSIFICATION_TOOLTIP);
                }
                if (isRegular) {
                    SystemViewRemoteFileAdapter.uniquePropertyDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.lastmodified", (String)FileResources.RESID_PROPERTY_FILE_LASTMODIFIED_LABEL, (String)FileResources.RESID_PROPERTY_FILE_LASTMODIFIED_TOOLTIP);
                } else if (isVirtual) {
                    SystemViewRemoteFileAdapter.uniqueVirtualDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.lastmodified", (String)FileResources.RESID_PROPERTY_FILE_LASTMODIFIED_LABEL, (String)FileResources.RESID_PROPERTY_FILE_LASTMODIFIED_TOOLTIP);
                } else if (isArchive) {
                    SystemViewRemoteFileAdapter.uniqueArchiveDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.lastmodified", (String)FileResources.RESID_PROPERTY_FILE_LASTMODIFIED_LABEL, (String)FileResources.RESID_PROPERTY_FILE_LASTMODIFIED_TOOLTIP);
                }
                if (isRegular) {
                    SystemViewRemoteFileAdapter.uniquePropertyDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.size", (String)FileResources.RESID_PROPERTY_FILE_SIZE_LABEL, (String)FileResources.RESID_PROPERTY_FILE_SIZE_TOOLTIP);
                } else if (isVirtual) {
                    SystemViewRemoteFileAdapter.uniqueVirtualDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.size", (String)FileResources.RESID_PROPERTY_FILE_SIZE_LABEL, (String)FileResources.RESID_PROPERTY_FILE_SIZE_TOOLTIP);
                } else if (isArchive) {
                    SystemViewRemoteFileAdapter.uniqueArchiveDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.size", (String)FileResources.RESID_PROPERTY_FILE_SIZE_LABEL, (String)FileResources.RESID_PROPERTY_FILE_SIZE_TOOLTIP);
                }
                if (isRegular) {
                    SystemViewRemoteFileAdapter.uniquePropertyDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.canonicalpath", (String)FileResources.RESID_PROPERTY_FILE_CANONICAL_PATH_LABEL, (String)FileResources.RESID_PROPERTY_FILE_CANONICAL_PATH_TOOLTIP);
                } else if (isVirtual) {
                    SystemViewRemoteFileAdapter.uniqueVirtualDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.canonicalpath", (String)FileResources.RESID_PROPERTY_FILE_CANONICAL_PATH_LABEL, (String)FileResources.RESID_PROPERTY_FILE_CANONICAL_PATH_TOOLTIP);
                } else if (isArchive) {
                    SystemViewRemoteFileAdapter.uniqueArchiveDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.canonicalpath", (String)FileResources.RESID_PROPERTY_FILE_CANONICAL_PATH_LABEL, (String)FileResources.RESID_PROPERTY_FILE_CANONICAL_PATH_TOOLTIP);
                }
                if (isRegular) {
                    SystemViewRemoteFileAdapter.uniquePropertyDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.extension", (String)FileResources.RESID_PROPERTY_FILE_EXTENSION_LABEL, (String)FileResources.RESID_PROPERTY_FILE_EXTENSION_TOOLTIP);
                } else if (isVirtual) {
                    SystemViewRemoteFileAdapter.uniqueVirtualDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.extension", (String)FileResources.RESID_PROPERTY_FILE_EXTENSION_LABEL, (String)FileResources.RESID_PROPERTY_FILE_EXTENSION_TOOLTIP);
                } else if (isArchive) {
                    SystemViewRemoteFileAdapter.uniqueArchiveDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.extension", (String)FileResources.RESID_PROPERTY_FILE_EXTENSION_LABEL, (String)FileResources.RESID_PROPERTY_FILE_EXTENSION_TOOLTIP);
                }
                if (isRegular) {
                    SystemViewRemoteFileAdapter.uniquePropertyDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.permissions", (String)FileResources.RESID_PROPERTY_FILE_PERMISSIONS_LABEL, (String)FileResources.RESID_PROPERTY_FILE_PERMISSIONS_TOOLTIP);
                } else if (isVirtual) {
                    SystemViewRemoteFileAdapter.uniqueVirtualDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.permissions", (String)FileResources.RESID_PROPERTY_FILE_PERMISSIONS_LABEL, (String)FileResources.RESID_PROPERTY_FILE_PERMISSIONS_TOOLTIP);
                } else if (isArchive) {
                    SystemViewRemoteFileAdapter.uniqueArchiveDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.permissions", (String)FileResources.RESID_PROPERTY_FILE_PERMISSIONS_LABEL, (String)FileResources.RESID_PROPERTY_FILE_PERMISSIONS_TOOLTIP);
                }
                if (isRegular) {
                    SystemViewRemoteFileAdapter.uniquePropertyDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.owner", (String)FileResources.RESID_PROPERTY_FILE_OWNER_LABEL, (String)FileResources.RESID_PROPERTY_FILE_OWNER_TOOLTIP);
                } else if (isVirtual) {
                    SystemViewRemoteFileAdapter.uniqueVirtualDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.owner", (String)FileResources.RESID_PROPERTY_FILE_OWNER_LABEL, (String)FileResources.RESID_PROPERTY_FILE_OWNER_TOOLTIP);
                } else if (isArchive) {
                    SystemViewRemoteFileAdapter.uniqueArchiveDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.owner", (String)FileResources.RESID_PROPERTY_FILE_OWNER_LABEL, (String)FileResources.RESID_PROPERTY_FILE_OWNER_TOOLTIP);
                }
                if (isRegular) {
                    SystemViewRemoteFileAdapter.uniquePropertyDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.group", (String)FileResources.RESID_PROPERTY_FILE_GROUP_LABEL, (String)FileResources.RESID_PROPERTY_FILE_GROUP_TOOLTIP);
                } else if (isVirtual) {
                    SystemViewRemoteFileAdapter.uniqueVirtualDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.group", (String)FileResources.RESID_PROPERTY_FILE_GROUP_LABEL, (String)FileResources.RESID_PROPERTY_FILE_GROUP_TOOLTIP);
                } else if (isArchive) {
                    SystemViewRemoteFileAdapter.uniqueArchiveDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.group", (String)FileResources.RESID_PROPERTY_FILE_GROUP_LABEL, (String)FileResources.RESID_PROPERTY_FILE_GROUP_TOOLTIP);
                }
                if (isVirtual) {
                    SystemViewRemoteFileAdapter.uniqueVirtualDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.virtual.compressedsize", (String)FileResources.RESID_PROPERTY_VIRTUALFILE_COMPRESSEDSIZE_LABEL, (String)FileResources.RESID_PROPERTY_VIRTUALFILE_COMPRESSEDSIZE_DESCRIPTION);
                    SystemViewRemoteFileAdapter.uniqueVirtualDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.virtual.compressionratio", (String)FileResources.RESID_PROPERTY_VIRTUALFILE_COMPRESSIONRATIO_LABEL, (String)FileResources.RESID_PROPERTY_VIRTUALFILE_COMPRESSIONRATIO_DESCRIPTION);
                    SystemViewRemoteFileAdapter.uniqueVirtualDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.virtual.compressionmethod", (String)FileResources.RESID_PROPERTY_VIRTUALFILE_COMPRESSIONMETHOD_LABEL, (String)FileResources.RESID_PROPERTY_VIRTUALFILE_COMPRESSIONMETHOD_DESCRIPTION);
                    SystemViewRemoteFileAdapter.uniqueVirtualDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.virtual.comment", (String)FileResources.RESID_PROPERTY_VIRTUALFILE_COMMENT_LABEL, (String)FileResources.RESID_PROPERTY_VIRTUALFILE_COMMENT_DESCRIPTION);
                } else if (isArchive) {
                    SystemViewRemoteFileAdapter.uniqueArchiveDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.archive.expandedsize", (String)FileResources.RESID_PROPERTY_ARCHIVE_EXPANDEDSIZE_LABEL, (String)FileResources.RESID_PROPERTY_ARCHIVE_EXPANDEDSIZE_DESCRIPTION);
                    SystemViewRemoteFileAdapter.uniqueArchiveDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.archive.comment", (String)FileResources.RESID_PROPERTY_ARCHIVE_COMMENT_LABEL, (String)FileResources.RESID_PROPERTY_ARCHIVE_COMMENT_DESCRIPTION);
                }
            }
            if (isRegular) {
                return uniquePropertyDescriptorArray;
            }
            if (isVirtual) {
                return uniqueVirtualDescriptorArray;
            }
            if (isArchive) {
                return uniqueArchiveDescriptorArray;
            }
            return uniquePropertyDescriptorArray;
        }
        return uniquePropertyDescriptorArray;
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        boolean isRegular;
        IRemoteFile file = null;
        if (this.propertySourceInput instanceof IRemoteFile) {
            file = (IRemoteFile)this.propertySourceInput;
        }
        boolean isArchive = false;
        boolean isVirtual = file != null && file instanceof IVirtualRemoteFile;
        boolean bl = isRegular = !isArchive && !isVirtual;
        if (isRegular && propertyDescriptorArray == null || isArchive && archiveDescriptorArray == null || isVirtual && virtualDescriptorArray == null) {
            int nbrOfArchiveProperties = 2;
            int nbrOfVirtualProperties = 4;
            int nbrOfProperties = 12;
            int nbrOfBriefProperties = 2;
            if (this.debug) {
                nbrOfProperties += 7;
            }
            if (isVirtual) {
                nbrOfProperties += nbrOfVirtualProperties;
            } else if (isArchive) {
                nbrOfProperties += nbrOfArchiveProperties;
            }
            if (isRegular) {
                propertyDescriptorArray = new PropertyDescriptor[nbrOfProperties];
            } else if (isVirtual) {
                virtualDescriptorArray = new PropertyDescriptor[nbrOfProperties];
            } else if (isArchive) {
                archiveDescriptorArray = new PropertyDescriptor[nbrOfProperties];
            }
            briefPropertyDescriptorArray = new PropertyDescriptor[nbrOfBriefProperties];
            int idx = -1;
            int briefIdx = idx++;
            if (isRegular) {
                SystemViewRemoteFileAdapter.propertyDescriptorArray[idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.path", (String)SystemViewResources.RESID_PROPERTY_FILE_PATH_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_PATH_TOOLTIP);
            } else if (isVirtual) {
                SystemViewRemoteFileAdapter.virtualDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.path", (String)SystemViewResources.RESID_PROPERTY_FILE_PATH_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_PATH_TOOLTIP);
            } else if (isArchive) {
                SystemViewRemoteFileAdapter.archiveDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.path", (String)SystemViewResources.RESID_PROPERTY_FILE_PATH_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_PATH_TOOLTIP);
            }
            SystemViewRemoteFileAdapter.briefPropertyDescriptorArray[++briefIdx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.path", (String)SystemViewResources.RESID_PROPERTY_FILE_PATH_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_PATH_TOOLTIP);
            if (isRegular) {
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.filterString", (String)SystemViewResources.RESID_PROPERTY_FILTERSTRING_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILTERSTRING_TOOLTIP);
            } else if (isVirtual) {
                SystemViewRemoteFileAdapter.virtualDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.filterString", (String)SystemViewResources.RESID_PROPERTY_FILTERSTRING_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILTERSTRING_TOOLTIP);
            } else if (isArchive) {
                SystemViewRemoteFileAdapter.archiveDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.filterString", (String)SystemViewResources.RESID_PROPERTY_FILTERSTRING_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILTERSTRING_TOOLTIP);
            }
            SystemViewRemoteFileAdapter.briefPropertyDescriptorArray[++briefIdx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.filterString", (String)SystemViewResources.RESID_PROPERTY_FILTERSTRING_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILTERSTRING_TOOLTIP);
            if (isRegular) {
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.canonicalpath", (String)FileResources.RESID_PROPERTY_FILE_CANONICAL_PATH_LABEL, (String)FileResources.RESID_PROPERTY_FILE_CANONICAL_PATH_TOOLTIP);
            } else if (isVirtual) {
                SystemViewRemoteFileAdapter.virtualDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.canonicalpath", (String)FileResources.RESID_PROPERTY_FILE_CANONICAL_PATH_LABEL, (String)FileResources.RESID_PROPERTY_FILE_CANONICAL_PATH_TOOLTIP);
            } else if (isArchive) {
                SystemViewRemoteFileAdapter.archiveDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.canonicalpath", (String)FileResources.RESID_PROPERTY_FILE_CANONICAL_PATH_LABEL, (String)FileResources.RESID_PROPERTY_FILE_CANONICAL_PATH_TOOLTIP);
            }
            if (isRegular) {
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.lastmodified", (String)FileResources.RESID_PROPERTY_FILE_LASTMODIFIED_LABEL, (String)FileResources.RESID_PROPERTY_FILE_LASTMODIFIED_TOOLTIP);
            } else if (isVirtual) {
                SystemViewRemoteFileAdapter.virtualDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.lastmodified", (String)FileResources.RESID_PROPERTY_FILE_LASTMODIFIED_LABEL, (String)FileResources.RESID_PROPERTY_FILE_LASTMODIFIED_TOOLTIP);
            } else if (isArchive) {
                SystemViewRemoteFileAdapter.archiveDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.lastmodified", (String)FileResources.RESID_PROPERTY_FILE_LASTMODIFIED_LABEL, (String)FileResources.RESID_PROPERTY_FILE_LASTMODIFIED_TOOLTIP);
            }
            if (isRegular) {
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.size", (String)FileResources.RESID_PROPERTY_FILE_SIZE_LABEL, (String)FileResources.RESID_PROPERTY_FILE_SIZE_TOOLTIP);
            } else if (isVirtual) {
                SystemViewRemoteFileAdapter.virtualDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.size", (String)FileResources.RESID_PROPERTY_FILE_SIZE_LABEL, (String)FileResources.RESID_PROPERTY_FILE_SIZE_TOOLTIP);
            } else if (isArchive) {
                SystemViewRemoteFileAdapter.archiveDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.size", (String)FileResources.RESID_PROPERTY_FILE_SIZE_LABEL, (String)FileResources.RESID_PROPERTY_FILE_SIZE_TOOLTIP);
            }
            if (isRegular) {
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.classification", (String)FileResources.RESID_PROPERTY_FILE_CLASSIFICATION_LABEL, (String)FileResources.RESID_PROPERTY_FILE_CLASSIFICATION_TOOLTIP);
            } else if (isVirtual) {
                SystemViewRemoteFileAdapter.virtualDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.classification", (String)FileResources.RESID_PROPERTY_FILE_CLASSIFICATION_LABEL, (String)FileResources.RESID_PROPERTY_FILE_CLASSIFICATION_TOOLTIP);
            } else if (isArchive) {
                SystemViewRemoteFileAdapter.archiveDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.classification", (String)FileResources.RESID_PROPERTY_FILE_CLASSIFICATION_LABEL, (String)FileResources.RESID_PROPERTY_FILE_CLASSIFICATION_TOOLTIP);
            }
            if (isRegular) {
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.readonly", (String)FileResources.RESID_PROPERTY_FILE_READONLY_LABEL, (String)FileResources.RESID_PROPERTY_FILE_READONLY_TOOLTIP);
            } else if (isVirtual) {
                SystemViewRemoteFileAdapter.virtualDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.readonly", (String)FileResources.RESID_PROPERTY_FILE_READONLY_LABEL, (String)FileResources.RESID_PROPERTY_FILE_READONLY_TOOLTIP);
            } else if (isArchive) {
                SystemViewRemoteFileAdapter.archiveDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.readonly", (String)FileResources.RESID_PROPERTY_FILE_READONLY_LABEL, (String)FileResources.RESID_PROPERTY_FILE_READONLY_TOOLTIP);
            }
            if (isRegular) {
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.hidden", (String)FileResources.RESID_PROPERTY_FILE_HIDDEN_LABEL, (String)FileResources.RESID_PROPERTY_FILE_HIDDEN_TOOLTIP);
            } else if (isVirtual) {
                SystemViewRemoteFileAdapter.virtualDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.hidden", (String)FileResources.RESID_PROPERTY_FILE_HIDDEN_LABEL, (String)FileResources.RESID_PROPERTY_FILE_HIDDEN_TOOLTIP);
            } else if (isArchive) {
                SystemViewRemoteFileAdapter.archiveDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.hidden", (String)FileResources.RESID_PROPERTY_FILE_HIDDEN_LABEL, (String)FileResources.RESID_PROPERTY_FILE_HIDDEN_TOOLTIP);
            }
            if (isRegular) {
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.extension", (String)FileResources.RESID_PROPERTY_FILE_EXTENSION_LABEL, (String)FileResources.RESID_PROPERTY_FILE_EXTENSION_TOOLTIP);
            } else if (isVirtual) {
                SystemViewRemoteFileAdapter.virtualDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.extension", (String)FileResources.RESID_PROPERTY_FILE_EXTENSION_LABEL, (String)FileResources.RESID_PROPERTY_FILE_EXTENSION_TOOLTIP);
            } else if (isArchive) {
                SystemViewRemoteFileAdapter.archiveDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.extension", (String)FileResources.RESID_PROPERTY_FILE_EXTENSION_LABEL, (String)FileResources.RESID_PROPERTY_FILE_EXTENSION_TOOLTIP);
            }
            if (isRegular) {
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.permissions", (String)FileResources.RESID_PROPERTY_FILE_PERMISSIONS_LABEL, (String)FileResources.RESID_PROPERTY_FILE_PERMISSIONS_TOOLTIP);
            } else if (isVirtual) {
                SystemViewRemoteFileAdapter.virtualDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.permissions", (String)FileResources.RESID_PROPERTY_FILE_PERMISSIONS_LABEL, (String)FileResources.RESID_PROPERTY_FILE_PERMISSIONS_TOOLTIP);
            } else if (isArchive) {
                SystemViewRemoteFileAdapter.archiveDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.permissions", (String)FileResources.RESID_PROPERTY_FILE_PERMISSIONS_LABEL, (String)FileResources.RESID_PROPERTY_FILE_PERMISSIONS_TOOLTIP);
            }
            if (isRegular) {
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.owner", (String)FileResources.RESID_PROPERTY_FILE_OWNER_LABEL, (String)FileResources.RESID_PROPERTY_FILE_OWNER_TOOLTIP);
            } else if (isVirtual) {
                SystemViewRemoteFileAdapter.virtualDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.owner", (String)FileResources.RESID_PROPERTY_FILE_OWNER_LABEL, (String)FileResources.RESID_PROPERTY_FILE_OWNER_TOOLTIP);
            } else if (isArchive) {
                SystemViewRemoteFileAdapter.archiveDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.owner", (String)FileResources.RESID_PROPERTY_FILE_OWNER_LABEL, (String)FileResources.RESID_PROPERTY_FILE_OWNER_TOOLTIP);
            }
            if (isRegular) {
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.group", (String)FileResources.RESID_PROPERTY_FILE_GROUP_LABEL, (String)FileResources.RESID_PROPERTY_FILE_GROUP_TOOLTIP);
            } else if (isVirtual) {
                SystemViewRemoteFileAdapter.virtualDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.group", (String)FileResources.RESID_PROPERTY_FILE_GROUP_LABEL, (String)FileResources.RESID_PROPERTY_FILE_GROUP_TOOLTIP);
            } else if (isArchive) {
                SystemViewRemoteFileAdapter.archiveDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.group", (String)FileResources.RESID_PROPERTY_FILE_GROUP_LABEL, (String)FileResources.RESID_PROPERTY_FILE_GROUP_TOOLTIP);
            }
            if (this.debug) {
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor("DEBUG_PARENTREMOTEFILE");
                SystemViewRemoteFileAdapter.briefPropertyDescriptorArray[++briefIdx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor("DEBUG_PARENTREMOTEFILE");
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor("DEBUG_PARENT");
                SystemViewRemoteFileAdapter.briefPropertyDescriptorArray[++briefIdx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor("DEBUG_PARENT");
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor("DEBUG_PARENTNOROOT");
                SystemViewRemoteFileAdapter.briefPropertyDescriptorArray[++briefIdx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor("DEBUG_PARENTNOROOT");
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor("DEBUG_PARENTNAME");
                SystemViewRemoteFileAdapter.briefPropertyDescriptorArray[++briefIdx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor("DEBUG_PARENTNAME");
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor("DEBUG_ROOT");
                SystemViewRemoteFileAdapter.briefPropertyDescriptorArray[++briefIdx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor("DEBUG_ROOT");
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor("DEBUG_ISROOT");
                SystemViewRemoteFileAdapter.briefPropertyDescriptorArray[++briefIdx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor("DEBUG_ISROOT");
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor("DEBUG_EXISTS");
                SystemViewRemoteFileAdapter.briefPropertyDescriptorArray[++briefIdx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor("DEBUG_EXISTS");
            }
            if (isVirtual) {
                SystemViewRemoteFileAdapter.virtualDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.virtual.compressedsize", (String)FileResources.RESID_PROPERTY_VIRTUALFILE_COMPRESSEDSIZE_LABEL, (String)FileResources.RESID_PROPERTY_VIRTUALFILE_COMPRESSEDSIZE_DESCRIPTION);
                SystemViewRemoteFileAdapter.virtualDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.virtual.compressionratio", (String)FileResources.RESID_PROPERTY_VIRTUALFILE_COMPRESSIONRATIO_LABEL, (String)FileResources.RESID_PROPERTY_VIRTUALFILE_COMPRESSIONRATIO_DESCRIPTION);
                SystemViewRemoteFileAdapter.virtualDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.virtual.compressionmethod", (String)FileResources.RESID_PROPERTY_VIRTUALFILE_COMPRESSIONMETHOD_LABEL, (String)FileResources.RESID_PROPERTY_VIRTUALFILE_COMPRESSIONMETHOD_DESCRIPTION);
                SystemViewRemoteFileAdapter.virtualDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.virtual.comment", (String)FileResources.RESID_PROPERTY_VIRTUALFILE_COMMENT_LABEL, (String)FileResources.RESID_PROPERTY_VIRTUALFILE_COMMENT_DESCRIPTION);
            } else if (isArchive) {
                SystemViewRemoteFileAdapter.archiveDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.archive.expandedsize", (String)FileResources.RESID_PROPERTY_ARCHIVE_EXPANDEDSIZE_LABEL, (String)FileResources.RESID_PROPERTY_ARCHIVE_EXPANDEDSIZE_DESCRIPTION);
                SystemViewRemoteFileAdapter.archiveDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.archive.comment", (String)FileResources.RESID_PROPERTY_ARCHIVE_COMMENT_LABEL, (String)FileResources.RESID_PROPERTY_ARCHIVE_COMMENT_DESCRIPTION);
            }
        }
        if (this.propertySourceInput instanceof IRemoteFile && ((IRemoteFile)this.propertySourceInput).showBriefPropertySet()) {
            return propertyDescriptorArray;
        }
        if (isRegular) {
            return propertyDescriptorArray;
        }
        if (isVirtual) {
            return virtualDescriptorArray;
        }
        if (isArchive) {
            return archiveDescriptorArray;
        }
        return propertyDescriptorArray;
    }

    protected static PropertyDescriptor createSimplePropertyDescriptor(String keyAndLabel) {
        PropertyDescriptor pd = new PropertyDescriptor((Object)keyAndLabel, keyAndLabel);
        return pd;
    }

    protected Object internalGetPropertyValue(Object key) {
        return this.getPropertyValue(key, true);
    }

    public Object getPropertyValue(Object key) {
        String name = (String)key;
        if (name.equals("org.eclipse.rse.ui.nbrChildren")) {
            IRemoteFile file = (IRemoteFile)this.propertySourceInput;
            IRemoteFile container = file;
            Object[] contents = container.getContents((ISystemContentsType)RemoteChildrenContentsType.getInstance());
            if (contents == null) {
                return "0";
            }
            return Integer.toString(contents.length);
        }
        return super.getPropertyValue(key);
    }

    public Object getPropertyValue(Object property, boolean formatted) {
        String name = (String)property;
        IRemoteFile file = (IRemoteFile)this.propertySourceInput;
        IVirtualRemoteFile virtualFile = null;
        boolean isVirtual = file instanceof IVirtualRemoteFile;
        if (isVirtual) {
            virtualFile = (IVirtualRemoteFile)file;
        }
        if (this.debug) {
            if (name.equals("DEBUG_PARENTREMOTEFILE")) {
                IRemoteFile parent = file.getParentRemoteFile();
                if (parent == null) {
                    return "null";
                }
                return "absPath='" + parent.getAbsolutePath() + "'";
            }
            if (name.equals("DEBUG_PARENT")) {
                return file.getParentPath();
            }
            if (name.equals("DEBUG_PARENTNOROOT")) {
                return file.getParentNoRoot();
            }
            if (name.equals("DEBUG_PARENTNAME")) {
                return file.getParentName();
            }
            if (name.equals("DEBUG_ROOT")) {
                return file.getRoot();
            }
            if (name.equals("DEBUG_ISROOT")) {
                return file.isRoot() ? "true" : "false";
            }
            if (name.equals("DEBUG_EXISTS")) {
                return file.exists() ? "true" : "false";
            }
        }
        if (name.equals("org.eclipse.rse.ui.file.lastmodified")) {
            Date date = file.getLastModifiedDate();
            if (date != null) {
                long t = date.getTime();
                if (formatted) {
                    if (t == 0L) {
                        return "";
                    }
                    ULocale locale = ULocale.getDefault();
                    DateFormat icufmt = DateFormat.getDateTimeInstance((int)1, (int)2, (ULocale)locale);
                    String formattedDate = icufmt.format(date);
                    return formattedDate;
                }
                return date;
            }
            return date;
        }
        if (name.equals("org.eclipse.rse.ui.file.size")) {
            if (formatted) {
                NumberFormat fmt = NumberFormat.getIntegerInstance();
                String formattedNumber = fmt.format(file.getLength());
                return SystemViewRemoteFileAdapter.sub((String)this.xlatedSize, (String)"&1", (String)formattedNumber);
            }
            return new Long(file.getLength());
        }
        if (name.equals("org.eclipse.rse.ui.archive.expandedsize")) {
            if (!isVirtual || virtualFile == null) {
                return new Long(0L);
            }
            if (formatted) {
                return SystemViewRemoteFileAdapter.sub((String)this.xlatedExpandedSize, (String)"&1", (String)Long.toString(virtualFile.getExpandedSize()));
            }
            return new Long(virtualFile.getExpandedSize());
        }
        if (name.equals("org.eclipse.rse.ui.virtual.compressedsize")) {
            if (!isVirtual || virtualFile == null) {
                return new Long(0L);
            }
            if (formatted) {
                return SystemViewRemoteFileAdapter.sub((String)this.xlatedCompressedSize, (String)"&1", (String)Long.toString(virtualFile.getCompressedSize()));
            }
            return new Long(virtualFile.getCompressedSize());
        }
        if (name.equals("org.eclipse.rse.ui.file.path")) {
            return file.getParentPath();
        }
        if (name.equals("org.eclipse.rse.ui.file.canonicalpath")) {
            return file.getCanonicalPath();
        }
        if (name.equals("org.eclipse.rse.ui.file.extension")) {
            if (!file.isDirectory()) {
                String ext = file.getExtension();
                return ext == null ? "" : ext;
            }
            return "";
        }
        if (name.equals("org.eclipse.rse.ui.file.permissions")) {
            IHostFilePermissions permissions = file.getPermissions();
            if (permissions == null) {
                if (this.getFilePermissions(file)) {
                    return FileResources.MESSAGE_PENDING;
                }
                return FileResources.MESSAGE_NOT_SUPPORTED;
            }
            if (permissions instanceof PendingHostFilePermissions) {
                return FileResources.MESSAGE_PENDING;
            }
            return permissions.toAlphaString();
        }
        if (name.equals("org.eclipse.rse.ui.file.owner")) {
            IHostFilePermissions permissions = file.getPermissions();
            if (permissions == null) {
                if (this.getFilePermissions(file)) {
                    return FileResources.MESSAGE_PENDING;
                }
                return FileResources.MESSAGE_NOT_SUPPORTED;
            }
            if (permissions instanceof PendingHostFilePermissions) {
                return FileResources.MESSAGE_PENDING;
            }
            return permissions.getUserOwner();
        }
        if (name.equals("org.eclipse.rse.ui.file.group")) {
            IHostFilePermissions permissions = file.getPermissions();
            if (permissions == null) {
                if (this.getFilePermissions(file)) {
                    return FileResources.MESSAGE_PENDING;
                }
                return FileResources.MESSAGE_NOT_SUPPORTED;
            }
            if (permissions instanceof PendingHostFilePermissions) {
                return FileResources.MESSAGE_PENDING;
            }
            return permissions.getGroupOwner();
        }
        if (name.equals("org.eclipse.rse.ui.file.classification")) {
            return file.getClassification();
        }
        if (name.equals("org.eclipse.rse.ui.file.readonly")) {
            return file.canWrite() ? this.getTranslatedNo() : this.getTranslatedYes();
        }
        if (name.equals("org.eclipse.rse.ui.file.readable")) {
            return file.canRead() ? this.getTranslatedYes() : this.getTranslatedNo();
        }
        if (name.equals("org.eclipse.rse.ui.file.writable")) {
            return file.canWrite() ? this.getTranslatedYes() : this.getTranslatedNo();
        }
        if (name.equals("org.eclipse.rse.ui.file.hidden")) {
            return file.isHidden() ? this.getTranslatedYes() : this.getTranslatedNo();
        }
        if (name.equals("org.eclipse.rse.ui.filterString")) {
            return file.getFilterString();
        }
        if (name.equals("org.eclipse.rse.ui.archive.comment") || name.equals("org.eclipse.rse.ui.virtual.comment")) {
            return file.getComment();
        }
        if (name.equals("org.eclipse.rse.ui.virtual.compressionmethod")) {
            if (!isVirtual || virtualFile == null) {
                return "";
            }
            return virtualFile.getCompressionMethod();
        }
        if (name.equals("org.eclipse.rse.ui.virtual.compressionratio")) {
            if (virtualFile != null) {
                Double ratio = new Double(virtualFile.getCompressionRatio());
                if (formatted) {
                    NumberFormat numfmt = NumberFormat.getPercentInstance();
                    return numfmt.format((Object)ratio);
                }
                return ratio;
            }
            return null;
        }
        return null;
    }

    private boolean getFilePermissions(IRemoteFile file) {
        IFilePermissionsService service;
        if (file instanceof IAdaptable && (service = (IFilePermissionsService)((IAdaptable)file).getAdapter(IFilePermissionsService.class)) != null && (service.getCapabilities(file.getHostFile()) & 4) != 0) {
            MultiFetchPermissionsJob deferredFetch;
            IRemoteFile rFile = file;
            if (rFile.getHostFile() instanceof IHostFilePermissionsContainer) {
                ((IHostFilePermissionsContainer)rFile.getHostFile()).setPermissions((IHostFilePermissions)new PendingHostFilePermissions());
            }
            if ((deferredFetch = (MultiFetchPermissionsJob)((Object)this._permissionsJobMap.get(service))) == null || deferredFetch.isStarted() || deferredFetch.size() > 50) {
                deferredFetch = new MultiFetchPermissionsJob(service);
                this._permissionsJobMap.put(service, deferredFetch);
                deferredFetch.addFile(file);
                deferredFetch.schedule(100L);
            } else {
                deferredFetch.addFile(file);
            }
            return true;
        }
        return false;
    }

    public boolean canDrag(Object element) {
        if (element instanceof IRemoteFile) {
            IRemoteFile file = (IRemoteFile)element;
            boolean offline = file.getParentRemoteFileSubSystem().isOffline();
            return file.canRead() && !offline;
        }
        return true;
    }

    public boolean canDrop(Object element) {
        if (element instanceof IRemoteFile) {
            IRemoteFile file = (IRemoteFile)element;
            IRemoteFileSubSystem ss = file.getParentRemoteFileSubSystem();
            IRemoteFileSubSystemConfiguration config = ss.getParentRemoteFileSubSystemConfiguration();
            boolean offline = ss.isOffline();
            boolean isWindows = !config.isUnixStyle();
            boolean supportsArchiveManagement = config.supportsArchiveManagement();
            return !offline && file.canRead() && (file.canWrite() || isWindows) && (file.isDirectory() || file.isRoot() || file.isArchive() && supportsArchiveManagement);
        }
        return false;
    }

    public boolean validateDrop(ISystemResourceSet srcSet, Object target, boolean sameSystem) {
        if (target instanceof IRemoteFile) {
            IRemoteFile targetFile = (IRemoteFile)target;
            IRemoteFileSubSystemConfiguration config = targetFile.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemConfiguration();
            boolean supportsArchiveManagement = config.supportsArchiveManagement();
            if (!targetFile.isFile() || targetFile.isArchive() && supportsArchiveManagement) {
                boolean isWindows;
                boolean bl = isWindows = !config.isUnixStyle();
                return targetFile.canWrite() || isWindows;
            }
            Object first = srcSet.get(0);
            if (first instanceof IRemoteFile) {
                return true;
            }
            if (first instanceof IResource) {
                return true;
            }
            if (first instanceof ISystemFilterReference) {
                return true;
            }
            ISystemViewDropDestination adapter = (ISystemViewDropDestination)Platform.getAdapterManager().getAdapter(first, ISystemViewDropDestination.class);
            if (adapter != null) {
                return adapter.supportDropDestination(target);
            }
        }
        return false;
    }

    public boolean validateDrop(Object src, Object target, boolean sameSystem) {
        if (target instanceof IRemoteFile) {
            IRemoteFile targetFile = (IRemoteFile)target;
            IRemoteFileSubSystemConfiguration config = targetFile.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemConfiguration();
            boolean supportsArchiveManagement = config.supportsArchiveManagement();
            if (!targetFile.isFile() || targetFile.isArchive() && supportsArchiveManagement) {
                targetFile.canWrite();
                if (src instanceof IRemoteFile) {
                    return true;
                }
                if (src instanceof IResource) {
                    return true;
                }
                if (src instanceof String) {
                    File localFile = new File((String)src);
                    return localFile.exists();
                }
                if (src instanceof ISystemFilterReference) {
                    return true;
                }
                ISystemViewDropDestination adapter = (ISystemViewDropDestination)Platform.getAdapterManager().getAdapter(src, ISystemViewDropDestination.class);
                if (adapter != null) {
                    return adapter.supportDropDestination(target);
                }
            }
        }
        return false;
    }

    public Object doDrag(Object element, boolean sameSystem, IProgressMonitor monitor) {
        if (element instanceof IRemoteFile) {
            IRemoteFile srcFileOrFolder = (IRemoteFile)element;
            return UniversalFileTransferUtility.downloadResourceToWorkspace(srcFileOrFolder, monitor);
        }
        if (element instanceof File) {
            return UniversalFileTransferUtility.downloadResourceToWorkspace((File)element, monitor);
        }
        if (element instanceof IResource) {
            return element;
        }
        return null;
    }

    public ISystemResourceSet doDrag(SystemRemoteResourceSet set, IProgressMonitor monitor) {
        boolean supportsSearch = ((IRemoteFileSubSystemConfiguration)set.getSubSystem().getSubSystemConfiguration()).supportsSearch();
        boolean doSuperTransferProperty = false;
        if (!doSuperTransferProperty && supportsSearch) {
            SystemRemoteResourceSet flatSet = new SystemRemoteResourceSet(set.getSubSystem(), set.getAdapter());
            long totalByteSize = this.getFlatRemoteResourceSet(set.getResourceSet(), flatSet, monitor);
            flatSet.setByteSize(totalByteSize);
            if (monitor != null) {
                monitor.beginTask(_downloadMessage, (int)totalByteSize);
            }
            int i = 0;
            while (i < set.size()) {
                IRemoteFile remoteFile = (IRemoteFile)set.get(i);
                if (remoteFile.isDirectory()) {
                    flatSet.addResource((Object)remoteFile);
                }
                ++i;
            }
            try {
                SystemWorkspaceResourceSet flatResult = UniversalFileTransferUtility.downloadResourcesToWorkspaceMultiple(flatSet, monitor);
                if (flatResult.hasMessage()) {
                    return flatResult;
                }
                SystemWorkspaceResourceSet hierarchicalResult = new SystemWorkspaceResourceSet();
                int i2 = 0;
                while (i2 < set.size()) {
                    IRemoteFile remoteFile = (IRemoteFile)set.get(i2);
                    IResource tempResource = UniversalFileTransferUtility.getTempFileFor(remoteFile);
                    if (tempResource instanceof IContainer) {
                        UniversalFileTransferUtility.discardReplicasOfDeletedFiles((IRemoteFileSubSystem)set.getSubSystem(), (IContainer)tempResource);
                    }
                    hierarchicalResult.addResource((Object)tempResource);
                    ++i2;
                }
                return hierarchicalResult;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return UniversalFileTransferUtility.downloadResourcesToWorkspace(set, monitor);
    }

    private IRemoteFileSubSystem getLocalFileSubSystem() {
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        IHost[] connections = registry.getHosts();
        int i = 0;
        while (i < connections.length) {
            IHost connection = connections[i];
            IRemoteFileSubSystem anFS = RemoteFileUtility.getFileSubSystem((IHost)connection);
            if (anFS != null && anFS.getHost().getSystemType().isLocal()) {
                return anFS;
            }
            ++i;
        }
        return null;
    }

    protected long getFlatRemoteResourceSet(List initialResources, SystemRemoteResourceSet flatSet, IProgressMonitor monitor) {
        long totalByteSize = 0L;
        ArrayList<IHostSearchResultConfiguration> configList = new ArrayList<IHostSearchResultConfiguration>();
        HostSearchResultSet searchSet = new HostSearchResultSet();
        IRemoteFileSubSystem subsys = (IRemoteFileSubSystem)flatSet.getSubSystem();
        if (subsys instanceof FileServiceSubSystem) {
            FileServiceSubSystem ss = (FileServiceSubSystem)subsys;
            int i = 0;
            while (i < initialResources.size()) {
                IRemoteFile remoteFile = (IRemoteFile)initialResources.get(i);
                if (remoteFile.isDirectory()) {
                    SystemSearchString searchString = null;
                    searchString = ArchiveHandlerManager.isVirtual((String)remoteFile.getAbsolutePath()) ? new SystemSearchString("*", false, false, "*", false, true, true) : new SystemSearchString("*", false, false, "*", false, false, true);
                    IHostSearchResultConfiguration config = ss.createSearchConfiguration((IHostSearchResultSet)searchSet, (Object)remoteFile, searchString);
                    subsys.search(config);
                    configList.add(config);
                } else {
                    flatSet.addResource((Object)remoteFile);
                }
                ++i;
            }
        }
        SubProgressMonitor submonitor = null;
        if (monitor != null) {
            submonitor = new SubProgressMonitor(monitor, configList.size());
            submonitor.setTaskName(FileResources.RESID_SEARCH_MESSAGE_SEARCHING);
        }
        int n = 0;
        while (n < configList.size()) {
            IHostSearchResultConfiguration config = (IHostSearchResultConfiguration)configList.get(n);
            while (config.getStatus() != 1) {
                if (monitor != null) {
                    if (monitor.isCanceled()) {
                        return totalByteSize;
                    }
                    Display display = Display.getCurrent();
                    while (display != null && display.readAndDispatch()) {
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (config.getStatus() == 1) {
                Object[] results;
                if (submonitor != null) {
                    submonitor.worked(1);
                }
                if ((results = config.getResults()) == null || results.length == 0) {
                    System.out.println("waiting for results");
                }
                int m = 0;
                while (m < results.length) {
                    Object result = results[m];
                    if (result instanceof IRemoteFile) {
                        IRemoteFile file = (IRemoteFile)result;
                        flatSet.addResource((Object)file);
                        totalByteSize += file.getLength();
                    }
                    ++m;
                }
            }
            ++n;
        }
        return totalByteSize;
    }

    protected long getFlatWorkspaceResourceSet(List resources, SystemWorkspaceResourceSet flatSet, IProgressMonitor monitor) {
        long totalBytes = 0L;
        int i = 0;
        while (i < resources.size()) {
            IResource resource = (IResource)resources.get(i);
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                flatSet.addResource((Object)file);
                File osFile = file.getLocation().toFile();
                totalBytes += osFile.length();
            } else if (resource instanceof IContainer) {
                IContainer container = (IContainer)resource;
                try {
                    IResource[] members = container.members();
                    totalBytes += this.getFlatWorkspaceResourceSet(members, flatSet, monitor);
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        return totalBytes;
    }

    protected long getFlatWorkspaceResourceSet(IResource[] resources, SystemWorkspaceResourceSet flatSet, IProgressMonitor monitor) {
        long totalBytes = 0L;
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                flatSet.addResource((Object)file);
                File osFile = file.getLocation().toFile();
                totalBytes += osFile.length();
            } else if (resource instanceof IContainer) {
                IContainer container = (IContainer)resource;
                try {
                    IResource[] members = container.members();
                    totalBytes += this.getFlatWorkspaceResourceSet(members, flatSet, monitor);
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        return totalBytes;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ISystemResourceSet doDrop(ISystemResourceSet fromSet, Object target, boolean sameSystemType, boolean sameSystem, int srcType, IProgressMonitor monitor) {
        String name;
        IRemoteFile srcFileOrFolder;
        SystemRemoteResourceSet resultSet = new SystemRemoteResourceSet(this.getSubSystem(target), (ISystemDragDropAdapter)this);
        if (!sameSystem && sameSystemType) {
            fromSet = this.doDrag((SystemRemoteResourceSet)fromSet, monitor);
        }
        if (!(target instanceof IRemoteFile)) return resultSet;
        IRemoteFile targetFolder = (IRemoteFile)target;
        IRemoteFileSubSystem targetFS = targetFolder.getParentRemoteFileSubSystem();
        boolean isWindows = !targetFS.getParentRemoteFileSubSystemConfiguration().isUnixStyle();
        try {
            targetFolder = targetFS.getRemoteFileObject(targetFolder.getAbsolutePath(), monitor);
            if (targetFolder == null) {
                targetFolder = (IRemoteFile)target;
            }
        }
        catch (Exception exception) {}
        if (!targetFolder.canWrite() && !isWindows) {
            String msgTxt = FileResources.FILEMSG_SECURITY_ERROR;
            String msgDetails = NLS.bind((String)FileResources.FILEMSG_SECURITY_ERROR_DETAILS, (Object)targetFS.getHostAliasName());
            SimpleSystemMessage errorMsg = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEF1001", 4, msgTxt, msgDetails);
            resultSet.setMessage((SystemMessage)errorMsg);
            return resultSet;
        }
        if (!targetFS.isConnected()) {
            return null;
        }
        List set = fromSet.getResourceSet();
        if (set.size() <= 0) return resultSet;
        if (fromSet instanceof SystemWorkspaceResourceSet) {
            boolean doSuperTransferProperty = false;
            if (!doSuperTransferProperty) {
                SystemWorkspaceResourceSet flatFromSet = new SystemWorkspaceResourceSet();
                long totalByteSize = this.getFlatWorkspaceResourceSet(fromSet.getResourceSet(), flatFromSet, monitor);
                if (monitor != null) {
                    int size = (int)totalByteSize;
                    monitor.beginTask(_uploadMessage, size);
                }
                resultSet = UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)fromSet, targetFolder, monitor, true);
            } else {
                resultSet = UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)fromSet, targetFolder, monitor, true);
            }
            if (!resultSet.hasMessage()) return resultSet;
            resultSet.getMessage();
            if (!monitor.isCanceled()) return resultSet;
            if (resultSet.size() <= 0) return resultSet;
            Object thisObject = resultSet.get(0);
            String copiedFileNames = null;
            if (thisObject instanceof IRemoteFile) {
                copiedFileNames = ((IRemoteFile)thisObject).getName();
                int i = 1;
                while (i < resultSet.size()) {
                    if (thisObject instanceof IRemoteFile) {
                        copiedFileNames = String.valueOf(copiedFileNames) + "\n" + ((IRemoteFile)thisObject).getName();
                    }
                    ++i;
                }
            }
            if (copiedFileNames == null) return resultSet;
            String msgTxt = FileResources.FILEMSG_COPY_INTERRUPTED;
            String msgDetails = NLS.bind((String)FileResources.FILEMSG_COPY_INTERRUPTED_DETAILS, (Object)copiedFileNames);
            SimpleSystemMessage thisMessage = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEG1248", 4, msgTxt, msgDetails);
            resultSet.setMessage((SystemMessage)thisMessage);
            return resultSet;
        }
        if (!(fromSet instanceof SystemRemoteResourceSet)) return resultSet;
        SystemRemoteResourceSet rmtSet = (SystemRemoteResourceSet)fromSet;
        ISubSystem srcSubSystem = rmtSet.getSubSystem();
        Object first = set.get(0);
        if (first instanceof ISystemFilterReference) {
            boolean bl;
            SystemWorkspaceResourceSet downloadedFilterResults = new SystemWorkspaceResourceSet();
            int i = 0;
            while (true) {
                if (i >= set.size()) {
                    if (srcSubSystem != targetFS) break;
                    bl = true;
                    return this.doDrop((ISystemResourceSet)downloadedFilterResults, target, sameSystemType, bl, 0, monitor);
                }
                ISystemFilterReference ref = (ISystemFilterReference)set.get(i);
                SystemFilterReference filterReference = (SystemFilterReference)ref;
                Object[] children = null;
                try {
                    children = ((SubSystem)srcSubSystem).internalResolveFilterStrings(filterReference.getReferencedFilter().getFilterStrings(), monitor);
                }
                catch (Exception exception) {}
                if (children != null) {
                    int c = 0;
                    while (c < children.length) {
                        Object child = children[c];
                        if (child instanceof IAdaptable) {
                            Object newSrc = child;
                            if (srcSubSystem != targetFS) {
                                ISystemDragDropAdapter cAdapter = (ISystemDragDropAdapter)((IAdaptable)child).getAdapter(ISystemDragDropAdapter.class);
                                newSrc = cAdapter.doDrag(child, sameSystemType, monitor);
                                if (newSrc instanceof SystemMessage) {
                                    resultSet.setMessage((SystemMessage)newSrc);
                                    return resultSet;
                                }
                                downloadedFilterResults.addResource(newSrc);
                            }
                        }
                        ++c;
                    }
                }
                ++i;
            }
            bl = false;
            return this.doDrop((ISystemResourceSet)downloadedFilterResults, target, sameSystemType, bl, 0, monitor);
        }
        if (!(first instanceof IRemoteFile)) return resultSet;
        ArrayList<IRemoteFile> toCopy = new ArrayList<IRemoteFile>();
        ArrayList<String> toCopyNames = new ArrayList<String>();
        ArrayList<IRemoteFile> existing = new ArrayList<IRemoteFile>();
        boolean overwrite = false;
        int i = 0;
        while (true) {
            block46: {
                if (i >= set.size()) {
                    if (existing.size() > 0) {
                        CopyRunnable rr = new CopyRunnable(existing);
                        Display.getDefault().syncExec((Runnable)rr);
                        overwrite = rr.getOk();
                    }
                    if (existing.size() != 0) {
                        if (!overwrite) return resultSet;
                    }
                    break;
                }
                srcFileOrFolder = (IRemoteFile)set.get(i);
                if (!srcFileOrFolder.exists()) {
                    String msgTxt = NLS.bind((String)FileResources.MSG_ERROR_FILE_NOTFOUND, (Object)srcFileOrFolder.getAbsolutePath(), (Object)srcFileOrFolder.getHost().getAliasName());
                    SimpleSystemMessage errorMessage = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEG1106", 4, msgTxt);
                    resultSet.setMessage((SystemMessage)errorMessage);
                    return resultSet;
                }
                name = srcFileOrFolder.getName();
                String originalName = srcFileOrFolder.getName();
                int count = 1;
                boolean go = true;
                if (sameSystem) {
                    try {
                        IRemoteFile existingFileOrFolder;
                        if (targetFolder.getAbsolutePath().equals(srcFileOrFolder.getAbsolutePath())) break block46;
                        if (targetFolder.getAbsolutePath().equals(srcFileOrFolder.getParentRemoteFile().getAbsolutePath())) {
                            name = MessageFormat.format(FileResources.RESID_CONFLICT_COPY_PATTERN, new Integer(count), originalName);
                            while (go) {
                                existingFileOrFolder = ((IRemoteFileSubSystem)srcSubSystem).getRemoteFileObject(targetFolder, name, monitor);
                                if (existingFileOrFolder.exists()) {
                                    name = MessageFormat.format(FileResources.RESID_CONFLICT_COPY_PATTERN, new Integer(++count), originalName);
                                    continue;
                                }
                                toCopy.add(srcFileOrFolder);
                                toCopyNames.add(name);
                                go = false;
                            }
                            break block46;
                        }
                        existingFileOrFolder = ((IRemoteFileSubSystem)srcSubSystem).getRemoteFileObject(targetFolder, name, monitor);
                        if (existingFileOrFolder.exists()) {
                            existing.add(existingFileOrFolder);
                        }
                        if (name != null) {
                            toCopy.add(srcFileOrFolder);
                            toCopyNames.add(name);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
        int x = 0;
        while (true) {
            block47: {
                SystemMessageException e2;
                block48: {
                    String copiedFileNames;
                    block49: {
                        int i2;
                        Object thisObject;
                        if (x >= toCopy.size()) {
                            return resultSet;
                        }
                        srcFileOrFolder = (IRemoteFile)toCopy.get(x);
                        name = (String)toCopyNames.get(x);
                        SystemMessage copyMessage = RSEUIPlugin.getPluginMessage((String)"RSEG1072");
                        copyMessage.makeSubstitution((Object)srcFileOrFolder.getName(), (Object)targetFolder.getName());
                        if (monitor != null) {
                            monitor.beginTask(copyMessage.getLevelOneText(), 100);
                        }
                        try {
                            targetFS.copy(srcFileOrFolder, targetFolder, name, monitor);
                            IRemoteFile copiedFile = targetFS.getRemoteFileObject(targetFolder, name, monitor);
                            resultSet.addResource((Object)copiedFile);
                            break block47;
                        }
                        catch (SystemMessageException e2) {
                            if (!monitor.isCanceled() || resultSet.size() <= 0) break block48;
                            thisObject = resultSet.get(0);
                            copiedFileNames = null;
                            if (!(thisObject instanceof IRemoteFile)) break block49;
                            copiedFileNames = ((IRemoteFile)thisObject).getName();
                            i2 = 1;
                        }
                        while (i2 < resultSet.size()) {
                            if (thisObject instanceof IRemoteFile) {
                                copiedFileNames = String.valueOf(copiedFileNames) + "\n" + ((IRemoteFile)thisObject).getName();
                            }
                            ++i2;
                        }
                    }
                    if (copiedFileNames != null) {
                        String msgTxt = FileResources.FILEMSG_COPY_INTERRUPTED;
                        String msgDetails = NLS.bind((String)FileResources.FILEMSG_COPY_INTERRUPTED_DETAILS, (Object)copiedFileNames);
                        SimpleSystemMessage thisMessage = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEG1248", 4, msgTxt, msgDetails);
                        SystemMessageDialog.displayErrorMessage((Shell)this.shell, (SystemMessage)thisMessage);
                        break block47;
                    } else {
                        SystemMessageDialog.displayMessage((SystemMessageException)e2);
                    }
                    break block47;
                    catch (Exception e3) {
                        e3.printStackTrace();
                        break block47;
                    }
                }
                SystemMessageDialog.displayMessage((SystemMessageException)e2);
            }
            ++x;
        }
    }

    /*
     * Exception decompiling
     */
    public Object doDrop(Object src, Object target, boolean sameSystemType, boolean sameSystem, int sourceType, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String checkForCollision(Shell shell, IRemoteFile targetFolder, String oldName) {
        String newName = oldName;
        try {
            IRemoteFileSubSystem ss = targetFolder.getParentRemoteFileSubSystem();
            IRemoteFile targetFileOrFolder = ss.getRemoteFileObject(targetFolder, oldName, (IProgressMonitor)new NullProgressMonitor());
            if (targetFileOrFolder.exists()) {
                RenameRunnable rr = new RenameRunnable(targetFileOrFolder);
                Display.getDefault().syncExec((Runnable)rr);
                newName = rr.getNewName();
            }
        }
        catch (SystemMessageException e) {
            SystemBasePlugin.logError((String)"SystemCopyRemoteFileAction.checkForCollision()", (Throwable)e);
        }
        return newName;
    }

    public boolean canDelete(Object element) {
        IRemoteFile file = (IRemoteFile)element;
        boolean offline = file.getParentRemoteFileSubSystem().isOffline();
        return !offline && !file.isRoot();
    }

    public boolean doDelete(Shell shell, Object element, IProgressMonitor monitor) throws Exception {
        boolean ok;
        IRemoteFile file = (IRemoteFile)element;
        IRemoteFile parentFile = file.getParentRemoteFile();
        IRemoteFileSubSystem ss = file.getParentRemoteFileSubSystem();
        try {
            IResource tmp = UniversalFileTransferUtility.getTempFileFor(file);
            if (tmp.exists()) {
                try {
                    tmp.delete(false, null);
                    SystemIFileProperties properties = new SystemIFileProperties(tmp);
                    properties.setRemoteFileObject(null);
                }
                catch (Exception exception) {}
            }
            ss.delete(file, monitor);
            ok = true;
            file.markStale(true);
            parentFile.markStale(true);
        }
        catch (Exception exception) {
            ok = false;
            String msgTxt = NLS.bind((String)FileResources.FILEMSG_DELETE_FILE_FAILED, (Object)file.toString());
            String msgDetails = FileResources.FILEMSG_DELETE_FILE_FAILED_DETAILS;
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEF1300", 4, msgTxt, msgDetails);
            SystemMessageDialog.displayErrorMessage((Shell)shell, (SystemMessage)msg);
        }
        return ok;
    }

    public boolean doDeleteBatch(Shell shell, List resourceSet, IProgressMonitor monitor) throws Exception {
        IRemoteFileSubSystem ss = null;
        IRemoteFile[] files = new IRemoteFile[resourceSet.size()];
        int i = 0;
        while (i < resourceSet.size()) {
            IRemoteFile file;
            files[i] = file = (IRemoteFile)resourceSet.get(i);
            IRemoteFile parentFile = file.getParentRemoteFile();
            if (ss == null) {
                ss = file.getParentRemoteFileSubSystem();
            }
            try {
                IResource tmp = UniversalFileTransferUtility.getTempFileFor(file);
                if (tmp.exists()) {
                    try {
                        tmp.delete(false, null);
                    }
                    catch (Exception exception) {}
                }
                file.markStale(true);
                parentFile.markStale(true);
            }
            catch (Exception exception) {
                String msgTxt = NLS.bind((String)FileResources.FILEMSG_DELETE_FILE_FAILED, (Object)file.toString());
                String msgDetails = FileResources.FILEMSG_DELETE_FILE_FAILED_DETAILS;
                SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEF1300", 4, msgTxt, msgDetails);
                SystemMessageDialog.displayErrorMessage((Shell)shell, (SystemMessage)msg);
            }
            ++i;
        }
        if (ss != null) {
            ss.deleteBatch(files, monitor);
        }
        return true;
    }

    public boolean canRename(Object element) {
        IRemoteFile file = (IRemoteFile)element;
        boolean offline = file.getParentRemoteFileSubSystem().isOffline();
        return !file.isRoot() && file.canRead() && !offline;
    }

    private void moveTempResource(IResource localResource, IPath newLocalPath, IRemoteFileSubSystem ss, String newRemotePath) {
        if (localResource != null) {
            try {
                this.moveTempFileProperties(localResource, ss, newRemotePath);
                localResource.move(newLocalPath, true, null);
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private void moveTempFileProperties(IResource localResource, IRemoteFileSubSystem ss, String remotePath) {
        if (localResource instanceof IContainer) {
            IContainer localContainer = (IContainer)localResource;
            try {
                IResource[] members = localContainer.members();
                int i = 0;
                while (i < members.length) {
                    IResource member = members[i];
                    this.moveTempFileProperties(member, ss, String.valueOf(remotePath) + "/" + member.getName());
                    ++i;
                }
            }
            catch (Exception exception) {}
        } else if (localResource instanceof IFile) {
            IFile localFile = (IFile)localResource;
            try {
                SystemIFileProperties properties = new SystemIFileProperties((IResource)localFile);
                properties.setRemoteFilePath(remotePath);
                Object editableObj = properties.getRemoteFileObject();
                if (editableObj != null) {
                    SystemEditableRemoteFile editable = (SystemEditableRemoteFile)editableObj;
                    IRemoteFile newRemoteFile = ss.getRemoteFileObject(remotePath, (IProgressMonitor)new NullProgressMonitor());
                    editable.setRemoteFile(newRemoteFile);
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean doRename(Shell shell, Object element, String newName, IProgressMonitor monitor) throws Exception {
        IRemoteFile file = (IRemoteFile)element;
        IRemoteFileSubSystem ss = file.getParentRemoteFileSubSystem();
        String newRemotePath = String.valueOf(file.getParentPath()) + "/" + newName;
        IResource localResource = null;
        Object localProjectResource = null;
        if (file.getHost().getSystemType().isLocal()) {
            localProjectResource = file.isFile() ? SystemViewRemoteFileAdapter.getProjectFileForLocation(file.getAbsolutePath()) : SystemViewRemoteFileAdapter.getProjectFolderForLocation(file.getAbsolutePath());
        }
        if (localProjectResource != null) {
            IPath newLocalPath = localProjectResource.getParent().getFullPath().append(newName);
            localProjectResource.move(newLocalPath, true, null);
            return true;
        }
        if (SystemRemoteEditManager.getInstance().doesRemoteEditProjectExist()) {
            localResource = UniversalFileTransferUtility.getTempFileFor(file);
        }
        ss.rename(file, newName, monitor);
        if (localResource != null && localResource.exists()) {
            IPath newLocalPath = localResource.getParent().getFullPath().append(newName);
            this.moveTempResource(localResource, newLocalPath, ss, newRemotePath);
        }
        return true;
    }

    public ISystemValidator getNameValidator(Object element) {
        if (element instanceof IRemoteFile) {
            IRemoteFile file = (IRemoteFile)element;
            if (file.isDirectory()) {
                return file.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemConfiguration().getFolderNameValidator();
            }
            return file.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemConfiguration().getFileNameValidator();
        }
        return null;
    }

    public String getCanonicalNewName(Object element, String newName) {
        if (element instanceof IRemoteFile) {
            IRemoteFile file = (IRemoteFile)element;
            if (file.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemConfiguration().isUnixStyle()) {
                return newName;
            }
            return newName.toUpperCase();
        }
        return newName;
    }

    public boolean namesAreEqual(Object element, String newName) {
        if (element instanceof IRemoteFile) {
            IRemoteFile file = (IRemoteFile)element;
            if (file.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemConfiguration().isUnixStyle()) {
                return this.getName(element).equals(newName);
            }
            return this.getName(element).equalsIgnoreCase(newName);
        }
        return super.namesAreEqual(element, newName);
    }

    public String getMementoHandleKey(Object element) {
        return "Remote";
    }

    public String getAbsoluteName(Object element) {
        IRemoteFile file = (IRemoteFile)element;
        return file.getAbsolutePath();
    }

    public String getAbsoluteParentName(Object element) {
        IRemoteFile file = (IRemoteFile)element;
        return file.getParentPath();
    }

    public ISubSystem getSubSystem(Object element) {
        if (element instanceof IRemoteFile) {
            IRemoteFile file = (IRemoteFile)element;
            return file.getParentRemoteFileSubSystem();
        }
        return super.getSubSystem(element);
    }

    public String getSubSystemConfigurationId(Object element) {
        IRemoteFile file = (IRemoteFile)element;
        return file.getParentRemoteFileSubSystem().getSubSystemConfiguration().getId();
    }

    public String getRemoteTypeCategory(Object element) {
        return "files";
    }

    public String getRemoteType(Object element) {
        IRemoteFile file = (IRemoteFile)element;
        if (!file.isRoot() && !file.isDirectory()) {
            return "file";
        }
        return "folder";
    }

    public String getRemoteSubType(Object element) {
        IRemoteFile file = (IRemoteFile)element;
        if (file.isFile()) {
            return file.getExtension();
        }
        if (file.isRoot()) {
            return "root";
        }
        return "subfolder";
    }

    public String getRemoteSubSubType(Object element) {
        return null;
    }

    public String getRemoteSourceType(Object element) {
        IRemoteFile file = (IRemoteFile)element;
        String srcType = null;
        if (file.isFile()) {
            srcType = file.getExtension();
            if (srcType == null) {
                srcType = "blank";
            } else if (srcType.length() == 0) {
                srcType = "null";
            }
        }
        return srcType;
    }

    public boolean refreshRemoteObject(Object oldElement, Object newElement) {
        if (oldElement instanceof RemoteFile && newElement instanceof IRemoteFile) {
            RemoteFile oldFile = (RemoteFile)oldElement;
            RemoteFile newFile = (RemoteFile)newElement;
            if (oldFile != newFile && (oldFile.isFile() && newFile.isFile() || oldFile.isDirectory() && newFile.isDirectory())) {
                oldFile.getHostFile().renameTo(newFile.getAbsolutePath());
            }
            return true;
        }
        return false;
    }

    public Object getRemoteParent(Object element, IProgressMonitor monitor) throws Exception {
        return ((IRemoteFile)element).getParentRemoteFile();
    }

    public String[] getRemoteParentNamesInUse(Object element, IProgressMonitor monitor) throws Exception {
        String[] names = EMPTY_STRING_LIST;
        IRemoteFile file = (IRemoteFile)element;
        String parentName = file.getParentPath();
        if (parentName == null) {
            return names;
        }
        IRemoteFile parentFolder = file.getParentRemoteFile();
        IRemoteFile[] children = parentFolder.getParentRemoteFileSubSystem().list(parentFolder, monitor);
        if (children == null || children.length == 0) {
            return names;
        }
        names = new String[children.length];
        int idx = 0;
        while (idx < names.length) {
            names[idx] = children[idx].getName();
            ++idx;
        }
        return names;
    }

    public boolean handleDoubleClick(Object element) {
        IRemoteFile remoteFile = (IRemoteFile)element;
        if (!remoteFile.canRead()) {
            return false;
        }
        if (!remoteFile.isArchive() || !remoteFile.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemConfiguration().supportsArchiveManagement()) {
            block25: {
                try {
                    remoteFile = remoteFile.getParentRemoteFileSubSystem().getRemoteFileObject(remoteFile.getAbsolutePath(), (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception exception) {}
                String absolutePath = remoteFile.getAbsolutePath();
                IFile localFile = null;
                if (remoteFile.getHost().getSystemType().isLocal()) {
                    localFile = SystemViewRemoteFileAdapter.getProjectFileForLocation(absolutePath);
                }
                if (localFile != null) {
                    try {
                        if (!localFile.exists()) {
                            localFile.refreshLocal(0, null);
                        }
                        SystemViewRemoteFileAdapter.openEditor(localFile, !remoteFile.canWrite());
                    }
                    catch (Exception e) {
                        SystemBasePlugin.logError((String)e.getLocalizedMessage(), (Throwable)e);
                        return false;
                    }
                    return true;
                }
                ISystemEditableRemoteObject editable = this.getEditableRemoteObject(remoteFile);
                if (editable != null) {
                    String remotePath = remoteFile.getAbsolutePath();
                    String replicaRemotePath = editable.getAbsolutePath();
                    if (!replicaRemotePath.equals(remotePath)) {
                        IEditorPart editor = editable.getEditorPart();
                        boolean editorWasClosed = false;
                        if (editor == null) {
                            editorWasClosed = true;
                        } else if (editor.isDirty()) {
                            editorWasClosed = editor.getEditorSite().getPage().closeEditor(editor, true);
                            if (editorWasClosed) {
                                editable.doImmediateSaveAndUpload();
                            }
                        } else {
                            editorWasClosed = editor.getEditorSite().getPage().closeEditor(editor, true);
                        }
                        if (!editorWasClosed) {
                            return false;
                        }
                        try {
                            IFile file = editable.getLocalResource();
                            file.delete(true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException coreException) {}
                        editable = this.getEditableRemoteObject(remoteFile);
                    }
                    try {
                        boolean isOpen = editable.checkOpenInEditor() != -1;
                        boolean isFileCached = this.isFileCached(editable, remoteFile);
                        if (isFileCached) {
                            if (!isOpen) {
                                editable.setLocalResourceProperties();
                                editable.addAsListener();
                            }
                            editable.openEditor();
                            break block25;
                        }
                        DownloadAndOpenJob oJob = new DownloadAndOpenJob(editable, false);
                        oJob.schedule();
                    }
                    catch (Exception exception) {}
                } else if (remoteFile.isDirectory()) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean isFileCached(ISystemEditableRemoteObject editable, IRemoteFile remoteFile) {
        boolean newFile;
        IFile file = editable.getLocalResource();
        SystemIFileProperties properties = new SystemIFileProperties((IResource)file);
        try {
            file.refreshLocal(0, null);
        }
        catch (CoreException e) {
            SystemBasePlugin.logError((String)e.getLocalizedMessage(), (Throwable)e);
        }
        boolean bl = newFile = !file.exists();
        if (!newFile) {
            boolean isReadOnly;
            long storedModifiedStamp = properties.getRemoteFileTimeStamp();
            long oldRemoteModifiedStamp = remoteFile.getLastModified();
            IRemoteFileSubSystem subsystem = remoteFile.getParentRemoteFileSubSystem();
            if (!subsystem.isOffline()) {
                remoteFile.markStale(true);
                try {
                    remoteFile = subsystem.getRemoteFileObject(remoteFile.getAbsolutePath(), (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception exception) {}
                ((SystemEditableRemoteFile)editable).setRemoteFile(remoteFile);
            }
            long remoteModifiedStamp = remoteFile.getLastModified();
            boolean dirty = properties.getDirty();
            boolean remoteNewer = oldRemoteModifiedStamp != remoteModifiedStamp || storedModifiedStamp != remoteModifiedStamp;
            String remoteEncoding = remoteFile.getEncoding();
            String storedEncoding = properties.getEncoding();
            boolean encodingChanged = storedEncoding == null || !remoteEncoding.equals(storedEncoding);
            boolean usedBinary = properties.getUsedBinaryTransfer();
            boolean isBinary = remoteFile.isBinary();
            boolean usedReadOnly = properties.getReadOnly();
            boolean bl2 = isReadOnly = !remoteFile.canWrite();
            return !dirty && !remoteNewer && usedBinary == isBinary && usedReadOnly == isReadOnly && !encodingChanged;
        }
        return false;
    }

    public boolean canEdit(Object element) {
        IRemoteFile remoteFile = (IRemoteFile)element;
        if (remoteFile.isFile()) {
            boolean offline = remoteFile.getParentRemoteFileSubSystem().isOffline();
            return remoteFile.canRead() && !offline;
        }
        return false;
    }

    public ISystemEditableRemoteObject getEditableRemoteObject(Object element) {
        RemoteFile remoteFile = (RemoteFile)element;
        if (remoteFile.isFile()) {
            String absolutePath = remoteFile.getAbsolutePath();
            IFile localProjectFile = null;
            if (remoteFile.getHost().getSystemType().isLocal()) {
                localProjectFile = SystemViewRemoteFileAdapter.getProjectFileForLocation(absolutePath);
            }
            try {
                SystemIFileProperties properties;
                Object obj;
                IFile file = null;
                file = localProjectFile == null ? this.getCachedCopy((IRemoteFile)remoteFile) : localProjectFile;
                if (file != null && (obj = (properties = new SystemIFileProperties((IResource)file)).getRemoteFileObject()) != null && obj instanceof SystemEditableRemoteFile) {
                    SystemEditableRemoteFile rmtObj = (SystemEditableRemoteFile)obj;
                    return rmtObj;
                }
                return new SystemEditableRemoteFile((IRemoteFile)remoteFile);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public IFile getCachedCopy(IRemoteFile remoteFile) throws SystemMessageException {
        IResource replica;
        if (SystemRemoteEditManager.getInstance().doesRemoteEditProjectExist() && (replica = UniversalFileTransferUtility.getTempFileFor(remoteFile)) != null && replica.exists()) {
            return (IFile)replica;
        }
        return null;
    }

    public String getFilterStringFor(Object object) {
        if (object instanceof IRemoteFile) {
            IRemoteFile remoteFile = (IRemoteFile)object;
            if (remoteFile.isDirectory()) {
                return String.valueOf(remoteFile.getAbsolutePath()) + remoteFile.getSeparator() + "*";
            }
            return remoteFile.getAbsolutePath();
        }
        return null;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (target instanceof IRemoteFile) {
            IRemoteFile tgt = (IRemoteFile)target;
            String inName = name.toLowerCase();
            if (inName.equals("classification")) {
                String classification = tgt.getClassification();
                if (classification != null) {
                    return StringCompare.compare((String)value, (String)classification, (boolean)true);
                }
            } else {
                if (inName.equals("name")) {
                    boolean caseSensitive = tgt.getParentRemoteFileSubSystem().isCaseSensitive();
                    String tgtName = this.getName(target);
                    String val = value;
                    if (!caseSensitive) {
                        tgtName = tgtName.toLowerCase();
                        val = val.toLowerCase();
                    }
                    if (val.endsWith("*")) {
                        return tgtName.startsWith(val.substring(0, val.length() - 1));
                    }
                    return val.equals(tgtName);
                }
                if (inName.equals("absolutePath".toLowerCase())) {
                    boolean caseSensitive = tgt.getParentRemoteFileSubSystem().isCaseSensitive();
                    String tgtPath = this.getAbsoluteName(target);
                    String val = value;
                    if (!caseSensitive) {
                        tgtPath = tgtPath.toLowerCase();
                        val = val.toLowerCase();
                    }
                    if (val.endsWith("*")) {
                        return tgtPath.startsWith(val.substring(0, val.length() - 1));
                    }
                    return val.equals(tgtPath);
                }
                if (inName.equals("extension")) {
                    boolean caseSensitive = tgt.getParentRemoteFileSubSystem().isCaseSensitive();
                    String tgtExtension = tgt.getExtension();
                    if (tgtExtension == null) {
                        return false;
                    }
                    StringTokenizer st = new StringTokenizer(value, " \t\n\r\f,");
                    String val = null;
                    while (st.hasMoreTokens()) {
                        val = st.nextToken();
                        if (!caseSensitive) {
                            tgtExtension = tgtExtension.toLowerCase();
                            val = val.toLowerCase();
                        }
                        boolean match = false;
                        match = val.endsWith("*") ? tgtExtension.startsWith(val.substring(0, val.length() - 1)) : val.equals(tgtExtension);
                        if (!match) continue;
                        return true;
                    }
                    return false;
                }
                if (inName.equals("isroot")) {
                    return tgt.isRoot() && value.equals("true") || !tgt.isRoot() && value.equals("false");
                }
                if (inName.equals("isfile")) {
                    return tgt.isFile() && value.equals("true") || !tgt.isFile() && value.equals("false");
                }
                if (inName.equals("isdirectory")) {
                    return tgt.isDirectory() && value.equals("true") || !tgt.isDirectory() && value.equals("false");
                }
                if (inName.equals("ishidden")) {
                    return tgt.isHidden() && value.equals("true") || !tgt.isHidden() && value.equals("false");
                }
                if (inName.equals("canread")) {
                    return tgt.canRead() && value.equals("true") || !tgt.canRead() && value.equals("false");
                }
                if (inName.equals("canwrite")) {
                    return tgt.canWrite() && value.equals("true") || !tgt.canWrite() && value.equals("false");
                }
                if (inName.equals("isbinary")) {
                    return tgt.isBinary() && value.equals("true") || !tgt.isBinary() && value.equals("false");
                }
                if (inName.equals("istext")) {
                    return tgt.isText() && value.equals("true") || !tgt.isText() && value.equals("false");
                }
                if (inName.equals("isarchive")) {
                    return tgt.isArchive() && value.equals("true") || !tgt.isArchive() && value.equals("false");
                }
                if (inName.equals("isvirtual")) {
                    return tgt instanceof IVirtualRemoteFile && value.equals("true") || !(tgt instanceof IVirtualRemoteFile) && value.equals("false");
                }
                if (inName.equals("isexecutable")) {
                    return tgt.isExecutable() && value.equals("true") || !tgt.isExecutable() && value.equals("false");
                }
                if (inName.equals("islink")) {
                    return tgt.isLink() && value.equals("true") || !tgt.isLink() && value.equals("false");
                }
                if (inName.equals("supportspermissions")) {
                    IFilePermissionsService service;
                    if (value.equals("true") && tgt instanceof IAdaptable && (service = (IFilePermissionsService)((IAdaptable)tgt).getAdapter(IFilePermissionsService.class)) != null) {
                        return (service.getCapabilities(tgt.getHostFile()) & 4) != 0;
                    }
                    return false;
                }
            }
        }
        return super.testAttribute(target, name, value);
    }

    public boolean supportsDeferredQueries(ISubSystem subSys) {
        if (subSys instanceof IRemoteFileSubSystem) {
            return ((IRemoteFileSubSystem)subSys).getParentRemoteFileSubSystemConfiguration().supportsDeferredQueries();
        }
        return !subSys.getHost().getSystemType().isLocal();
    }

    protected SystemFetchOperation getSystemFetchOperation(Object o, IElementCollector collector) {
        return new SystemFetchOperation(null, o, (ISystemViewElementAdapter)this, collector, true);
    }

    private static IFile getProjectFileForLocation(String absolutePath) {
        Path workspacePath = new Path(absolutePath);
        IFile file = SystemBasePlugin.getWorkspaceRoot().getFileForLocation((IPath)workspacePath);
        return file;
    }

    private static IContainer getProjectFolderForLocation(String absolutePath) {
        Path workspacePath = new Path(absolutePath);
        IContainer container = SystemBasePlugin.getWorkspaceRoot().getContainerForLocation((IPath)workspacePath);
        return container;
    }

    private static void openEditor(IFile localFile, boolean readOnly) throws PartInitException {
        IEditorDescriptor editorDescriptor = null;
        try {
            editorDescriptor = IDE.getEditorDescriptor((IFile)localFile);
        }
        catch (PartInitException e) {
            SystemBasePlugin.logError((String)e.getLocalizedMessage(), (Throwable)e);
        }
        if (editorDescriptor == null && PlatformUI.isWorkbenchRunning()) {
            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
            editorDescriptor = registry.findEditor("org.eclipse.ui.DefaultTextEditor");
        }
        IWorkbenchPage activePage = SystemBasePlugin.getActiveWorkbenchWindow().getActivePage();
        ResourceAttributes attr = localFile.getResourceAttributes();
        if (attr != null) {
            attr.setReadOnly(readOnly);
            try {
                localFile.setResourceAttributes(attr);
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        String editorId = null;
        if (editorDescriptor != null) {
            editorId = editorDescriptor.getId();
        }
        IDE.setDefaultEditor((IFile)localFile, (String)editorId);
        if (!editorDescriptor.isOpenExternal()) {
            FileEditorInput finput = new FileEditorInput(localFile);
            if (editorDescriptor != null && editorDescriptor.isOpenExternal()) {
                ((WorkbenchPage)activePage).openEditorFromDescriptor((IEditorInput)new FileEditorInput(localFile), editorDescriptor, true, null);
            } else {
                activePage.openEditor((IEditorInput)finput, editorDescriptor.getId());
            }
            return;
        }
        SystemViewRemoteFileAdapter.openSystemEditor(localFile);
    }

    private static void openSystemEditor(IFile localFile) throws PartInitException {
        IEditorDescriptor editorDescriptor = null;
        try {
            editorDescriptor = IDE.getEditorDescriptor((IFile)localFile);
        }
        catch (PartInitException e) {
            SystemBasePlugin.logError((String)e.getLocalizedMessage(), (Throwable)e);
        }
        if (editorDescriptor == null && PlatformUI.isWorkbenchRunning()) {
            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
            editorDescriptor = registry.findEditor("org.eclipse.ui.DefaultTextEditor");
        }
        IWorkbenchPage activePage = SystemBasePlugin.getActiveWorkbenchWindow().getActivePage();
        String editorId = null;
        if (editorDescriptor != null) {
            editorId = editorDescriptor.getId();
        }
        IDE.setDefaultEditor((IFile)localFile, (String)editorId);
        FileEditorInput fileInput = new FileEditorInput(localFile);
        activePage.openEditor((IEditorInput)fileInput, "org.eclipse.ui.systemExternalEditor");
    }

    class MultiFetchPermissionsJob
    extends Job {
        private List _files;
        private IFilePermissionsService _service;
        private boolean _started;

        public MultiFetchPermissionsJob(IFilePermissionsService service) {
            super(RSECoreMessages.RSESubSystemOperation_Get_properties_message);
            this._started = false;
            this._files = new ArrayList();
            this._service = service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
            IRemoteFile[] files = null;
            this._started = true;
            List list = this._files;
            synchronized (list) {
                files = this._files.toArray(new IRemoteFile[this._files.size()]);
            }
            int i = 0;
            while (i < files.length && !monitor.isCanceled()) {
                IRemoteFile rFile = files[i];
                try {
                    this._service.getFilePermissions(rFile.getHostFile(), monitor);
                    registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)rFile, 86, (Object)rFile));
                }
                catch (Exception exception) {}
                ++i;
            }
            SystemViewRemoteFileAdapter.this._permissionsJobMap.remove(this._service);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }

        public int size() {
            return this._files.size();
        }

        public boolean isStarted() {
            return this._started;
        }

        public void addFile(IRemoteFile file) {
            if (!this._files.contains(file)) {
                this._files.add(file);
            }
        }
    }

    public static class RenameRunnable
    implements Runnable {
        private IRemoteFile _targetFileOrFolder;
        private String _newName;
        private List _namesInUse = new ArrayList();

        public RenameRunnable(IRemoteFile targetFileOrFolder) {
            this._targetFileOrFolder = targetFileOrFolder;
        }

        public RenameRunnable(IRemoteFile targetFileOrFolder, List namesInUse) {
            this._targetFileOrFolder = targetFileOrFolder;
            this._namesInUse = namesInUse;
        }

        public void run() {
            ISystemValidator validator = null;
            SystemRenameSingleDialog dlg = this._namesInUse != null && this._namesInUse.size() > 0 ? new SystemRenameSingleDialog(null, true, (Object)this._targetFileOrFolder, validator, this._namesInUse) : new SystemRenameSingleDialog(null, true, (Object)this._targetFileOrFolder, validator);
            dlg.open();
            this._newName = !dlg.wasCancelled() ? dlg.getNewName() : null;
        }

        public String getNewName() {
            return this._newName;
        }
    }
}

