/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.jpt.common.core.JptWorkspace;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.JpaWorkspace;
import org.eclipse.jpt.jpa.core.internal.InternalJpaProjectManager;
import org.eclipse.jpt.jpa.core.internal.platform.InternalJpaPlatformManager;
import org.eclipse.jpt.jpa.db.ConnectionProfileFactory;

public class InternalJpaWorkspace
implements JpaWorkspace {
    private final IWorkspace workspace;
    private final JptWorkspace jptWorkspace;
    private final InternalJpaPlatformManager jpaPlatformManager;
    private final InternalJpaProjectManager jpaProjectManager;
    private final ConnectionProfileFactory connectionProfileFactory;

    public InternalJpaWorkspace(IWorkspace workspace) {
        this.workspace = workspace;
        this.jptWorkspace = this.buildJptWorkspace();
        this.jpaPlatformManager = this.buildJpaPlatformManager();
        this.jpaProjectManager = this.buildJpaProjectManager();
        this.connectionProfileFactory = this.buildConnectionProfileFactory();
    }

    public JptWorkspace getJptWorkspace() {
        return this.jptWorkspace;
    }

    private JptWorkspace buildJptWorkspace() {
        return (JptWorkspace)this.workspace.getAdapter(JptWorkspace.class);
    }

    public InternalJpaPlatformManager getJpaPlatformManager() {
        return this.jpaPlatformManager;
    }

    private InternalJpaPlatformManager buildJpaPlatformManager() {
        return new InternalJpaPlatformManager(this);
    }

    public InternalJpaProjectManager getJpaProjectManager() {
        return this.jpaProjectManager;
    }

    private InternalJpaProjectManager buildJpaProjectManager() {
        return new InternalJpaProjectManager(this);
    }

    public ConnectionProfileFactory getConnectionProfileFactory() {
        return this.connectionProfileFactory;
    }

    private ConnectionProfileFactory buildConnectionProfileFactory() {
        return (ConnectionProfileFactory)this.workspace.getAdapter(ConnectionProfileFactory.class);
    }

    public IWorkspace getWorkspace() {
        return this.workspace;
    }

    void initializeDefaultPreferences() {
        this.getJpaPlatformManager().initializeDefaultPreferences();
    }

    public void dispose() {
        this.jpaProjectManager.dispose();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (Object)this.workspace);
    }
}

