/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.internal.utility.JavaProjectTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaMappingRelationship;
import org.eclipse.jpt.jpa.core.context.java.JavaRelationshipMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaAttributeMapping;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.GenericJavaCascade;
import org.eclipse.jpt.jpa.core.jpa2.context.Cascade2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.MetamodelField2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.RelationshipMapping2_0;
import org.eclipse.jpt.jpa.core.resource.java.RelationshipMappingAnnotation;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaRelationshipMapping<A extends RelationshipMappingAnnotation>
extends AbstractJavaAttributeMapping<A>
implements JavaRelationshipMapping,
RelationshipMapping2_0 {
    protected String specifiedTargetEntity = this.buildSpecifiedTargetEntity();
    protected String defaultTargetEntity;
    protected String fullyQualifiedTargetEntity;
    protected final JavaMappingRelationship relationship = this.buildRelationship();
    protected final Cascade2_0 cascade = this.buildCascade();
    protected FetchType specifiedFetch = this.buildSpecifiedFetch();
    protected FetchType defaultFetch;

    protected AbstractJavaRelationshipMapping(JavaSpecifiedPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedTargetEntity_(this.buildSpecifiedTargetEntity());
        this.relationship.synchronizeWithResourceModel();
        this.cascade.synchronizeWithResourceModel();
        this.setSpecifiedFetch_(this.buildSpecifiedFetch());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultTargetEntity(this.buildDefaultTargetEntity());
        this.setFullyQualifiedTargetEntity(this.buildFullyQualifiedTargetEntity());
        this.relationship.update();
        this.cascade.update();
        this.setDefaultFetch(this.buildDefaultFetch());
    }

    @Override
    public String getTargetEntity() {
        return this.specifiedTargetEntity != null ? this.specifiedTargetEntity : this.defaultTargetEntity;
    }

    @Override
    public String getSpecifiedTargetEntity() {
        return this.specifiedTargetEntity;
    }

    @Override
    public void setSpecifiedTargetEntity(String entity) {
        if (ObjectTools.notEquals((Object)entity, (Object)this.specifiedTargetEntity)) {
            ((RelationshipMappingAnnotation)this.getAnnotationForUpdate()).setTargetEntity(entity);
            this.setSpecifiedTargetEntity_(entity);
        }
    }

    protected void setSpecifiedTargetEntity_(String entity) {
        String old = this.specifiedTargetEntity;
        this.specifiedTargetEntity = entity;
        this.firePropertyChanged("specifiedTargetEntity", old, entity);
    }

    protected String buildSpecifiedTargetEntity() {
        RelationshipMappingAnnotation annotation = (RelationshipMappingAnnotation)this.getMappingAnnotation();
        return annotation == null ? null : annotation.getTargetEntity();
    }

    @Override
    public String getDefaultTargetEntity() {
        return this.defaultTargetEntity;
    }

    protected void setDefaultTargetEntity(String entity) {
        String old = this.defaultTargetEntity;
        this.defaultTargetEntity = entity;
        this.firePropertyChanged("defaultTargetEntity", old, entity);
    }

    protected abstract String buildDefaultTargetEntity();

    @Override
    public String getFullyQualifiedTargetEntity() {
        return this.fullyQualifiedTargetEntity;
    }

    protected void setFullyQualifiedTargetEntity(String entity) {
        String old = this.fullyQualifiedTargetEntity;
        this.fullyQualifiedTargetEntity = entity;
        this.firePropertyChanged("fullyQualifiedTargetEntity", old, entity);
    }

    protected String buildFullyQualifiedTargetEntity() {
        return this.specifiedTargetEntity == null ? this.defaultTargetEntity : ((RelationshipMappingAnnotation)this.getMappingAnnotation()).getFullyQualifiedTargetEntityClassName();
    }

    @Override
    public Entity getResolvedTargetEntity() {
        return this.getPersistenceUnit().getEntity(this.fullyQualifiedTargetEntity);
    }

    public PersistentType getResolvedTargetType() {
        return this.getPersistenceUnit().getPersistentType(this.fullyQualifiedTargetEntity);
    }

    @Override
    public char getTargetEntityEnclosingTypeSeparator() {
        return '.';
    }

    @Override
    public JavaMappingRelationship getRelationship() {
        return this.relationship;
    }

    protected abstract JavaMappingRelationship buildRelationship();

    @Override
    public Cascade2_0 getCascade() {
        return this.cascade;
    }

    protected Cascade2_0 buildCascade() {
        return new GenericJavaCascade(this);
    }

    @Override
    public FetchType getFetch() {
        return this.specifiedFetch != null ? this.specifiedFetch : this.defaultFetch;
    }

    @Override
    public FetchType getSpecifiedFetch() {
        return this.specifiedFetch;
    }

    @Override
    public void setSpecifiedFetch(FetchType fetch) {
        if (ObjectTools.notEquals((Object)((Object)fetch), (Object)((Object)this.specifiedFetch))) {
            ((RelationshipMappingAnnotation)this.getAnnotationForUpdate()).setFetch(FetchType.toJavaResourceModel(fetch));
            this.setSpecifiedFetch_(fetch);
        }
    }

    protected void setSpecifiedFetch_(FetchType fetch) {
        FetchType old = this.specifiedFetch;
        this.specifiedFetch = fetch;
        this.firePropertyChanged("specifiedFetch", (Object)old, (Object)fetch);
    }

    protected FetchType buildSpecifiedFetch() {
        RelationshipMappingAnnotation annotation = (RelationshipMappingAnnotation)this.getMappingAnnotation();
        return annotation == null ? null : FetchType.fromJavaResourceModel(annotation.getFetch());
    }

    @Override
    public FetchType getDefaultFetch() {
        return this.defaultFetch;
    }

    protected void setDefaultFetch(FetchType fetch) {
        FetchType old = this.defaultFetch;
        this.defaultFetch = fetch;
        this.firePropertyChanged("defaultFetch", (Object)old, (Object)fetch);
    }

    protected abstract FetchType buildDefaultFetch();

    @Override
    public boolean isRelationshipOwner() {
        return this.relationship.isOwner();
    }

    @Override
    public boolean isOwnedBy(AttributeMapping mapping) {
        return mapping.isRelationshipOwner() && this.relationship.isOwnedBy((RelationshipMapping)mapping);
    }

    @Override
    public RelationshipMapping getRelationshipOwner() {
        Entity entity = this.getResolvedTargetEntity();
        if (entity == null) {
            return null;
        }
        for (PersistentAttribute attribute : entity.getPersistentType().getAllAttributes()) {
            AttributeMapping mapping = attribute.getMapping();
            if (!this.isOwnedBy(mapping)) continue;
            return (RelationshipMapping)mapping;
        }
        return null;
    }

    @Override
    public boolean isOverridableAssociationMapping() {
        return this.relationship.isOverridable();
    }

    @Override
    public Iterable<String> getAllTargetEntityAttributeNames() {
        return IterableTools.children(this.getAllTargetEntityAttributeMappings(), (Transformer)ALL_MAPPING_NAMES_TRANSFORMER);
    }

    protected Iterable<AttributeMapping> getAllTargetEntityAttributeMappings() {
        Entity entity = this.getResolvedTargetEntity();
        return entity != null ? entity.getAllAttributeMappings() : EmptyIterable.instance();
    }

    @Override
    public Iterable<String> getTargetEntityNonTransientAttributeNames() {
        return IterableTools.children(this.getTargetEntityNonTransientAttributeMappings(), (Transformer)ALL_MAPPING_NAMES_TRANSFORMER);
    }

    protected Iterable<AttributeMapping> getTargetEntityNonTransientAttributeMappings() {
        Entity entity = this.getResolvedTargetEntity();
        return entity != null ? entity.getNonTransientAttributeMappings() : EmptyIterable.instance();
    }

    protected String getTargetEntityIdAttributeName() {
        SpecifiedPersistentAttribute attribute = this.getTargetEntityIdAttribute();
        return attribute == null ? null : attribute.getName();
    }

    protected SpecifiedPersistentAttribute getTargetEntityIdAttribute() {
        Entity entity = this.getResolvedTargetEntity();
        return entity == null ? null : entity.getIdAttribute();
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.relationship.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public String getMetamodelTypeName() {
        return this.fullyQualifiedTargetEntity != null ? this.fullyQualifiedTargetEntity : MetamodelField2_0.DEFAULT_TYPE_NAME;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateTargetEntity(messages);
        this.relationship.validate(messages, reporter);
    }

    protected void validateTargetEntity(List<IMessage> messages) {
        if (this.getTargetEntity() == null) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(this.buildValidationMessage(this.getVirtualPersistentAttributeTextRange(), JptJpaCoreValidationMessages.VIRTUAL_ATTRIBUTE_TARGET_ENTITY_NOT_DEFINED, this.getName()));
            } else {
                messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.TARGET_ENTITY_NOT_DEFINED, this.getName()));
            }
            return;
        }
        IType targetEntityJdtType = JavaProjectTools.findType((IJavaProject)this.getJavaProject(), (String)this.getFullyQualifiedTargetEntity());
        if (targetEntityJdtType == null) {
            return;
        }
        if (this.getResolvedTargetEntity() == null) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(this.buildValidationMessage(this.getVirtualPersistentAttributeTextRange(), JptJpaCoreValidationMessages.VIRTUAL_ATTRIBUTE_TARGET_ENTITY_IS_NOT_AN_ENTITY, this.getName(), this.getFullyQualifiedTargetEntity()));
            } else {
                messages.add(this.buildValidationMessage(this.getTargetEntityTextRange(), JptJpaCoreValidationMessages.TARGET_ENTITY_IS_NOT_AN_ENTITY, this.getFullyQualifiedTargetEntity()));
            }
        }
    }

    protected TextRange getTargetEntityTextRange() {
        return this.getValidationTextRange(this.getAnnotationTargetEntityTextRange());
    }

    protected TextRange getAnnotationTargetEntityTextRange() {
        RelationshipMappingAnnotation annotation = (RelationshipMappingAnnotation)this.getMappingAnnotation();
        return annotation == null ? null : annotation.getTargetEntityTextRange();
    }
}

