/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.tasks.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.internal.tasks.ui.TaskListModifyOperation;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.monitor.core.InteractionEvent;

public class ChangeActivityHandleOperation
extends TaskListModifyOperation {
    private final String oldHandle;
    private final String newHandle;

    public ChangeActivityHandleOperation(String oldHandle, String newHandle) {
        this.oldHandle = oldHandle;
        this.newHandle = newHandle;
    }

    protected void operations(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        if (this.oldHandle == null || this.newHandle == null || this.oldHandle.equals(this.newHandle)) {
            return;
        }
        try {
            monitor.beginTask(Messages.ChangeActivityHandleOperation_Activity_migration, -1);
            this.refactorMetaContextHandles(this.oldHandle, this.newHandle);
            TasksUiPlugin.getTaskActivityMonitor().reloadActivityTime();
        }
        finally {
            monitor.done();
        }
    }

    private void refactorMetaContextHandles(String oldHandle, String newHandle) {
        ContextCorePlugin.getContextManager().saveActivityMetaContext();
        InteractionContext metaContext = ContextCorePlugin.getContextManager().getActivityMetaContext();
        ContextCorePlugin.getContextManager().resetActivityMetaContext();
        InteractionContext newMetaContext = ContextCorePlugin.getContextManager().getActivityMetaContext();
        for (InteractionEvent event : metaContext.getInteractionHistory()) {
            if (event.getStructureHandle() != null && event.getStructureHandle().equals(oldHandle)) {
                event = new InteractionEvent(event.getKind(), event.getStructureKind(), newHandle, event.getOriginId(), event.getNavigation(), event.getDelta(), event.getInterestContribution(), event.getDate(), event.getEndDate());
            }
            newMetaContext.parseEvent(event);
        }
        ContextCorePlugin.getContextManager().saveActivityMetaContext();
    }
}

